/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.graph__c;
import gen.lib.cgraph.node__c;
import gen.lib.gvc.gvc__c;
import gen.lib.gvc.gvlayout__c;
import h.ST_Agedge_s;
import h.ST_Agedgeinfo_t;
import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_Agraph_s;
import h.ST_GVC_s;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.gitlog.GNode;
import net.sourceforge.plantuml.gitlog.GitCurve;
import net.sourceforge.plantuml.gitlog.MagicBox;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.jsondiagram.Mirror;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import smetana.core.CString;
import smetana.core.Macro;
import smetana.core.Z;

public class SmetanaForGit {
    private final UGraphic ug;
    private final ISkinParam skinParam;
    private int num;
    private ST_Agraph_s g;
    private StringBounder stringBounder;
    private final Map<GNode, ST_Agnode_s> nodes = new LinkedHashMap<GNode, ST_Agnode_s>();
    private final List<ST_Agedge_s> edges = new ArrayList<ST_Agedge_s>();
    private Mirror yMirror;

    public SmetanaForGit(UGraphic ug, ISkinParam skinParam) {
        this.stringBounder = ug.getStringBounder();
        this.skinParam = skinParam;
        this.ug = this.getStyle().applyStrokeAndLineColor(ug, skinParam.getIHtmlColorSet());
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.gitDiagram).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private HColor arrowColor() {
        return this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
    }

    public void drawMe(Collection<GNode> gnodes) {
        this.initGraph(gnodes);
        for (Map.Entry<GNode, ST_Agnode_s> ent : this.nodes.entrySet()) {
            ST_Agnode_s node = ent.getValue();
            UTranslate pos = this.getPosition(node);
            MagicBox magicBox = new MagicBox(this.skinParam, ent.getKey());
            magicBox.drawBorder(this.ug.apply(pos), this.getSize(node));
        }
        for (ST_Agedge_s edge : this.edges) {
            ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)Macro.AGDATA(edge);
            new GitCurve(data, this.yMirror).drawCurve(this.arrowColor(), this.ug);
        }
    }

    private XDimension2D getSize(ST_Agnode_s node) {
        ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)Macro.AGDATA(node);
        double width = data.width * 72.0;
        double height = data.height * 72.0;
        return new XDimension2D(width, height);
    }

    private UTranslate getPosition(ST_Agnode_s node) {
        ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)Macro.AGDATA(node);
        double width = data.width * 72.0;
        double height = data.height * 72.0;
        double x = data.coord.x;
        double y = data.coord.y;
        return new UTranslate(x - width / 2.0, this.yMirror.inv(y + height / 2.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGraph(Collection<GNode> gnodes) {
        if (this.g != null) {
            return;
        }
        Z.open();
        try {
            this.g = graph__c.agopen(new CString("g"), Z.z().Agdirected, null);
            attr__c.agsafeset(this.g, new CString("ranksep"), new CString("0.35"), new CString(""));
            for (GNode gnode : gnodes) {
                XDimension2D dim = new MagicBox(this.skinParam, gnode).getBigDim(this.stringBounder);
                this.nodes.put(gnode, this.createNode(dim));
            }
            for (GNode gnode : this.nodes.keySet()) {
                for (GNode parent : gnode.getDowns()) {
                    ST_Agedge_s edge = this.createEdge(gnode, parent);
                    if (edge == null) continue;
                    this.edges.add(edge);
                }
            }
            ST_GVC_s gvc = gvc__c.gvContext(new Object[0]);
            gvlayout__c.gvLayoutJobs(gvc, this.g);
            double max = 0.0;
            for (ST_Agnode_s node : this.nodes.values()) {
                ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)Macro.AGDATA(node);
                double height = data.height * 72.0;
                double y = data.coord.y;
                max = Math.max(max, y + height);
            }
            this.yMirror = new Mirror(max);
        }
        finally {
            Z.close();
        }
    }

    private ST_Agedge_s createEdge(GNode node0, GNode node1) {
        ST_Agnode_s a0 = this.nodes.get(node0);
        ST_Agnode_s a1 = this.nodes.get(node1);
        if (a0 == null || a1 == null) {
            return null;
        }
        ST_Agedge_s edge = edge__c.agedge(this.g, a0, a1, null, true);
        attr__c.agsafeset(edge, new CString("arrowsize"), new CString(".7"), new CString(""));
        attr__c.agsafeset(edge, new CString("arrowtail"), new CString("none"), new CString(""));
        attr__c.agsafeset(edge, new CString("arrowhead"), new CString("normal"), new CString(""));
        return edge;
    }

    private ST_Agnode_s createNode(XDimension2D dim) {
        String width = "" + dim.getWidth() / 72.0;
        String height = "" + dim.getHeight() / 72.0;
        ST_Agnode_s node = node__c.agnode(this.g, new CString("N" + this.num), true);
        node.NAME = "N " + this.num;
        ++this.num;
        attr__c.agsafeset(node, new CString("shape"), new CString("box"), new CString(""));
        attr__c.agsafeset(node, new CString("height"), new CString("" + height), new CString(""));
        attr__c.agsafeset(node, new CString("width"), new CString("" + width), new CString(""));
        return node;
    }
}

