/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.Color;
import java.util.Objects;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class ColorPalette {
    private static final String colorValue = "!#$%&*+-:;<=>?@^_~GHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public char getCharFor(Color dest) {
        return this.getCharFor(HColors.simple(dest));
    }

    public char getCharFor(HColor dest) {
        char result = '\u0000';
        int resultDist = Integer.MAX_VALUE;
        for (int i = 0; i < colorValue.length(); ++i) {
            char c = colorValue.charAt(i);
            int dist = ((HColorSimple)dest).distanceTo((HColorSimple)this.getHtmlColorSimpleFor(c));
            if (dist >= resultDist) continue;
            result = c;
            resultDist = dist;
        }
        assert (result != '\u0000');
        return result;
    }

    private HColor getHtmlColorSimpleFor(char c) {
        Color color = Objects.requireNonNull(this.getColorFor(c));
        return HColors.simple(color);
    }

    public Color getColorFor(char c) {
        int col = colorValue.indexOf(c);
        if (col == -1) {
            return null;
        }
        int blue = col % 4 * 85;
        int green = col / 4 % 4 * 85;
        int red = col / 16 % 4 * 85;
        return new Color(red, green, blue);
    }
}

