/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.MiddleCircleCircledMode;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

class MiddleCircleCircled
extends Extremity {
    private final HColor diagramBackColor;
    private final double angle;
    private final MiddleCircleCircledMode mode;
    private final double radius1 = 6.0;
    private final UEllipse circle = new UEllipse(12.0, 12.0);
    private final double radius2 = 10.0;
    private final UEllipse bigcircle = new UEllipse(20.0, 20.0);
    private final HColor backColor;

    public MiddleCircleCircled(double angle, MiddleCircleCircledMode mode, HColor backColor, HColor diagramBackColor) {
        this.angle = angle;
        this.mode = mode;
        this.backColor = backColor;
        this.diagramBackColor = diagramBackColor;
    }

    @Override
    public XPoint2D somePoint() {
        return null;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.mode == MiddleCircleCircledMode.BOTH) {
            ug.apply(this.diagramBackColor).apply(this.diagramBackColor.bg()).apply(new UTranslate(-10.0, -10.0)).draw(this.bigcircle);
        }
        ug = ug.apply(this.backColor.bg());
        ug = ug.apply(new UStroke(1.5));
        double d = 0.0;
        if (this.mode == MiddleCircleCircledMode.MODE1 || this.mode == MiddleCircleCircledMode.BOTH) {
            UEllipse arc1 = new UEllipse(20.0, 20.0, this.angle, 90.0);
            ug.apply(HColors.none().bg()).apply(new UTranslate(-10.0, -10.0)).draw(arc1);
        }
        if (this.mode == MiddleCircleCircledMode.MODE2 || this.mode == MiddleCircleCircledMode.BOTH) {
            UEllipse arc2 = new UEllipse(20.0, 20.0, this.angle + 180.0, 90.0);
            ug.apply(HColors.none().bg()).apply(new UTranslate(-10.0, -10.0)).draw(arc2);
        }
        ug.apply(new UTranslate(-6.0, -6.0)).draw(this.circle);
    }
}

