/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PlayerBinary
extends Player {
    private static final String LOW_STRING = "0";
    private static final String HIGH_STRING = "1";
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final SortedMap<TimeTick, ChangeState> values = new TreeMap<TimeTick, ChangeState>();
    private ChangeState initialState;
    private final double ymargin = 8.0;

    public PlayerBinary(String code, ISkinParam skinParam, TimingRuler ruler, boolean compact, Stereotype stereotype) {
        super(code, skinParam, ruler, compact, stereotype);
        this.suggestedHeight = 30;
    }

    private double getHeightForConstraints(StringBounder stringBounder) {
        return TimeConstraint.getHeightForConstraints(stringBounder, this.constraints);
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + (double)this.suggestedHeight;
    }

    @Override
    protected StyleSignature getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.binary).withTOBECHANGED(this.stereotype);
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        return new IntricatedPoint(new XPoint2D(x, this.getYpos(stringBounder, HIGH_STRING)), new XPoint2D(x, this.getYpos(stringBounder, HIGH_STRING)));
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        ChangeState cs = new ChangeState(now, comment, color, this.convert(states));
        if (now == null) {
            this.initialState = cs;
        } else {
            this.values.put(now, cs);
        }
    }

    private String[] convert(String[] states) {
        if (states.length == 1) {
            return new String[]{this.convert(states[0])};
        }
        return new String[]{this.convert(states[0]), this.convert(states[1])};
    }

    private String convert(String value) {
        if (HIGH_STRING.equals(value) || "high".equalsIgnoreCase(value)) {
            return HIGH_STRING;
        }
        return LOW_STRING;
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message, ArrowConfiguration config) {
        this.constraints.add(new TimeConstraint(2.5, tick1, tick2, message, this.skinParam, config));
    }

    private double getYpos(StringBounder stringBounder, String state) {
        if (state.equalsIgnoreCase(LOW_STRING)) {
            return this.getYlow(stringBounder);
        }
        return this.getYhigh(stringBounder);
    }

    private double getYlow(StringBounder stringBounder) {
        return this.getFullHeight(stringBounder) - 8.0;
    }

    private double getYhigh(StringBounder stringBounder) {
        return 8.0 + this.getHeightForConstraints(stringBounder);
    }

    @Override
    public TextBlock getPart1(double fullAvailableWidth, double specialVSpace) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                TextBlock title = PlayerBinary.this.getTitle();
                XDimension2D dim = title.calculateDimension(stringBounder);
                double y = (PlayerBinary.this.getFullHeight(stringBounder) - dim.getHeight()) / 2.0;
                title.drawU(ug.apply(UTranslate.dy(y)));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dim = PlayerBinary.this.getTitle().calculateDimension(stringBounder);
                return dim.delta(5.0, 0.0);
            }
        };
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = PlayerBinary.this.getContext().apply(ug);
                double lastx = 0.0;
                List<String> lastValues = PlayerBinary.this.initialState == null ? Collections.singletonList(PlayerBinary.LOW_STRING) : PlayerBinary.this.initialState.getStates();
                StringBounder stringBounder = ug.getStringBounder();
                double yhigh = PlayerBinary.this.getYhigh(stringBounder);
                double ylow = PlayerBinary.this.getYlow(stringBounder);
                ULine vline = ULine.vline(ylow - yhigh);
                for (Map.Entry ent : PlayerBinary.this.values.entrySet()) {
                    ChangeState value = (ChangeState)ent.getValue();
                    double x = PlayerBinary.this.ruler.getPosInPixel((TimeTick)ent.getKey());
                    if (lastValues.size() == 1) {
                        ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(stringBounder, lastValues.get(0)))).draw(ULine.hline(x - lastx));
                    } else {
                        for (double tmpx = lastx; tmpx < x; tmpx += 5.0) {
                            ug.apply(new UTranslate(tmpx, yhigh)).draw(vline);
                        }
                    }
                    if (!lastValues.equals(value.getStates())) {
                        ug.apply(new UTranslate(x, yhigh)).draw(vline);
                    }
                    if (value.getComment() != null) {
                        TextBlock label = PlayerBinary.this.getTextBlock(value.getComment());
                        label.drawU(ug.apply(new UTranslate(x + 2.0, yhigh)));
                    }
                    lastx = x;
                    lastValues = value.getStates();
                }
                ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(stringBounder, lastValues.get(0)))).draw(ULine.hline(PlayerBinary.this.ruler.getWidth() - lastx));
                PlayerBinary.this.drawConstraints(ug.apply(UTranslate.dy(PlayerBinary.this.getHeightForConstraints(ug.getStringBounder()))));
            }
        };
    }

    protected final FontConfiguration getCommentFontConfiguration() {
        return FontConfiguration.create(this.skinParam, this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder()));
    }

    private TextBlock getTextBlock(String value) {
        Display display = Display.getWithNewlines(value);
        return display.create(this.getCommentFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private void drawConstraints(UGraphic ug) {
        for (TimeConstraint constraint : this.constraints) {
            constraint.drawU(ug, this.ruler);
        }
    }
}

