/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.image.ContainingEllipse;
import net.sourceforge.plantuml.svek.image.Footprint;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockInEllipse
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock text;
    private final ContainingEllipse ellipse;

    public TextBlockInEllipse(TextBlock text, StringBounder stringBounder) {
        this.text = text;
        XDimension2D textDim = text.calculateDimension(stringBounder);
        double alpha = textDim.getHeight() / textDim.getWidth();
        if (alpha < 0.2) {
            alpha = 0.2;
        } else if (alpha > 0.8) {
            alpha = 0.8;
        }
        Footprint footprint = new Footprint(stringBounder);
        this.ellipse = footprint.getEllipse(text, alpha);
    }

    public UEllipse getUEllipse() {
        return this.ellipse.asUEllipse().bigger(6.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse sh = this.getUEllipse();
        XPoint2D center = this.ellipse.getCenter();
        double dx = sh.getWidth() / 2.0 - center.getX();
        double dy = sh.getHeight() / 2.0 - center.getY();
        ug.draw(sh);
        this.text.drawU(ug.apply(new UTranslate(dx, dy - 2.0)));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getUEllipse().getDimension();
    }

    public void setDeltaShadow(double deltaShadow) {
        this.ellipse.setDeltaShadow(deltaShadow);
    }
}

