/////////////////////////////////////////////////////////////////////////////
//    License (GPLv2+):
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful, but
//    WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
/////////////////////////////////////////////////////////////////////////////
/** 
 * @file  ConfigLog.h
 *
 * @brief Declaration file ConfigLog class
 */
// RCS ID line follows -- this is updated by CVS
// $Id: ConfigLog.h,v 1.9 2004/09/01 07:16:36 kimmov Exp $

#ifndef _CONFIGLOG_H_
#define _CONFIGLOG_H_

/** 
 * @brief View settings for directory compare
 */
struct VIEWSETTINGS
{
	BOOL bShowIdent;
	BOOL bShowDiff;
	BOOL bShowUniqueLeft;
	BOOL bShowUniqueRight;
	BOOL bShowBinaries;
	BOOL bShowSkipped;
	BOOL bHideBak;
};

/** 
 * @brief Misc WinMerge settings
 */
struct MISCSETTINGS
{
	BOOL bAutomaticRescan;
	BOOL bAllowMixedEol;
	BOOL bScrollToFirst;
	BOOL bBackup;
	BOOL bViewWhitespace;
	BOOL bMovedBlocks;
	BOOL bDetectCodepage;
};

/** 
 * @brief Codepage WinMerge settings
 */
struct CPSETTINGS
{
	int nDefaultMode;
	int nDefaultCustomValue;
	int iDetectCodepageType;
};

/** 
 * @brief Class for saving configuration log file
 */
class CConfigLog
{
public:

	DIFFOPTIONS m_diffOptions;
	VIEWSETTINGS m_viewSettings;
	MISCSETTINGS m_miscSettings;
	CPSETTINGS m_cpSettings;

	CString GetFileName() const;
	void WritePluginsInLogFile(LPCWSTR transformationEvent, CStdioFile & file);
	BOOL WriteLogFile(CString &sError);
	CString GetWindowsVer();
	CString GetBuildFlags();

private:
	CString m_sFileName;

};

#endif /* _CONFIGLOG_H_ */