//
// RawSocketTest.cpp
//
// $Id: //poco/1.4/Net/testsuite/src/RawSocketTest.cpp#1 $
//
// Copyright (c) 2005-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "RawSocketTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/Net/RawSocket.h"
#include "Poco/Net/RawSocketImpl.h"
#include "Poco/Net/SocketAddress.h"
#include "Poco/Net/NetException.h"
#include "Poco/Timespan.h"
#include "Poco/Stopwatch.h"


using Poco::Net::Socket;
using Poco::Net::RawSocket;
using Poco::Net::RawSocketImpl;
using Poco::Net::SocketAddress;
using Poco::Net::IPAddress;
using Poco::Timespan;
using Poco::Stopwatch;
using Poco::TimeoutException;
using Poco::InvalidArgumentException;
using Poco::IOException;


RawSocketTest::RawSocketTest(const std::string& name): CppUnit::TestCase(name)
{
}


RawSocketTest::~RawSocketTest()
{
}


void RawSocketTest::testEchoIPv4()
{
	SocketAddress sa("localhost", 0);
	RawSocket rs(IPAddress::IPv4);
	rs.connect(sa);

	int n = rs.sendBytes("hello", 5);
	assert (5 == n);

	char buffer[256] = "";
	unsigned char* ptr = (unsigned char*) buffer;

	n = rs.receiveBytes(buffer, sizeof(buffer));
	int shift = ((buffer[0] & 0x0F) * 4);
	ptr += shift;

	assert (5 == (n - shift));
	assert ("hello" == std::string((char*)ptr, 5));

	rs.close(); 
}


void RawSocketTest::testSendToReceiveFromIPv4()
{
	RawSocket rs(IPAddress::IPv4);
	
	int n = rs.sendTo("hello", 5, SocketAddress("localhost", 0));
	assert (n == 5);

	char buffer[256] = "";
	unsigned char* ptr = (unsigned char*) buffer;
	SocketAddress sa;
	n = rs.receiveFrom(buffer, sizeof(buffer), sa);
	int shift = ((buffer[0] & 0x0F) * 4);
	ptr += shift;

	assert ((n - shift) == 5);
	assert ("hello" == std::string((char*)ptr, 5));
	rs.close();
}


void RawSocketTest::setUp()
{
}


void RawSocketTest::tearDown()
{
}


CppUnit::Test* RawSocketTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("RawSocketTest");

	CppUnit_addTest(pSuite, RawSocketTest, testEchoIPv4);
	CppUnit_addTest(pSuite, RawSocketTest, testSendToReceiveFromIPv4);

	return pSuite;
}
