//
// DialogServer.h
//
// $Id: //poco/1.4/Net/testsuite/src/DialogServer.h#1 $
//
// Definition of the DialogServer class.
//
// Copyright (c) 2005-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef DialogServer_INCLUDED
#define DialogServer_INCLUDED


#include "Poco/Net/Net.h"
#include "Poco/Net/ServerSocket.h"
#include "Poco/Net/StreamSocket.h"
#include "Poco/Thread.h"
#include "Poco/Event.h"
#include "Poco/Mutex.h"
#include <vector>


class DialogServer: public Poco::Runnable
	/// A server for testing FTPClientSession and friends.
{
public:
	DialogServer(bool acceptCommands = true);
		/// Creates the DialogServer.

	~DialogServer();
		/// Destroys the DialogServer.

	Poco::UInt16 port() const;
		/// Returns the port the echo server is
		/// listening on.
		
	void run();
		/// Does the work.
		
	const std::string& lastCommand() const;
		/// Returns the last command received by the server.

	std::string popCommand();
		/// Pops the next command from the list of received commands.

	std::string popCommandWait();
		/// Pops the next command from the list of received commands.
		/// Waits until a command is available.

	const std::vector<std::string>& lastCommands() const;
		/// Returns the last command received by the server.
		
	void addResponse(const std::string& response);
		/// Sets the next response returned by the server.
	
	void clearCommands();
		/// Clears all commands.
		
	void clearResponses();
		/// Clears all responses.
		
	void log(bool flag);
		/// Enables or disables logging to stdout.
	
private:
	Poco::Net::ServerSocket  _socket;
	Poco::Thread             _thread;
	Poco::Event              _ready;
	mutable Poco::FastMutex  _mutex;
	bool                     _stop;
	std::vector<std::string> _nextResponses;
	std::vector<std::string> _lastCommands;
	bool                     _acceptCommands;
	bool                     _log;
};


#endif // DialogServer_INCLUDED
