//
// RandomStreamTest.cpp
//
// $Id: //poco/1.4/Foundation/testsuite/src/RandomStreamTest.cpp#1 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "RandomStreamTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/RandomStream.h"
#include <vector>
#include <cmath>


using Poco::RandomInputStream;


RandomStreamTest::RandomStreamTest(const std::string& name): CppUnit::TestCase(name)
{
}


RandomStreamTest::~RandomStreamTest()
{
}


void RandomStreamTest::testStream()
{
	RandomInputStream rnd;
	
	const int n = 16;
	std::vector<int> d(n, 0);
	for (int i = 0; i < 1000; ++i)
	{
		unsigned char c;
		rnd >> c;
		d[c & 0x0F]++;
		d[(c >> 4) & 0x0F]++;
	}
	int sum = 0;
	for (int k = 0; k < n; ++k) sum += d[k];
	int avg = sum/n;
	int var = 0;
	for (int k = 0; k < n; ++k) var += (d[k] - avg)*(d[k] - avg);
	var /= n;
	int sd = int(std::sqrt((double) var));
	
	assert (110 < avg && avg < 140);
	assert (sd < 20);
}


void RandomStreamTest::setUp()
{
}


void RandomStreamTest::tearDown()
{
}


CppUnit::Test* RandomStreamTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("RandomStreamTest");

	CppUnit_addTest(pSuite, RandomStreamTest, testStream);

	return pSuite;
}
