#include <cstring>
#include <cstdio>
#include <cassert>
#include <vector>
#include <icu.h>

#pragma comment(lib, "icu.lib")

struct ICUBreakIterator
{
	static const UChar *kCustomRules;
	static const UChar *kCustomWordBreakRules;
};
#include "../editlib/utils/icurules.h"

bool createBinaryRulesHeaderFile(const UChar* rules, const char *name, const char* filename)
{
	UErrorCode status = U_ZERO_ERROR;
	UParseError parseError;
	std::vector<uint8_t> binaryRules(64 * 1024);

	UBreakIterator *iter = ubrk_openRules(rules, static_cast<int32_t>(wcslen(reinterpret_cast<const wchar_t *>(rules))), nullptr, 0, &parseError, &status);
	int32_t size = ubrk_getBinaryRules(iter, binaryRules.data(), binaryRules.size(), &status);

	FILE* fp = nullptr;
	fopen_s(&fp, filename, "wt");
	if (!fp)
		return false;

	fprintf(fp, "/* The file is generated by the icudata.exe */\n");
	fprintf(fp, "const uint32_t %s_size = %d;\n", name, size);
	fprintf(fp, "const uint8_t %s[] = {\n", name);
	for (int32_t i = 0; i < size; ++i)
	{
		fprintf(fp, "0x%02x,", binaryRules[i]);
		if ((i % 16) == 15)
			fprintf(fp, "\n");
	}
	fprintf(fp, "};\n");

	fclose(fp);

	return true;
}

int main()
{
	assert(createBinaryRulesHeaderFile(ICUBreakIterator::kCustomRules, "ICUBreakIterator::kCustomBinaryRules", "../editlib/utils/icucharbrkbinrules.h"));
	assert(createBinaryRulesHeaderFile(ICUBreakIterator::kCustomWordBreakRules, "ICUBreakIterator::kCustomWordBreakBinaryRules", "../editlib/utils/icuwordbrkbinrules.h"));
}

