//
// CountingStreamTest.cpp
//
// $Id: //poco/1.4/Foundation/testsuite/src/CountingStreamTest.cpp#1 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "CountingStreamTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/CountingStream.h"
#include <sstream>


using Poco::CountingInputStream;
using Poco::CountingOutputStream;


CountingStreamTest::CountingStreamTest(const std::string& name): CppUnit::TestCase(name)
{
}


CountingStreamTest::~CountingStreamTest()
{
}


void CountingStreamTest::testInput()
{
	char c;
	std::istringstream istr1("foo");
	CountingInputStream ci1(istr1);
	while (ci1.good()) ci1.get(c);
	assert (ci1.lines() == 1);
	assert (ci1.chars() == 3);
	assert (ci1.pos() == 3);

	std::istringstream istr2("foo\nbar");
	CountingInputStream ci2(istr2);
	while (ci2.good()) ci2.get(c);
	assert (ci2.lines() == 2);
	assert (ci2.chars() == 7);
	assert (ci2.pos() == 3);

	std::istringstream istr3("foo\nbar\n");
	CountingInputStream ci3(istr3);
	while (ci3.good()) ci3.get(c);
	assert (ci3.lines() == 2);
	assert (ci3.chars() == 8);
	assert (ci3.pos() == 0);
}


void CountingStreamTest::testOutput()
{
	std::ostringstream ostr1;
	CountingOutputStream co1(ostr1);
	co1 << "foo";
	assert (ostr1.str() == "foo");
	assert (co1.lines() == 1);
	assert (co1.chars() == 3);
	assert (co1.pos() == 3);

	std::ostringstream ostr2;
	CountingOutputStream co2(ostr2);
	co2 << "foo\nbar";
	assert (ostr2.str() == "foo\nbar");
	assert (co2.lines() == 2);
	assert (co2.chars() == 7);
	assert (co2.pos() == 3);

	CountingOutputStream co3;
	co3 << "foo\nbar\n";
	assert (co3.lines() == 2);
	assert (co3.chars() == 8);
	assert (co3.pos() == 0);
}


void CountingStreamTest::setUp()
{
}


void CountingStreamTest::tearDown()
{
}


CppUnit::Test* CountingStreamTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("CountingStreamTest");

	CppUnit_addTest(pSuite, CountingStreamTest, testInput);
	CppUnit_addTest(pSuite, CountingStreamTest, testOutput);

	return pSuite;
}
