# WinMerge 2.16.16 リリースノート

- [このリリースについて](#about-this-release)
- [2.16.16の新機能](#what-is-new-in-21616)
- [2.16.15 beta の新機能](#what-is-new-in-21615-beta)
- [既知の問題](#known-issues)

2021年10月

## このリリースについて

WinMerge の 2.16.16 安定版リリースです。
このリリースは、以前の WinMerge 安定版リリースに代わる推奨リリースです。

不具合は <a href="http://github.com/winmerge/winmerge/issues">bug-tracker</a> で報告してください。
日本語での報告は、<a href="https://osdn.net/projects/winmerge-jp/ticket/">こちら</a>でお願いします。

## 2.16.16 の新機能

### 全般

- Windows コモンダイアログに表示されるテキストが、言語を切り替えたときに
    その言語に変更されない。

### ファイル比較

- 不具合修正: 保存に失敗したときに適切なメッセージが表示されない。

### テーブル比較

- 不具合修正: 最後の列の幅を変更できないことがある。 (#998)
- 外部のアプリケーション等が編集中のファイルを更新後、WinMergeが再読み込みした
    とき、列の幅を再計算しないように変更。 (#951)

### 画像比較

- 不具合修正: 画像比較ウインドウへのファイルのドラッグ＆ドロップが2回目以降
    受け付けられない。

### フォルダ比較

- 不具合修正: ファイルを大量にコピー後、操作できなくなる時間が長い。 (#771)
- 不具合修正: 1つのプロジェクトファイルに複数の比較設定がされ、それぞれ異なる
    ファイルフィルタが指定された場合、ファイルフィルタが正しく適用されない。
    (PR #995)
- 画像サイズとファイルサイズの差異を列に表示できるようにした。 (#131)
    (以下のPRで実現)
- Windowsプロパティシステムから取得したファイルの各プロパティ値と
    ハッシュ値(MD5, SHA-1, SHA-256)を列に表示できるようにした。 (PR #996)

### オプションダイアログ

- 不具合修正: [Windows 11 以降用シェル拡張を登録]ボタンを別ユーザが押した後、
    このボタンが有効にならない。

### プラグイン

- 不具合修正: get_PluginUnpackedFileExtension で指定した拡張子に対応する
    シンタックスハイライトがされない。 (#983)
- 不具合修正: リンク先が存在しないショートカットのMS Officeドキュメントを
    開くとエラーメッセージがWinMergeの後ろに隠れてしまう。 (#1007)
- Apache Tika プラグイン: Apache tika を 2.1.0 に更新し、ダウンロード元URLを
    変更。
- CompareMSExcelFiles.sct: [ワークブックの情報を複数ファイルに展開する]
    が有効のとき、ファイル名に含まれるシート名の前の数値をゼロパッデングにした。

### シェルエクステンション

- 不具合修正: MSVCP140.dll VCRUNTIME140*.dll がインストールされていないPCで
    Windows 11 用のシェルエクステンションが動作しない。
- 不具合修正: 65536以上ファイルを選択すると無限ループする。 (PR #987)
- Windows 11用シェルエクステンションから起動したWinMergeでおこなった設定変更が、
    通常起動したWinMergeに反映されない。

### マニュアル

- 4.1 Using profile file 修正 (#1004)

### 翻訳

- 翻訳の更新:
  - Galician (PR #1005)
  - German (PR #986)
  - Hungarian (PR #991,#1023)
  - Japanese
  - Lithuanian (PR #979)
  - Portuguese (PR #1017)
  - Slovenian (#1026)
  - Turkish (PR #980)

### 内部変更

- 不具合修正: ALL.sln のビルドでエラーが発生する。 (#985)
- OpenView.cpp ファイル内のタイポ修正 (PR #1000)

## 2.16.15 Beta の新機能

### 全般

- 不具合修正: INIファイルに不正な値が含まれているときにクラッシュする。
- 不具合修正: 特定の環境でWinMergeが起動してすぐにクラッシュする。
    (#808, #908, #913)
- 不具合修正: Windows 11 で選択されたメニューの文字の色が標準の色(白色)に
    ならない
- 不具合修正: WinMergeを閉じたのにプロセスが残ったままになるもう一つの問題を
    修正 (#903)
- Windows11用のShellExtensionに必要なためコード署名をするようした (#152)

### ファイル比較

- 不具合修正: プラグインメニューの表示等で時間がかかっている場合にマウスカーソル
    が砂時計になっていなかった。
- 不具合修正: 3ファイル比較時、[中央のファイルを保存]、
    [名前をつけて中央のファイルを保存]メニューが有効にならなかった。
- 不具合修正: [ファイル]→[新規(3ペイン)]→[テーブル]メニューを選択すると、
    2ペインのウインドウが表示されてしまう。
- 不具合修正: 3ペイン表示時、Diffペインの高さの計算が間違っていた。
- 不具合修正: 一部のUnicode文字を含む文字列を正規表現で検索するとハイライトが
    正しく行われない。 (#914)
- 不具合修正: Shift+F4キー押下でクラッシュすることがあった。
- 不具合修正: 大量の置換に時間がかかる。 (#940)
- 不具合修正: 左側ペインをクリック後Shiftキーを押しながらロケーションペインの
    左側バーをクリックしたとき、右側ペインも選択されてしまう。 (#970)
- 不具合修正: Diffペインを再表示したときのスクロール位置が正しくない。
    (osdn.net #42862)
- 検索ウインドウの "このダイアログ ボックスを閉じない" チェックボックス
    のデフォルトをオンにする。 (#941)

### 画像比較

- 不具合修正: コンテキストメニューのキーボードアクセラレーターが被っていた。
   (#905)
- 不具合修正: ロケーションペインのコントロールの配置、サイズ変更時の動作を
    改善 (winimerge #24)

### プロジェクトファイル

- プロジェクトファイルに比較オプションを保存するようにした。(#498) (PR #915)

### オプションダイアログ

- プロジェクトファイルに保存する項目や復元する項目の除外/包含を指定できる
    ようにした。(PR #953)

### プラグイン

- 以下の展開プラグインを追加:
  - DecompileJVM
  - DecompileIL
  - DisassembleNative

### コマンドライン

- /c 列位置を追加
- /EnableExitCode を追加(プロセスの終了コードに比較結果が格納されます。
    (0:ファイルが一致している場合、1:差異がある場合、2:何らかのエラー)

### シェルエクステンション

- 不具合修正:  ナビケーションペインでWinMergeの拡張メニューが二重に表示される。
    (osdn.net #42702)
- 不具合修正: 拡張メニューで中央として開くファイルを選択できるようにした。
    (#249)
- Windows 11 のエクスプローラのコンテキストメニュー用
    ShellExtension(WinMergeContextMenu.dll)を追加。 (PR #954)

### Translations

- 翻訳の更新:
  - Brazilian (PR #910)
  - Dutch (PR #921,#969)
  - German (PR #965,#977)
  - Hungarian (PR #937,#955)
  - Italian (PR #911)
  - Japanese
  - Korean (PR #932)
  - Portuguese (PR #956,#964,#976)
  - Russian (PR #901,#927,#963)
  - Slovenian
  - Swedish (PR #974)
  - Turkish (PR #899)

### 内部変更

- README.md が アプリケーションの使用のためではなく、ビルド用の説明であることを
    明確にする。 (PR #942)
- `m_SourceDefs`配列の要素数をコンパイラに計算させる。 (PR #966)

## 既知の問題

 - 巨大ファイルの比較でクラッシュすることがある。(GitHub #325)
 - 大幅に異なるフォルダの比較が非常に時間がかかる。 (GitHub #322)
 - 新規作成で表示範囲を超えるテキストを貼り付けたとき、垂直スクロールバーでスクロールできない。 (GitHub #296)
