#include "pch.h"
#include "crystallineparser.h"

//  HTML keywords
static const tchar_t * s_apszHtmlKeywordList[] =
{
  _T("A"),
  _T("ABBR"),
  _T("ACRONYM"),
  _T("ADDRESS"),
  _T("APPLET"),
  _T("AREA"),
  _T("ARTICLE"),
  _T("ASIDE"),
  _T("AUDIO"),
  _T("B"),
  _T("BASE"),
  _T("BASEFONT"),
  _T("BDI"),
  _T("BDO"),
  _T("BIG"),
  _T("BLOCKQUOTE"),
  _T("BODY"),
  _T("BR"),
  _T("BUTTON"),
  _T("CANVAS"),
  _T("CAPTION"),
  _T("CENTER"),
  _T("CITE"),
  _T("CODE"),
  _T("COL"),
  _T("COLGROUP"),
  _T("DATALIST"),
  _T("DD"),
  _T("DEL"),
  _T("DETAILS"),
  _T("DFN"),
  _T("DIR"),
  _T("DIV"),
  _T("DL"),
  _T("DOCTYPE"),
  _T("DT"),
  _T("EM"),
  _T("EMBED"),
  _T("FIELDSET"),
  _T("FIGCAPTION"),
  _T("FIGURE"),
  _T("FONT"),
  _T("FOOTER"),
  _T("FORM"),
  _T("FRAME"),
  _T("FRAMESET"),
  _T("H1"),
  _T("H2"),
  _T("H3"),
  _T("H4"),
  _T("H5"),
  _T("H6"),
  _T("HEAD"),
  _T("HEADER"),
  _T("HR"),
  _T("HTML"),
  _T("I"),
  _T("IFRAME"),
  _T("IMG"),
  _T("INPUT"),
  _T("INS"),
  _T("ISINDEX"),
  _T("KBD"),
  _T("LABEL"),
  _T("LEGEND"),
  _T("LI"),
  _T("LINK"),
  _T("MAIN"),
  _T("MAP"),
  _T("MARK"),
  _T("MENU"),
  _T("META"),
  _T("METER"),
  _T("NAV"),
  _T("NOFRAMES"),
  _T("NOSCRIPT"),
  _T("OBJECT"),
  _T("OL"),
  _T("OPTGROUP"),
  _T("OPTION"),
  _T("OUTPUT"),
  _T("P"),
  _T("PARAM"),
  _T("PICTURE"),
  _T("PRE"),
  _T("PROGRESS"),
  _T("PUBLIC"),
  _T("Q"),
  _T("RP"),
  _T("RT"),
  _T("RUBY"),
  _T("S"),
  _T("SAMP"),
  _T("SCRIPT"),
  _T("SECTION"),
  _T("SELECT"),
  _T("SMALL"),
  _T("SOURCE"),
  _T("SPAN"),
  _T("STRIKE"),
  _T("STRONG"),
  _T("STYLE"),
  _T("SUB"),
  _T("SUMMARY"),
  _T("SUP"),
  _T("TABLE"),
  _T("TBODY"),
  _T("TD"),
  _T("TEXTAREA"),
  _T("TFOOT"),
  _T("TH"),
  _T("THEAD"),
  _T("TIME"),
  _T("TITLE"),
  _T("TR"),
  _T("TRACK"),
  _T("TT"),
  _T("U"),
  _T("UL"),
  _T("VAR"),
  _T("VIDEO"),
  _T("WBR"),
};
static const tchar_t * s_apszUser1KeywordList[] =
{
  _T("ABBR"),
  _T("ACCEPT"),
  _T("ACCEPT-CHARSET"),
  _T("ACCESSKEY"),
  _T("ACTION"),
  _T("ALIGN"),
  _T("ALINK"),
  _T("ALLOW"),
  _T("ALT"),
  _T("ARCHIVE"),
  _T("ASYNC"),
  _T("AUTOCAPITALIZE"),
  _T("AUTOCOMPLETE"),
  _T("AXIS"),
  _T("BACKGROUND"),
  _T("BGCOLOR"),
  _T("BORDER"),
  _T("CAPTURE"),
  _T("CELLPADDING"),
  _T("CELLSPACING"),
  _T("CHALLENGE"),
  _T("CHAR"),
  _T("CHAROFF"),
  _T("CHARSET"),
  _T("CHECKED"),
  _T("CITE"),
  _T("CLASS"),
  _T("CLASSID"),
  _T("CLEAR"),
  _T("CODE"),
  _T("CODEBASE"),
  _T("CODETYPE"),
  _T("COLOR"),
  _T("COLS"),
  _T("COLSPAN"),
  _T("COMPACT"),
  _T("CONTENT"),
  _T("CONTENTEDITABLE"),
  _T("COORDS"),
  _T("CROSSORIGIN"),
  _T("DATA"),
  _T("DATAFLD"),
  _T("DATAFORMATAS"),
  _T("DATASRC"),
  _T("DATETIME"),
  _T("DECLARE"),
  _T("DECODING"),
  _T("DEFAULT"),
  _T("DEFER"),
  _T("DIR"),
  _T("DISABLED"),
  _T("DRAGGABLE"),
  _T("ENCTYPE"),
  _T("EVENT"),
  _T("FACE"),
  _T("FOR"),
  _T("FRAME"),
  _T("FRAMEBORDER"),
  _T("HEADERS"),
  _T("HEIGHT"),
  _T("HIDDEN"),
  _T("HIGH"),
  _T("HREF"),
  _T("HREFLANG"),
  _T("HSPACE"),
  _T("HTTP-EQUIV"),
  _T("ID"),
  _T("INPUTMODE"),
  _T("INTEGRITY"),
  _T("ISMAP"),
  _T("ITEMPROP"),
  _T("KIND"),
  _T("LABEL"),
  _T("LANG"),
  _T("LANGUAGE"),
  _T("LINK"),
  _T("LIST"),
  _T("LONGDESC"),
  _T("LOW"),
  _T("MARGINHEIGHT"),
  _T("MARGINWIDTH"),
  _T("MAX"),
  _T("MAXLENGTH"),
  _T("MEDIA"),
  _T("METHOD"),
  _T("MIN"),
  _T("MINLENGTH"),
  _T("MULTIPLE"),
  _T("MUTED"),
  _T("NAME"),
  _T("NOHREF"),
  _T("NORESIZE"),
  _T("NOSHADE"),
  _T("NOVALIDATE"),
  _T("NOWRAP"),
  _T("ONABORT"),
  _T("ONAFTERPRINT"),
  _T("ONAUTOCOMPLETE"),
  _T("ONAUTOCOMPLETEERROR"),
  _T("ONBEFOREPRINT"),
  _T("ONBEFOREUNLOAD"),
  _T("ONBLUR"),
  _T("ONCANCEL"),
  _T("ONCANPLAY"),
  _T("ONCANPLAYTHROUGH"),
  _T("ONCHANGE"),
  _T("ONCLICK"),
  _T("ONCLOSE"),
  _T("ONCONTEXTMENU"),
  _T("ONCUECHANGE"),
  _T("ONDBLCLICK"),
  _T("ONDRAG"),
  _T("ONDRAGEND"),
  _T("ONDRAGENTER"),
  _T("ONDRAGLEAVE"),
  _T("ONDRAGOVER"),
  _T("ONDRAGSTART"),
  _T("ONDROP"),
  _T("ONDURATIONCHANGE"),
  _T("ONEMPTIED"),
  _T("ONENDED"),
  _T("ONERROR"),
  _T("ONFOCUS"),
  _T("ONHASHCHANGE"),
  _T("ONINPUT"),
  _T("ONINVALID"),
  _T("ONKEYDOWN"),
  _T("ONKEYPRESS"),
  _T("ONKEYUP"),
  _T("ONLOAD"),
  _T("ONLOADEDDATA"),
  _T("ONLOADEDMETADATA"),
  _T("ONLOADSTART"),
  _T("ONMESSAGE"),
  _T("ONMOUSEDOWN"),
  _T("ONMOUSEENTER"),
  _T("ONMOUSELEAVE"),
  _T("ONMOUSEMOVE"),
  _T("ONMOUSEOUT"),
  _T("ONMOUSEOVER"),
  _T("ONMOUSEUP"),
  _T("ONMOUSEWHEEL"),
  _T("ONOFFLINE"),
  _T("ONONLINE"),
  _T("ONPAGEHIDE"),
  _T("ONPAGESHOW"),
  _T("ONPAUSE"),
  _T("ONPLAY"),
  _T("ONPLAYING"),
  _T("ONPOPSTATE"),
  _T("ONPROGRESS"),
  _T("ONRATECHANGE"),
  _T("ONRESET"),
  _T("ONRESIZE"),
  _T("ONSCROLL"),
  _T("ONSEEKED"),
  _T("ONSEEKING"),
  _T("ONSELECT"),
  _T("ONSHOW"),
  _T("ONSORT"),
  _T("ONSTALLED"),
  _T("ONSTORAGE"),
  _T("ONSUBMIT"),
  _T("ONSUSPEND"),
  _T("ONTIMEUPDATE"),
  _T("ONTOGGLE"),
  _T("ONUNLOAD"),
  _T("ONVOLUMECHANGE"),
  _T("ONWAITING"),
  _T("OPTIMUM"),
  _T("PATTERN"),
  _T("PING"),
  _T("PLACEHOLDER"),
  _T("POSTER"),
  _T("PRELOAD"),
  _T("PROFILE"),
  _T("PROMPT"),
  _T("READONLY"),
  _T("REL"),
  _T("REQUIRED"),
  _T("REV"),
  _T("REVERSED"),
  _T("ROWS"),
  _T("ROWSPAN"),
  _T("RULES"),
  _T("SANDBOX"),
  _T("SCHEME"),
  _T("SCOPE"),
  _T("SCROLLING"),
  _T("SELECTED"),
  _T("SHAPE"),
  _T("SIZE"),
  _T("SLOT"),
  _T("SPAN"),
  _T("SPELLCHECK"),
  _T("SRC"),
  _T("SRCDOC"),
  _T("SRCLANG"),
  _T("SRCSET"),
  _T("STANDBY"),
  _T("START"),
  _T("STEP"),
  _T("STYLE"),
  _T("SUMMARY"),
  _T("TABINDEX"),
  _T("TARGET"),
  _T("TEXT"),
  _T("TITLE"),
  _T("TRANSLATE"),
  _T("TYPE"),
  _T("USEMAP"),
  _T("VALIGN"),
  _T("VALUE"),
  _T("VALUETYPE"),
  _T("VERSION"),
  _T("VLINK"),
  _T("VSPACE"),
  _T("WIDTH"),
  _T("WRAP"),
};

static const tchar_t * s_apszUser2KeywordList[] =
{
  _T("aacute"),
  _T("Aacute"),
  _T("Acirc"),
  _T("acirc"),
  _T("acute"),
  _T("aelig"),
  _T("AElig"),
  _T("Agrave"),
  _T("agrave"),
  _T("amp"),
  _T("aring"),
  _T("Aring"),
  _T("Atilde"),
  _T("atilde"),
  _T("auml"),
  _T("Auml"),
  _T("brvbar"),
  _T("Ccedil"),
  _T("ccedil"),
  _T("cedil"),
  _T("cent"),
  _T("copy"),
  _T("curren"),
  _T("deg"),
  _T("divide"),
  _T("Eacute"),
  _T("eacute"),
  _T("ecirc"),
  _T("Ecirc"),
  _T("egrave"),
  _T("Egrave"),
  _T("eth"),
  _T("ETH"),
  _T("euml"),
  _T("Euml"),
  _T("frac12"),
  _T("frac14"),
  _T("frac34"),
  _T("gt"),
  _T("Iacute"),
  _T("iacute"),
  _T("Icirc"),
  _T("icirc"),
  _T("iexcl"),
  _T("igrave"),
  _T("Igrave"),
  _T("iquest"),
  _T("Iuml"),
  _T("iuml"),
  _T("laquo"),
  _T("lt"),
  _T("macr"),
  _T("micro"),
  _T("middot"),
  _T("nbsp"),
  _T("not"),
  _T("ntilde"),
  _T("Ntilde"),
  _T("Oacute"),
  _T("oacute"),
  _T("Ocirc"),
  _T("ocirc"),
  _T("ograve"),
  _T("Ograve"),
  _T("ordf"),
  _T("ordm"),
  _T("Oslash"),
  _T("oslash"),
  _T("otilde"),
  _T("Otilde"),
  _T("ouml"),
  _T("Ouml"),
  _T("para"),
  _T("plusmn"),
  _T("pound"),
  _T("quot"),
  _T("raquo"),
  _T("reg"),
  _T("sect"),
  _T("shy"),
  _T("sup1"),
  _T("sup2"),
  _T("sup3"),
  _T("szlig"),
  _T("thorn"),
  _T("THORN"),
  _T("times"),
  _T("Uacute"),
  _T("uacute"),
  _T("ucirc"),
  _T("Ucirc"),
  _T("Ugrave"),
  _T("ugrave"),
  _T("uml"),
  _T("uuml"),
  _T("Uuml"),
  _T("yacute"),
  _T("Yacute"),
  _T("yen"),
  _T("yuml"),
};

bool
CrystalLineParser::IsHtmlKeyword(const tchar_t *pszChars, int nLength)
{
  return ISXKEYWORDI(s_apszHtmlKeywordList, pszChars, nLength);
}

bool
CrystalLineParser::IsHtmlUser1Keyword (const tchar_t *pszChars, int nLength)
{
  return ISXKEYWORDI (s_apszUser1KeywordList, pszChars, nLength);
}

bool
CrystalLineParser::IsHtmlUser2Keyword (const tchar_t *pszChars, int nLength)
{
  return ISXKEYWORDI (s_apszUser2KeywordList, pszChars, nLength);
}

bool
CrystalLineParser::IsXKeyword(const tchar_t *pszKey, size_t nKeyLen, const tchar_t *pszKeywordList[], size_t nKeywordListCount, int(*compare)(const tchar_t *, const tchar_t *, size_t))
{
  tchar_t **base = (tchar_t **)pszKeywordList;
  size_t lim;

  for (lim = nKeywordListCount; lim != 0; lim >>= 1)
    {
      tchar_t **p = base + (lim >> 1);
      int cmp = (*compare)(pszKey, *p, nKeyLen);
      if (cmp == 0 && (*p)[nKeyLen] == 0)
        return true;
      if (cmp > 0)
        { /* key > p: move right */
          base = (tchar_t **)p + 1;
          lim--;
        } /* else move left */
    }
  return false;
}

bool
CrystalLineParser::IsXNumber(const tchar_t *pszChars, int nLength)
{
  if ((nLength > 0 && tc::istdigit(pszChars[0])) ||
      (nLength > 1 && pszChars[0] == '.' && tc::istdigit(pszChars[1])))
    return true;
  return false;
}

