// WinTabInvoker.h

#pragma once
using namespace System;

typedef unsigned int HCTX;

namespace WinTabDotnet {
	typedef	unsigned int (__stdcall *FnWTOpen)(IntPtr hWnd,/*LOGCONTEXT*/void* lpLogCtx,BOOL fEnable);
    typedef int (__stdcall *FnWTClose)(HCTX hCTX);
    typedef unsigned int (__stdcall *FnWTInfo)(unsigned int nCategory,unsigned int nIndex,void* pBuf);
    typedef int (__stdcall *FnWTPacket)(HCTX hCTX,unsigned int wSerial,void* pBuf);
    typedef int (__stdcall *FnWTEnable)(HCTX hCTX,BOOL fEnable);
    typedef int (__stdcall *FnWTOverlap)(HCTX hCTX,BOOL fEnable);
    typedef int (__stdcall *FnWTConfig)(HCTX hCTX,IntPtr hWnd);

	public ref class WinTabInvoker {
	private:
		static HMODULE		m_hWinTabLib	= NULL;

	public:
		static FnWTOpen		m_fpWTOpen		= NULL;
		static FnWTClose	m_fpWTClose		= NULL;
		static FnWTInfo		m_fpWTInfo		= NULL;
		static FnWTPacket	m_fpWTPacket	= NULL;
		static FnWTEnable	m_fpWTEnable	= NULL;
		static FnWTOverlap	m_fpWTOverlap	= NULL;
		static FnWTConfig	m_fpWTConfig	= NULL;

	public:
		~WinTabInvoker() {
			FreeWinTabLib();
		}

		static bool IsValid() {
			return m_hWinTabLib!=NULL;
		}

		static bool LoadWinTabLib() {
			m_hWinTabLib = LoadLibrary(L"WinTab32.dll");
			if (!m_hWinTabLib) { return false; }
			
			m_fpWTOpen		= (FnWTOpen)GetProcAddress(m_hWinTabLib,"WTOpenW");
			m_fpWTClose		= (FnWTClose)GetProcAddress(m_hWinTabLib,"WTClose");
			m_fpWTInfo		= (FnWTInfo)GetProcAddress(m_hWinTabLib,"WTInfoW");
			m_fpWTPacket	= (FnWTPacket)GetProcAddress(m_hWinTabLib,"WTPacket");
			m_fpWTEnable	= (FnWTEnable)GetProcAddress(m_hWinTabLib,"WTEnable");
			m_fpWTOverlap	= (FnWTOverlap)GetProcAddress(m_hWinTabLib,"WTOverlap");
			m_fpWTConfig	= (FnWTConfig)GetProcAddress(m_hWinTabLib,"WTConfig");

			return true;
		}

		static void FreeWinTabLib() {
			if (m_hWinTabLib) {
				FreeLibrary(m_hWinTabLib);
				m_hWinTabLib=NULL;
			}
		}

		// -------------------------------------------------------------------------
		// C# Ăׂ悤ɂ邽߂ Accesser (Ȃ)

		static public unsigned int WTOpen(IntPtr hWnd,/*LOGCONTEXT*/void* lpLogCtx,BOOL fEnable) {
			return m_fpWTOpen(hWnd,lpLogCtx,fEnable);
        }

        static public int WTClose(HCTX hCTX) {
            return m_fpWTClose(hCTX);
        }

        static public unsigned int WTInfo(unsigned int nCategory,unsigned int nIndex,void* pBuf) {
            return m_fpWTInfo(nCategory,nIndex,pBuf);
        }

        static public int WTPacket(HCTX hCTX,unsigned int wSerial,void* pBuf) {
            return m_fpWTPacket(hCTX,wSerial,pBuf);
        }

        static public int WTEnable(HCTX hCTX,BOOL fEnable) {
            return m_fpWTEnable(hCTX,fEnable);
        }

        static public int WTOverlap(HCTX hCTX,BOOL fEnable) {
            return m_fpWTOverlap(hCTX,fEnable);
        }

        static public int WTConfig(HCTX hCTX,IntPtr hWnd) {
            return m_fpWTConfig(hCTX,hWnd);
        }
	};
}
