#include "BThread.h"

#if defined (USE_WIN32THREADS)
#include <process.h>
#endif //USE_WIN32THREADS

BThread::BThread()
{
#if defined (USE_PTHREADS)
	mPThread = 0;
#endif //USE_PTHREADS
}

BThread::~BThread()
{
#if defined (USE_PTHREADS)
	mPThread = 0;
#endif //USE_PTHREADS
}

void BThread::Create()
{
#if defined (USE_PTHREADS)
	int err = pthread_create(&mPThread, NULL, BThread::_Proc, this);
	if (err != 0)
	{
		DEBUG_CALL(printf("error creating pthread: %d\n", err));
	}
#endif //USE_PTHREADS

#if defined (USE_WIN32THREADS)
	mThreadId = ::_beginthread( BThread::_Proc, 0, this );
#endif //USE_WIN32THREADS
}

#if defined (USE_PTHREADS)
void* BThread::_Proc(void* inThis)
{
	try
	{
		((BThread *)inThis)->Run();
	}
	catch (...)
	{
	}

	int err = pthread_detach(pthread_self());
	if (err != 0)
	{
		DEBUG_CALL(printf("error detaching pthread: %d\n", err));
	}

	return NULL;
}
#endif //USE_PTHREADS

#if defined (USE_WIN32THREADS)
void BThread::_Proc(void* inThis)
{
	try
	{
		((BThread *)inThis)->Run();
	}
	catch (...)
	{
	}
}
#endif //USE_WIN32THREADS
