// HLDataBase holds information about users, transfers, banlists and news
// It was originally intended only as a class for accessing MySQL, but
// I changed it to be backwards compatible with flat files. The MySQL
// version of the code is now in MySQLDataBase.cpp and the flat file code
// is in HLDataBase.cpp

#ifndef HL_DATABASE_H
#define HL_DATABASE_H

#include <string>
#include "HLUser.h"
#include "HLTransfer.h"
#include <list>

#if defined(_MYSQL_)
#include <mysql/mysql.h>
#else

typedef struct
{
    string host;
    string reason;
    time_t expire;
} HostBan;

typedef list<HostBan> HostBanList;
#endif // _MYSQL_

typedef list<HLAccount> AccountList;

class HLDataBase
{
	public:
		HLDataBase();
		~HLDataBase();

		void Connect(const string &inHost, const string &inUser,
			const string &inPassword, const string &inDataBase);
		
		void Init();

		void AddUser(HLUser &inUser, const string &inAddress);
		void UpdateUser(HLUser &inUser);
		void RemoveUser(HLUser &inUser);
		
		void AddHostBan(const string &inHost, const HLUser &inUser,
            const string &inReason, const u_int32_t inTimeout);
		void AddNewsPost(HLUser &inUser, const string &inPost);
		
		void GetNewsFile(string &outNews);
    void GetAgreement(string &outAgreement);

		//2003/07/30 added by ortana.
#ifdef WIN32
		void SetNewsFile( string inNews );
#endif//WIN32
		
		void AddTransfer(HLTransfer &inTransfer);
		void EndTransfer(HLTransfer &inTransfer);
		
        void CreateAccount(HLAccount &inAccount);
		bool FetchAccount(HLAccount &ioAccount, bool inVerifyPassword = true);
        void DeleteAccount(const string &inLogin);
        void ModifyAccount(HLAccount &inAccount, bool inChangePassword);
		void ListAccounts(AccountList &outAccountList);
		
		bool IsHostBanned(const string &inHost);
		bool IsNameBanned(const string &inName);
		
	protected:
#if defined(_MYSQL_)
		MYSQL *mDB;
		
		bool Query(const char *inFormat, ...);
#else
        string mNews;
        HostBanList mHostBanList;
#endif // _MYSQL_
};

#endif // HL_DATABASE_H


