/*
*  NewsFile.cpp
*  terra
*
*  Created by John Butera on Sun Mar 30 2003.
*  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
*
*/

#include "HLNewsFile.h"
#include "HLProtocol.h"

namespace NewsFile
{
//------------------------RXgN^-------------------------------------//
	HLNewsFile::HLNewsFile()
	{
		mMainMap = NULL;
		mPostHeaders = NULL;
		Clear();
	}

	HLNewsFile::HLNewsFile(const string &inPath)
	{
		mMainMap = NULL;
		mPostHeaders = NULL;
		Clear();
		Open(inPath);
	}


//-------------------------fXgN^--------------------------------------//
	HLNewsFile::~HLNewsFile()
	{
		Clear();
	}

	// Clear
	// Frees any allocated buffers

	void HLNewsFile::Clear()
	{
		if (mMainMap != NULL)
		{
			free(mMainMap);
			mMainMap = NULL;
		}
		if (mPostHeaders != NULL)
		{
			free(mPostHeaders);
			mPostHeaders = NULL;
		}

		memset(&mHdr, 0, sizeof(mHdr));
		mValid = false;
	}

	// Close
	// Closes the file and frees any allocated buffers

	void HLNewsFile::Close()
	{
		mFile.close();
		Clear();
	}

	// Open
	// Prepares the news file specified by inPath to be written or read
	// Returns true if successful, false otherwise

	bool HLNewsFile::Open(const string &inPath)
	{
		mFile.open(inPath.c_str(), ios::in | ios::out | ios::binary);
		mFile.exceptions(0);
		mFile.seekg(0);
		mFile.read((char*)&mHdr, sizeof(mHdr));

		if (memcmp(&mHdr.magic, HLNZ_MAGIC, HLNZ_MAGIC_LEN) == 0)
		{
			mValid = true;

			if (mMainMap != NULL)
				free(mMainMap);
			mMainMap = (map_t*)malloc(BlockSize());

			if (ReadBlocks(2, mMainMap, BlockSize()))
			{
				return true;
			}
		}

		Close();
		return false;
	}

	// ReadPostHeaders
	// Reads the post headers from the file
	// Returns true if successful, false otherwise

	bool HLNewsFile::ReadPostHeaders()
	{
		DEBUG_CALL(printf("HLNewsFile::ReadPostHeaders()\n"));

		//	if (mHdr.postheader_block == 0)
		//		return false;

		if (mPostHeaders != NULL)
			free(mPostHeaders);

		mPostHeaders = (post_hdr_t*)malloc(mHdr.postheader_size + sizeof(post_hdr_t) + sizeof(post_hdr_entry_t) + 768);
		if (mHdr.postheader_block == 0)
		{
			mPostHeaders->__x0 = 0;
			mPostHeaders->count = 0;
			mPostHeaders->__x1 = 0;
			return true;
		}

		return ReadBlocks(mHdr.postheader_block, (char*)mPostHeaders, mHdr.postheader_size);
	}

	// FileValid
	// Getter function for mValid
	// Returns true if the file is valid, false otherwise

	bool HLNewsFile::FileValid()
	{
		return mValid;
	}

	// UpdateHeader
	// Writes the header to the file
	// Returns true if successful, false otherwise

	bool HLNewsFile::UpdateHeader()
	{
		return WriteBlocks((u_int32_t)-1, GetHdr(), BlockSize()) ? true : false;
	}

	// UpdateMainMap
	// Writes the main map to the file
	// Returns true if successful, false otherwise

	bool HLNewsFile::UpdateMainMap()
	{
		return WriteBlocks(2, mMainMap, BlockSize()) ? true : false;
	}

	// UpdateUnknownBlocks
	// Zeros out the 2 unknown blocks
	// Returns true if successful, false otherwise

	bool HLNewsFile::UpdateUnknownBlocks()
	{
		char* buffer = (char*)memset(malloc(BlockSize()), 0, BlockSize());

		if (WriteBlocks(0, buffer, BlockSize()) && WriteBlocks(1, buffer, BlockSize()))
		{
			free(buffer);
			return true;
		}
		else
		{
			free(buffer);
			return false;
		}
	}

	// WriteBlocks
	// Writes inDataSize bytes from inData to block inBlockNum in the file
	// Returns the number of bytes written

	u_int32_t HLNewsFile::WriteBlocks(u_int32_t inBlockNum, const void* inData, u_int32_t inDataSize)
	{
		streampos pos;

		if (inDataSize > 0)
		{
			try
			{
				if (inBlockNum == (u_int32_t)-1) // file header block designation
				{
					mFile.seekp(0);
				}
				else
				{
					mFile.seekp((inBlockNum - 1) * BlockSize() + 0x200);
				}
			}
			catch (ios::failure)
			{
				Close();
				return 0;
			}
			try
			{
				pos = mFile.tellp();

				mFile.write((char*)inData, inDataSize);
				for (int n = inDataSize; n % BlockSize() != 0; n++)
					mFile.put(0);

				return mFile.tellp() - pos;
			}
			catch (ios::failure)
			{
				Close();
				return mFile.tellp() - pos;
			}
		}

		return 0; // return false if data size was 0
	}

#if 0
	// WriteBlocks
	// Writes inDataSize bytes from inData to block inBlockNum in the file
	// Returns true if successful, false otherwise

	bool HLNewsFile::WriteBlocks(u_int32_t inBlockNum, const void* inData, u_int32_t inDataSize)
	{
		ios_base::iostate savedState;

		printf("WriteBlocks...\n");
		if (inDataSize > 0)
		{
			printf("inDataSize > 0\n");
			savedState = mFile.exceptions();
			mFile.exceptions(0);

			mFile.seekp((1 + inBlockNum) * BlockSize());
			if (!mFile.fail())
			{
				printf("seek succeeded\n");
				mFile.write((char*)inData, inDataSize);
				for (int n = inDataSize; n % BlockSize() != 0; n++) // fill the remainder of the block with nulls
					mFile.put(0);

				if (!mFile.fail())
				{
					printf("finished write\n");
					mFile.exceptions(savedState);
					return true;
				}
			}
		}

		printf("WriteBlocks reached the end.. state: %x\n", mFile.rdstate());
		return false; // return false if data size was 0
	}
#endif

	// ReadBlocks
	// Reads inDataSize bytes from block inBlockNum to outData
	// Returns true if successful, false otherwise

#if 0
	bool HLNewsFile::ReadBlocks(u_int32_t inBlockNum, void* outData, u_int32_t inDataSize)
	{

		u_int32_t gott;

		try
		{
			printf("exceptions %x\n", mFile.exceptions());
			printf("file state: %x\n", mFile.rdstate());
			mFile.seekg((1 + inBlockNum) * BlockSize());
			printf("file state: %x\n", mFile.rdstate());
			printf("tellg: %u\n", mFile.tellg());
			printf("inDataSize: %u\n", inDataSize);
			gott = mFile.readsome((char*)outData, inDataSize - 1);
			printf("file state: %x\n", mFile.rdstate());
			printf("data[40]: %u\n", ((char*)outData)[40]);
			printf("got %u wanted %u\n", gott, inDataSize);

			if (gott == inDataSize)
				return true;
			else
				return false;
		}
		catch (ios::failure &error)
		{
			printf("ios::failure caught.. %x, b (%x) e(%x) f(%x) g(%x)\n", mFile.rdstate(), ios::badbit, ios::eofbit, ios::failbit, ios::goodbit);
			Close();
			return false;
		}
	}

#endif

	bool HLNewsFile::ReadBlocks(u_int32_t inBlockNum, void* outData, u_int32_t inDataSize)
	{
		if (mFile.fail())
		{
			printf("file failed before entering function\n");
			return false;
		}

		ios_base::iostate savedExceptions = mFile.exceptions();
		mFile.exceptions(0);

		printf("exceptions %x\n", mFile.exceptions());
		printf("file state: %x\n", mFile.rdstate());
		mFile.seekg((inBlockNum - 1) * BlockSize() + 0x200);
		printf("file state: %x\n", mFile.rdstate());
		printf("tellg: %u\n", (unsigned int)mFile.tellg());
		printf("inDataSize: %u\n", inDataSize);
		mFile.read((char*)outData, inDataSize - 0);
		printf("file state: %x\n", mFile.rdstate());
		printf("got: %u\n", mFile.gcount());
		printf("data[inDataSize-1]: %c\n", ((char*)outData)[inDataSize-1]);
		printf("data[inDataSize-2]: %c\n", ((char*)outData)[inDataSize-2]);
		printf("data[inDataSize-3]: %c\n", ((char*)outData)[inDataSize-3]);
		printf("failbit: %x, eofbit: %x, badbit: %x\n", ios::failbit, ios::eofbit, ios::badbit);

		if (mFile.gcount() == inDataSize)
		{
			mFile.clear(); // clear state.. make it all good
			printf("cleared state, state: %x\n", mFile.rdstate());
		}

		mFile.exceptions(savedExceptions);
		if (!mFile.fail())
		{
			printf("exited ReadBlocks.. everything went smoothly d:D\n");
			return true;
		}
		else
		{
			return false;
		}
	}


	// BlockSize
	// Gets the file's block size in bytes
	// Returns the block size if the file is valid, 0 otherwise

	u_int32_t HLNewsFile::BlockSize()
	{
		if (mValid)
			return ntohl(mHdr.block_size);
		else
			return 0;
	}

	// GetHdr
	// Getter function for mHdr
	// Returns mHdr

	file_hdr_t* HLNewsFile::GetHdr()
	{
		return &mHdr;
	}

	// WritePostInfo
	// write a post_info_t structure to the news file
	// returns the number of bytes written

	u_int32_t HLNewsFile::WritePostInfo(u_int32_t block, post_info_t info)
	{
		// change byte ordering to network order
		info.postdata_block = htonl(info.postdata_block);
		info.__x0 = htonl(info.__x0);
		info.id = htonl(info.id);
		info.previous_id = htonl(info.previous_id);
		info.next_id = htonl(info.next_id);
		info.parent_id = htonl(info.parent_id);
		info.reply_id = htonl(info.reply_id);
		info.date_base = htonl(info.date_base);
		info.date_sec = htonl(info.date_sec);
		info.__x1 = htonl(info.__x1);

		return WriteBlocks(block, &info, sizeof(post_info_t));
	}

	// WritePostData
	// write a post_data_t structure to the news file
	//   note that this function uses post_data_t.data_len to determine
	//   the size of the entire structure (including post_data_t.data)
	// returns the number of blocks written

	u_int32_t HLNewsFile::WritePostData(u_int32_t block, post_data_t &data)
	{
		u_int32_t bytes_out;

		// change byte ordering to network order
		data.__x0 = htonl(data.__x0);
		data.data_len = htonl(data.data_len);

		bytes_out = WriteBlocks(block, &data, sizeof(post_data_t) + ntohl(data.data_len));

		// change byte ordering back to host order
		data.__x0 = ntohl(data.__x0);
		data.data_len = ntohl(data.data_len);

		return bytes_out;
	}

}