#ifndef HL_TRANSFER_MANAGER
#define HL_TRANSFER_MANAGER


class HLTransferInfo;
class HLTransfer;
class HLServer;
class HLClient;
class WebServer;

class HLTransferManager
{
public:
	HLTransferManager();
	~HLTransferManager();

	bool QueueTransferInfo(HLTransferInfo &inTransferInfo, bool &isLeech);
	bool GetTransferInfo(u_int32_t inRef, HLTransferInfo &outInfo);
	unsigned int SecondsUntilDownloadSpotOpens();
	void CancelStalledTransfers();
	void KeepAliveQueuedTransfers();
	void CancelTransfersForUser(HLUser &inUser);
	inline const unsigned int QueueSize() const
	{ return (unsigned int)mDownloadQueue.size(); }

	void BeginDownload(HLTransfer *inTransfer, bool &outQueued);
	void BeginUpload(HLTransfer *inTransfer);
	void EndDownload(HLTransfer *inTransfer);
	void EndUpload(HLTransfer *inTransfer);

	void GetNetStat(char * outBuff);

	static u_int32_t MakeRef(const HLTransferInfo &inInfo);

protected:
	TransferInfoList mTransferInfoList;
	TransferList mDownloadList;
	TransferList mDownloadQueue;
	TransferList mUploadList;

	u_int32_t mTotalUploads;
	u_int32_t mTotalDownloads;
	u_int64_t mTotalUploadBytes;
	u_int64_t mTotalDownloadBytes;

	friend class HLServer;
	friend class HLClient;
	friend class WebServer;
};

#endif//HL_TRANSFER_MANAGER