#if !defined(_MYSQL_)

#include "HLUserData.h"
#include "FileUtils.h"
#include "HLEncrypt.h"

#include <fcntl.h>
#include <fstream>

#if !defined(WIN32)
#include <sys/stat.h>
#include <sys/param.h>
#include <unistd.h>
#endif // !WIN32

// need to remove these dependancies
#if defined(_PREFPANE_)
    // these shouldn't be set higher than 31
    #define USERNAME_MAXLEN 31
    #define PASSWORD_MAXLEN 31

    #include "ServerConf.h"
    extern ServerConf gServerConf;
#else
    #include "HLServer.h"
#endif

HLUserData::HLUserData(const string &inLogin)
    : mMaxBps(0)
{
    mLogin = inLogin;
    memset(&mAccessBits, 0, sizeof(mAccessBits));
}

HLUserData::~HLUserData()
{
}

bool HLUserData::ReadFrom(const string &inAccountsDir)
{
    struct hl_user_data userData;
    //int fd;
    //int err;
    u_int32_t len;
    char userDataPath[MAXPATHLEN];

    if (!strchr(mLogin.c_str(), '/'))
    {
        // this is a possible security hole, i need to filter login and do better
        // checking of the data inside a UserData file
        snprintf(userDataPath, sizeof(userDataPath), "%s%s/UserData", 
            inAccountsDir.c_str(), mLogin.c_str());
        
        ifstream file(userDataPath, ios::in | ios::binary);
		// throw exceptions for all errors
		file.exceptions(/*ios::eofbit | ios::failbit |*/ ios::badbit);
		
        if (file)
        {
			memset(&userData, 0 , sizeof(userData));
			file.read((char *)&userData, 734);
			// decrypt password
			len = ntohs(userData.plen) > PASSWORD_MAXLEN ? PASSWORD_MAXLEN : ntohs(userData.plen);
			HLEncrypt(userData.password, len);
			mPassword.assign((char *)userData.password, len);
			
			len = ntohs(userData.nlen) > USERNAME_MAXLEN ? USERNAME_MAXLEN : ntohs(userData.nlen);
			mName.assign((char *)userData.name, len);
			
			mAccessBits = userData.access;
			mMaxBps = userData.maxbps;
			
			snprintf(userDataPath, sizeof(userDataPath), "%s%s/files", 
				inAccountsDir.c_str(), mLogin.c_str());
#ifndef WIN32
			struct stat sb;
			if (lstat(userDataPath, &sb) == 0)
			{
				mRootPath = realpath(userDataPath, userDataPath);
#if _CARBON_
				FileUtils::resolveAlias(mRootPath);
#endif // _CARBON_
			}
			else
#endif // WIN32
			{
				//2003/11/27 modified by ortana.
				//mRootPath = gServer->Config().rootPath;
				if ( FileUtils::IsExistObject( userDataPath , TRUE ) )
				{
					mRootPath = userDataPath;
				}
				else
				{
					mRootPath = gServer->Config().rootPath;
				}

			}
			return true;
        }
    }
    return false;
}

void HLUserData::WriteTo(const string &inAccountsDir, bool inCreate)
{
    struct hl_user_data userData;
    int fd;
    char userDataPath[MAXPATHLEN];
    
    if (strchr(mLogin.c_str(), '/'))
    {
        return;
    }

    if (inCreate)
    {
        snprintf(userDataPath, sizeof(userDataPath), "%s%s/", 
            inAccountsDir.c_str(), mLogin.c_str());
#if defined(_PREFPANE_)
        if (mkdir(userDataPath, gServerConf.dirPermissions) != 0)
            return;
#else
        if (mkdir(userDataPath, gServer->Config().dirPermissions) != 0)
            return;
#endif
    }
    
    snprintf(userDataPath, sizeof(userDataPath), "%s%s/UserData", 
        inAccountsDir.c_str(), mLogin.c_str());

	if (inCreate)
	{
#if defined(_PREFPANE_)
		fd = open(userDataPath, O_RDWR | O_CREAT | O_EXCL,
			gServerConf.filePermissions);
#else
		fd = open(userDataPath, O_RDWR | O_CREAT | O_EXCL | O_BINARY,
			gServer->Config().filePermissions);
#endif
		close(fd);
	}
	
	ofstream file(userDataPath, ios::out | ios::binary);
	// throw exceptions for all errors
	file.exceptions(ios::eofbit | ios::failbit | ios::badbit);
    if (file)
    {
        memset(&userData, 0, sizeof(userData));
        
        //userData.magic = 
        userData.access = mAccessBits;
        userData.maxbps = mMaxBps;
        
        userData.nlen = mName.length() > USERNAME_MAXLEN ? USERNAME_MAXLEN : mName.length();
        memcpy(userData.name, mName.c_str(), userData.nlen);
        userData.nlen = htons(userData.nlen);
        
        userData.llen = mLogin.length() > USERNAME_MAXLEN ? USERNAME_MAXLEN : mLogin.length();
        memcpy(userData.login, mLogin.c_str(), userData.llen);
        userData.llen = htons(userData.llen);
        
        userData.plen = mPassword.length() > PASSWORD_MAXLEN ? PASSWORD_MAXLEN : mPassword.length();
        memcpy(userData.password, mPassword.c_str(), userData.plen);
        HLEncrypt(userData.password, userData.plen);
        userData.plen = htons(userData.plen);
		
		file.write((char *)&userData, 734);
    }
}

void HLUserData::DeleteFrom(const string &inAccountsDir)
{
    string deletePath = inAccountsDir;
    if (strchr(mLogin.c_str(), '/'))
    {
        return;
    }
    
    deletePath.append(mLogin);
    FileUtils::deletePath(deletePath);
}

#endif // !defined(_MYSQL_) 

