// A wrapper around select that works with AsyncTCPSocket

#ifndef SOCKET_SELECTOR_H
#define SOCKET_SELECTOR_H

#include <list>

using namespace std;

class AsyncTCPSocket;
typedef list<AsyncTCPSocket *> SocketList;

class SocketSelector
{
    public:
        SocketSelector();
        ~SocketSelector();
        
        void WaitEvent(time_t inSeconds = 0);
    
    protected:
        void AddSocket(AsyncTCPSocket &inSocket);
        void RemoveSocket(AsyncTCPSocket &inSocket);
        
        SocketList mSocketList;
        bool mListModified;

friend class AsyncTCPSocket;
};

#endif // SOCKET_SELECTOR_H

