#ifdef WIN32

#include "prefix.h"
#include "AbstractCommand.h"
#include "HLPacket.h"
#include "HLServer.h"
#include "HLClient.h"
#include "CommandParam.h"
#include "Support.h"

bool AbstractCommand::isUsingCommand;
bool AbstractCommand::isCommand;

AbstractCommand::AbstractCommand()
{
}

AbstractCommand::AbstractCommand(HLClient* _client)
: client( _client )
{
	isCommand = false;
	isUsingCommand = false;
}

AbstractCommand::~AbstractCommand(void)
{
}

void AbstractCommand::Next( CommandParam& param )
{
	if( this->successor != 0 )
	{
		this->successor->Process( param );
	}
}

const bool AbstractCommand::PreProcess(const std::string &command,CommandParam& param)
{
	const string& chatString = param.GetChatString();
	if( !IsCommand( chatString , command ) )
	{
		Next( param );
		return false;
	}

	if( !CheckEnableUse() )
	{
		return false;
	}

	return true;
}



const bool  AbstractCommand::IsCommand(const std::string &chatString ,const std::string &command)
{
	int pos;
	if( (pos = chatString.find( command ) ) != std::string.npos )
	{
		if( 0 == pos  )
		{
			if( chatString.length() == command.length())//ex /rate
			{
				return isCommand = true;
			}
			else if( chatString.length() > command.length() )//ex /netstat[sp]
			{
				if( chatString[ command.length()] == ' ' )//ex /find test.txt
				{
					return isCommand= true;
				}
			}
		}
	}
	isCommand = false;
	return false;
}

const bool  AbstractCommand::CheckEnableUse()
{
	bool ret = true;
	if( !gServer->Config().command_check )
	{
		ret  =  false;
	}
	else
	{
		if( this->client->User().IsGuest() )
		{
			if( !gServer->Config().guest_command_check )
			{
				ret  = false;
			}
		}
	}

	if( !ret )
	{
		string s( NTF::loadResourceText( IDS_CHAT_CMD_DISABLE ) );
		NTF::ToChatStyleString( s );
		SendChat( s );
		isUsingCommand = false;
		return ret;//return
	}

	if( isUsingCommand )
	{
		ret = false;
		string usingString(  NTF::loadResourceText( IDS_CHAT_CMD_USING_COMMAND ) );
		NTF::ToChatStyleString( usingString );
		SendChat( usingString );
	}
	else
	{
		isUsingCommand = true;
		ret	 = true;
	}

	return ret;
}
   
const bool  AbstractCommand::ExtractParameter(const std::string& chatString ,
		 const unsigned int& command_len,std::string& outParam) const
{
	if( chatString.length() < (command_len + 2) )
	{
		this->isUsingCommand = false;
		return false;
	}

	outParam = chatString.substr( command_len + 1 , (chatString.length() - (command_len + 1)) );

	return true;
}


///////////
//public
   
void AbstractCommand::SendChat(const std::string& message) const
{
	HLPacket chatPacket(HTLS_HDR_CHAT, 0, 0);
	chatPacket.AddStringObject(HTLS_DATA_CHAT, message);

	if( this->client != 0 )
	{
		client->SendPacket( chatPacket );
	}
}

AbstractCommand* AbstractCommand::SetSuccessor(AbstractCommand* _successor)
{
	return this->successor = _successor;
}

void AbstractCommand::Initialize()
{
	isCommand = false;
}
#endif//WIN32