/*//////////////////////////////////////////////////////////////////////////
 
  AbstractCommand Class
	

		ChainOfResponsibility pattern.
		use for a Abstract class of Command Classes.
  
		//2003/08/29 added by ortana. 

//////////////////////////////////////////////////////////////////////////*/
#ifdef WIN32

#pragma once
#include <string>

using namespace std;
class CommandParam;
class HLClient;


class AbstractCommand
{
public:
	
	AbstractCommand(HLClient* client);
	virtual ~AbstractCommand(void);
	AbstractCommand* SetSuccessor( AbstractCommand* _successor );
	const virtual bool Process ( CommandParam& param ) = 0;
	virtual void SendChat(const std::string& message) const;
	inline const bool& GetIsCommand()const {return isCommand;}
	inline const bool& GetIsUsing()const {return isUsingCommand;}
	void Initialize();

protected :

	AbstractCommand(void);
	void Next( CommandParam& param );
	const bool PreProcess(const std::string &command,CommandParam& param);
	const bool ExtractParameter(const std::string& chatString ,
								const unsigned int& command_len,std::string& outParam) const;
	
private :

	AbstractCommand& operator=(const AbstractCommand& command );
	const bool IsCommand(const std::string &chatString ,const std::string &command);
	const bool CheckEnableUse();

public:
	
protected :

	HLClient* client;
	static bool isUsingCommand;
	static bool isCommand; 

private :

	AbstractCommand *successor;
};
#endif//WIN32