#ifdef WIN32

#include "cban.h"
#include "Support.h"
#include <iostream>
#include <boost/regex.hpp>
#include <fstream>
#include <string>
#include "FileUtils.h"

using namespace NTF;
using namespace std;


const char BAN_LIST_PATH[18] = "data/ban_list.txt";

CBan::CBan(void)
{
}

CBan::~CBan(void)
{
}

std::string CBan::getList()
{

	string list;
	FileUtils::LoadText( BAN_LIST_PATH , list );

	std::string p("(.*)");
	std::string pr("*");
	list = NTF::replace_all_target( list , p , pr );

	return list;
}

void CBan::load()
{
	ban_list.clear();
	ifstream stream( BAN_LIST_PATH );
	if( !stream ){ return; }
	char buff[256];
	while( stream.getline( buff , 256 , '\r' ) )
	{
		std::string s( buff );
		if( s != "")
		{
			ban_list.push_back( s );
		}
	}
	stream.close();
}
void CBan::save(const char *s)
{
	ban_list.clear();
	std::string str( s );
	std::string p("*");
	std::string pr("(.*)");
	str = NTF::replace_all_target( str , p , pr );

	FileUtils::SaveText( BAN_LIST_PATH , str );

	load();
}

bool CBan::isBan(const char *source)
{
	for(unsigned int i = 0 ; i < ban_list.size() ; i++ )
	{
		try
		{

			std::string s = ban_list[i];

			if(s[0] == '|' )//comment out
			{
				continue;
			}
			
			boost::RegEx r( s.c_str() );


			if( r.Match( source ) )
			{
				return true;
			}

		}
		catch( ... )
		{
			continue;
		}
	}
	return false;
}

#endif//WIN32