#ifdef WIN32
#include "Command.h"
#include "DiskFreeSpaceCommand.h"
#include "FindCommand.h"
#include "NetStatCommand.h"
#include "RateCommand.h"
#include "AbstractCommand.h"
#include "CommandParam.h"
#include "HelpCommand.h"

Command::Command(HLClient *_client) : client( _client )
{
	findCommand = new FindCommand( this->client );
	diskFreeSpaceCommand = new DiskFreeSpaceCommand( this->client );
	netStatCommant = new NetStatCommand( this->client );
	rateCommand = new RateCommand( this->client );
	helpCommand = new HelpCommand( this->client );


	findCommand->SetSuccessor( diskFreeSpaceCommand )
		->SetSuccessor( netStatCommant	)
		->SetSuccessor( rateCommand )
		->SetSuccessor( helpCommand )
		->SetSuccessor( 0 );

	this->aCommand = findCommand;
}

Command::~Command(void)
{
		delete diskFreeSpaceCommand;
		delete netStatCommant;
		delete rateCommand;
		delete helpCommand;
		delete findCommand;
}

const bool Command::DoCommand(const std::string& chatString)
{
	CommandParam param( chatString );
	aCommand->Initialize();
	aCommand->Process( param );

	return aCommand->GetIsCommand() ? true : false;
}


#endif//WIN32