#ifdef WIN32
#include "prefix.h"
#include "netstatcommand.h"
#include "HLServer.h"
#include "CommandParam.h"
#include "Support.h"



NetStatCommand::NetStatCommand(HLClient* client): AbstractCommand( client )
							 
{
}

NetStatCommand::~NetStatCommand(void)
{
}

////////////////
//public

const bool NetStatCommand::Process( CommandParam& param )
{
	if( !PreProcess( NETSTAT_COMMAND, param ) )
	{
		return false;
	}

	char stat[MAX_PATH];
	gServer->GetTransMA()->GetNetStat( stat );
	std::string outString( stat );
	outString = outString.insert( 0 , NTF::loadResourceText( IDS_CHAT_CMD_NETSTAT_HEADER ) );
	outString = outString.append( NTF::loadResourceText( IDS_CHAT_CMD_NETSTAT_FODDER ) );
	NTF::ToChatStyleString( outString );

	this->SendChat( outString );

	isUsingCommand = false;
	return true;

}
#endif//WIN32