#ifdef WIN32
#include "prefix.h"
#include "ratecommand.h"
#include "FileUtils.h"
#include "HLServer.h"
#include "HLClient.h"
#include "CommandParam.h"
#include "Support.h"

RateCommand::RateCommand(HLClient* client): AbstractCommand( client )

{
}

RateCommand::~RateCommand(void)
{
}


////////////////
//public

const bool RateCommand::Process( CommandParam& param )
{
	if( !PreProcess( RATE_COMMAND, param ) )
	{	
		return false;
	}

	long rate = -1L;
	LONGLONG rateValue = 0;

	std::string outString;
	bool noRate = false;
	if( !gServer->Config().use_rate )
	{
		outString.assign(NTF::loadResourceText( IDS_CHAT_CMD_RATE_NOT_USING ));
		NTF::ToChatStyleString( outString );
		noRate = true;
	}
	else if( (rate = HLTransfer::GetRate( this->client->User().Login() )) == -1 )
	{
		outString.assign(NTF::loadResourceText(IDS_CHAT_CMD_RATE_NOT_USING_FOR_YOU));
		NTF::ToChatStyleString( outString );
		noRate = true;
	}
	else
	{
		try
		{
			rateValue = HLTransfer::LoadRateValue(this->client->User().Login().c_str());
		}
		catch( ... )
		{
			rateValue = 0;
		}
	}

	if( !noRate )
	{
		rateValue *= rate;
		outString.assign( NTF::loadResourceText( IDS_CHAT_HEADER ));
		outString.append( NTF::loadResourceText( IDS_CHAT_CMD_RATE ));
		char rateBuff[MAX_PATH];
		sprintf( rateBuff , "%d" , rate );
		outString.append( rateBuff );
		outString.append( NTF::loadResourceText( IDS_CHAT_FODDER ) );
		std::string rateValueString("");
		FileUtils::formatSize( rateValue , rateValueString );
		outString.assign( NTF::loadResourceText( IDS_CHAT_HEADER ));
		outString.append( NTF::loadResourceText( IDS_CHAT_CMD_RATE_DOWNLOAD_HEADER ) );
		outString.append( rateValueString );
		outString.append( NTF::loadResourceText(IDS_CHAT_CMD_RATE_DOWNLOAD_FODDER) );
		outString.append( NTF::loadResourceText( IDS_CHAT_FODDER ) );
	}

	this->SendChat( outString );

	isUsingCommand = false;
	return true;


}
#endif//WIN32