#include "Support.h"


namespace NTF{

	void splitString(const string &inString, const string &inDelimiter, vector<string> &outStrings)
	{
		string::size_type delPos = 0;
		string::size_type startPos = 0;
		while ((delPos = inString.find(inDelimiter, startPos)) != string::npos)
		{
			if (delPos - startPos > 0)
			{
				string subStr = inString.substr(startPos, delPos - startPos);
				outStrings.push_back(subStr);
			}
			startPos = delPos + inDelimiter.length();
		}

		// catch the straggler
		// this will get whatever is after the last delimiter until the end of the string
		if (startPos != 0 && startPos < inString.length())
			outStrings.push_back(inString.substr(startPos));

		// don't let them leave empty handed
		// if the string doesn't contain the delimiter then we return the string
		if (outStrings.empty())
			outStrings.push_back(inString);
	}

}