// TabPage4.cpp : t@C
//
#ifdef WIN32
#include "stdafx.h"
#include "winterra.h"
#include "TabPage4.h"
#include "tabpage4.h"
#include "winterraDlg.h"
#include "HLServer.h"
#include "FileUtils.h"
#include "ServerLog.h"
#include "Support.h"


// CTabPage4 _CAO

IMPLEMENT_DYNAMIC(CTabPage4, CDialog)
CTabPage4::CTabPage4(CWnd* pParent /*=NULL*/)
	: CDialog(CTabPage4::IDD, pParent)
{
}

CTabPage4::~CTabPage4()
{
}

void CTabPage4::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_NEWS_EDIT, m_NewsEdit);
}


BEGIN_MESSAGE_MAP(CTabPage4, CDialog)
	ON_BN_CLICKED(IDC_NEWS_RELOAD, OnBnClickedNewsReload)
	ON_BN_CLICKED(IDC_NEWS_SAVE, OnBnClickedNewsSave)
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
END_MESSAGE_MAP()


// CTabPage4 bZ[W nh

void CTabPage4::OnBnClickedNewsReload()
{
	CwinterraDlg * dlg = (CwinterraDlg *)AfxGetMainWnd();
	dlg->showNews();
}

void CTabPage4::OnBnClickedNewsSave()
{
	CString news;
	this->m_NewsEdit.GetWindowText( news );
	CwinterraDlg * dlg = (CwinterraDlg *)AfxGetMainWnd();
	std::string str_news = NTF::CstringToString( news );

	FileUtils::fixLineEndings( str_news  );

	gServer->getDataBase()->SetNewsFile( str_news );

	FILE *fp;
	fp = fopen( gServer->Config().newsPath.c_str() , "wb" );
	if( fp == NULL ) return;

	if( fwrite( str_news.c_str() , str_news.length() , 1 , fp ) < 1 )
	{
		ServerLog::ErrorLog(__FILE__, __LINE__, "error saving news file: %s", strerror(errno));
		return;
	}

	fclose( fp );
}

void CTabPage4::OnBnClickedCancel()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	//OnCancel();
}
#endif//WIN32