// winterraDlg.cpp : t@C
//
#ifdef WIN32
#include "stdafx.h"
#include "winterra.h"
#include "winterradlg.h"
#include "ServerLog.h"
#include "HLServer.h"
#include "FileUtils.h"
#include "ServerConf.h"
#include "Support.h"

using namespace NTF;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// AvP[Ṽo[WɎg CAboutDlg _CAO
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

	// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CwinterraDlg _CAO




CwinterraDlg::CwinterraDlg(CWnd* pParent /*=NULL*/)
: CDialog(CwinterraDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CwinterraDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TabCtrl, m_TabCtrl);
}

BEGIN_MESSAGE_MAP(CwinterraDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_TASKTRAY_BTN, OnTaskTrayBtn_Clicked)
	ON_WM_MOUSEMOVE()
	ON_NOTIFY(TCN_SELCHANGING, IDC_TabCtrl, OnSelchangingTabCtrl)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TabCtrl, OnSelchangeTabCtrl)
	ON_WM_HELPINFO()
	ON_COMMAND(ID_OPEN_FOLDER_MENU, OnOpenFolderMenu)
	ON_COMMAND(ID_TRAY_MENU, OnTrayMenu)
	ON_COMMAND(ID_TRAY_RES, OnTrayRes)
	ON_WM_SHOWWINDOW()
	ON_WM_CLOSE()
	ON_COMMAND(ID_QUITE_MENU, OnQuiteMenu)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()



//Thread Proc
unsigned __stdcall ServerThread( void* pParam )
{
	::main(NULL, NULL);//T[o[Jn

	return 0;
}

// CwinterraDlg bZ[W nh

BOOL CwinterraDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//_crtBreakAlloc = 381;
	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	InitTrayIcon();
	InitTabPages();

	LoadWindowPos(m_hWnd);

	::log_Edit = &this->m_TabPg1.m_LogEdit;

	ServerConf mConf;
	mConf.ReloadConf();
	SetServerInfo(&mConf);


#ifdef _DEBUG
	AllocConsole();
	freopen("con","wa",stdout);
#endif//_DEBUG

    //Create the second thread.
	unsigned threadID;
	_beginthreadex( NULL, 0, &ServerThread, NULL, 0, &threadID );

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}


void CwinterraDlg::SetServerInfo(ServerConf *Conf)
{
	snprintf( objTaskTrayIcon.szTip ,128 , "%s" , Conf->serverName.c_str() );
	Shell_NotifyIcon(NIM_MODIFY, &objTaskTrayIcon);

	char titleBuff[128];
	snprintf(  titleBuff , 128 , "WinTerra - %s" , Conf->serverName.c_str() );
	this->SetWindowText( titleBuff );
}



void CwinterraDlg::InitServerConfig()
{

	ServerConf conf = gServer->Config();

	m_TabPg2.m_serverName.SetWindowText	( gServer->Config().serverName.c_str() );
	m_TabPg2.m_serverDes.SetWindowText	(	gServer->Config().serverDescription.c_str() );

	m_TabPg2.m_PortNumber.SetWindowText	( toString(gServer->Config().serverPort).c_str() );
	m_TabPg2.m_maxUser.SetWindowText		(toString(gServer->Config().maxUsers).c_str() );
	m_TabPg2.m_maxDownLoad.SetWindowText(toString(gServer->Config().maxDownloads).c_str());
	m_TabPg2.m_maxUpload.SetWindowText	(toString(gServer->Config().maxUploads).c_str() );

	m_TabPg2.m_fileFolder.SetWindowText	(gServer->Config().rootPath.c_str() );
	m_TabPg2.m_agreementFile.SetWindowText( gServer->Config().agreementPath.c_str() );
	m_TabPg2.m_newsFile.SetWindowText( gServer->Config().newsPath.c_str() );
	m_TabPg2.m_AccountFolder.SetWindowText( gServer->Config().accountsPath.c_str() );
	m_TabPg2.m_logFolder.SetWindowText(gServer->Config().logsPath.c_str() );


	//2003/08/07 added.
	m_TabPg2.m_MaxUpSpeed.SetWindowText( toString( NTF::BpsToKB_sec(gServer->Config().max_upload_speed)).c_str() );
	m_TabPg2.m_MaxDownSpeed.SetWindowText( toString( NTF::BpsToKB_sec(gServer->Config().max_download_speed)).c_str() );


	TrackerList::const_iterator iter = gServer->Config().trackerList.begin();
	string trackerListString;
	while (iter != gServer->Config().trackerList.end())
	{
		if( (*iter).addr != "" )
		{
			trackerListString.append((*iter).addr + ":" + (*iter).pass + "\r\n");
		}
		iter++;
	}

	m_TabPg2.m_trackerList.SetWindowText( trackerListString.c_str() );

	m_TabPg2.m_greeting_check.SetCheck( gServer->Config().greeting_check ? BST_CHECKED : BST_UNCHECKED );

	//2003/08/28 added by ortana.
	m_TabPg7.m_command_check.SetCheck( gServer->Config().command_check ? BST_CHECKED : BST_UNCHECKED );
	m_TabPg7.m_guest_command_check.SetCheck( gServer->Config().guest_command_check  ? BST_CHECKED : BST_UNCHECKED );
	m_TabPg7.m_lognPM_check.SetCheck( gServer->Config().loginPM_check ? BST_CHECKED : BST_UNCHECKED );
	m_TabPg7.m_guestPM_check.SetCheck( gServer->Config().guestPM_check ? BST_CHECKED : BST_UNCHECKED );
	m_TabPg7.m_loginPM_edit.SetWindowText( gServer->Config().loginPM_text.c_str() );
	m_TabPg7.m_upNews_check.SetCheck( gServer->Config().upNews_check ? BST_CHECKED : BST_UNCHECKED );
	m_TabPg7.m_up_chat_check.SetCheck( gServer->Config().upChat_check ? BST_CHECKED : BST_UNCHECKED );
	m_TabPg7.OnBnClickedPmCheck();
	m_TabPg7.OnBnClickedCommandCheck();

}

void	CwinterraDlg::SaveTrackerList()
{
	CString strText, strLine;
	string trackerListString;
	int nLineCount = m_TabPg2.m_trackerList.GetLineCount();
	for (int i = 0 ;i < nLineCount ; i++)
	{
		int len = m_TabPg2.m_trackerList.LineLength(m_TabPg5.m_BanTable_Edit.LineIndex(i));
		if( len <= 0 ){ continue; }
		m_TabPg2.m_trackerList.GetLine(i, strText.GetBuffer(len), len);
		strText.ReleaseBuffer(len);
		if( strText[0] != 11 && strText != " ")
		{
			trackerListString.append( NTF::CstringToString(strText) + '\r' );
		}
	}

	//string trackerListString = str;
	string trackerDelimiter = "\r";
	string passwordDelimiter = ":";
	vector<string> trackers;
	FileUtils::fixLineEndings(trackerListString);
	NTF::splitString(trackerListString, trackerDelimiter, trackers);
	vector<string>::iterator iter = trackers.begin();
	while (iter != trackers.end())
	{
		vector<string> trackerItem;
		NTF::splitString((*iter), passwordDelimiter, trackerItem);
		if (trackerItem.size() == 1)
		{
			string emptyString;
			gServer->Config().trackerList.push_back(TrackerEntry(trackerItem[0], emptyString));
		}
		else if (trackerItem.size() > 1)
			gServer->Config().trackerList.push_back(TrackerEntry(trackerItem[0], trackerItem[1]));
		iter++;
	}
}

void	CwinterraDlg::SetServerConfig()
{
	CString str;


	m_TabPg2.m_serverName.GetWindowText( str );
	gServer->Config().serverName = NTF::CstringToString(str);

	m_TabPg2.m_serverDes.GetWindowText( str );
	gServer->Config().serverDescription = NTF::CstringToString(str);

	
	m_TabPg2.m_PortNumber.GetWindowText( str );

	if( atoi( (LPCTSTR)str ) != gServer->Config().serverPort )
	{
		AfxMessageBox( NTF::loadResourceText( IDS_GUI_CHANGE_PORT_MSG ).c_str() , MB_OK|MB_ICONINFORMATION);
	}
	gServer->Config().serverPort = atoi( (LPCTSTR)str ); 

	//ŃT[o[Ȃǂ̏Zbg
	SetServerInfo(&gServer->Config());

	

	m_TabPg2.m_maxUser.GetWindowText( str );
	gServer->Config().maxUsers = atoi( (LPCTSTR)str ); 

	m_TabPg2.m_maxDownLoad.GetWindowText( str );
	gServer->Config().maxDownloads = atoi( (LPCTSTR)str ); 

	m_TabPg2.m_maxUpload.GetWindowText( str );
	gServer->Config().maxUploads = atoi( (LPCTSTR)str );


	m_TabPg2.m_fileFolder.GetWindowText( str );
	gServer->Config().rootPath = NTF::CstringToString(str);

	m_TabPg2.m_agreementFile.GetWindowText( str );
	gServer->Config().agreementPath = NTF::CstringToString(str);

	m_TabPg2.m_newsFile.GetWindowText( str );
	gServer->Config().newsPath = NTF::CstringToString(str);

	m_TabPg2.m_AccountFolder.GetWindowText( str );
	gServer->Config().accountsPath = NTF::CstringToString(str);

	m_TabPg2.m_logFolder.GetWindowText( str );
	gServer->Config().logsPath =  NTF::CstringToString(str);

	gServer->Config().trackerList.clear();

	//gbJ[
	SaveTrackerList();


	//2003/08/07 added.
	m_TabPg2.m_MaxUpSpeed.GetWindowText( str );
	gServer->Config().max_upload_speed = NTF::KB_secToBps(atoi( (LPCTSTR)str ));
	m_TabPg2.m_MaxDownSpeed.GetWindowText( str );
	gServer->Config().max_download_speed = NTF::KB_secToBps(atoi( (LPCTSTR)str ));
	gServer->Config().greeting_check = m_TabPg2.m_greeting_check.GetCheck() == BST_CHECKED ? true : false;

	//2003/08/28 added
	gServer->Config().command_check = m_TabPg7.m_command_check.GetCheck() == BST_CHECKED ? true : false;
	gServer->Config().guest_command_check = m_TabPg7.m_guest_command_check.GetCheck() == BST_CHECKED ? true : false;
	gServer->Config().loginPM_check = m_TabPg7.m_lognPM_check.GetCheck() == BST_CHECKED ? true : false;
	gServer->Config().guestPM_check = m_TabPg7.m_guestPM_check.GetCheck() == BST_CHECKED ? true : false;
	gServer->Config().upNews_check = m_TabPg7.m_upNews_check.GetCheck()  == BST_CHECKED ? true : false;
	gServer->Config().upChat_check = m_TabPg7.m_up_chat_check.GetCheck() == BST_CHECKED ? true : false;
	
	//PM_Msg on User Logining.
	m_TabPg7.m_loginPM_edit.GetWindowText( str );
	std::string pm_str = NTF::CstringToString(str);
	gServer->Config().loginPM_text = pm_str;
	//save
	gServer->Config().WriteConf( gServer->Config().confFile.c_str() );
}


void CwinterraDlg::InitTrayIcon()
{
	objTaskTrayIcon.hWnd = this->m_hWnd;
	objTaskTrayIcon.uID = 0;									
	objTaskTrayIcon.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	objTaskTrayIcon.uCallbackMessage = MY_NOTIFYICON;
	objTaskTrayIcon.hIcon = this->GetIcon(false);
	lstrcpy(objTaskTrayIcon.szTip, "Winterra");
	objTaskTrayIcon.cbSize = sizeof(objTaskTrayIcon);

	Shell_NotifyIcon(NIM_ADD, &objTaskTrayIcon);
}


void CwinterraDlg::InitTabPages()
{
	TC_ITEM myTCitem;  //^uACe\
	//^uRg[ɍڂ̒ǉ
	myTCitem.mask = TCIF_TEXT;
	myTCitem.pszText = "O"; //^ǔo̐ݒ
	m_TabCtrl.InsertItem(0, &myTCitem); //^uRg[ɍڂ}
	myTCitem.pszText = "ݒ";
	m_TabCtrl.InsertItem(1, &myTCitem);
	myTCitem.pszText = "AO[g";
	m_TabCtrl.InsertItem(2, &myTCitem);
	myTCitem.pszText = "j[X";
	m_TabCtrl.InsertItem(3, &myTCitem);
	myTCitem.pszText = "BANݒ";
	m_TabCtrl.InsertItem(4, &myTCitem);
	myTCitem.pszText = "[gݒ";
	m_TabCtrl.InsertItem(5, &myTCitem);
	myTCitem.pszText = "ݒ";
	m_TabCtrl.InsertItem(6, &myTCitem);
	

	//Tab ControleEBhEƂĊe^uy[W쐬
	m_TabPg1.Create(IDD_TabPage1, &m_TabCtrl);
	m_TabPg2.Create(IDD_TabPage2, &m_TabCtrl);
	m_TabPg3.Create(IDD_TabPage3, &m_TabCtrl);
	m_TabPg4.Create(IDD_TabPage4, &m_TabCtrl);
	m_TabPg5.Create(IDD_TabPage5, &m_TabCtrl);
	m_TabPg6.Create(IDD_TabPage6, &m_TabCtrl);
	m_TabPg7.Create(IDD_TabPage7, &m_TabCtrl);

	//\Ԃ̐ݒ
	m_TabPg1.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_SHOWWINDOW);
	m_TabPg2.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
	m_TabPg3.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
	m_TabPg4.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
	m_TabPg5.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
	m_TabPg6.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
	m_TabPg7.SetWindowPos(&wndTop, 10, 30, 0, 0, SWP_NOSIZE | SWP_HIDEWINDOW);
}

void CwinterraDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CwinterraDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//[U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CwinterraDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CwinterraDlg::OnTaskTrayBtn_Clicked()
{
	this->ShowWindow(0);
}



void CwinterraDlg::OnSelchangingTabCtrl(NMHDR *pNMHDR, LRESULT *pResult)
{
	int int_index = m_TabCtrl.GetCurSel(); //؂ւOTabIndexԍ
	//IꂽTab̂ݕ\B
	switch(int_index){
case 0:
	m_TabPg1.ShowWindow(SW_HIDE);
	break;
case 1:
	m_TabPg2.ShowWindow(SW_HIDE);
	break;
case 2:
	m_TabPg3.ShowWindow(SW_HIDE);
	break;
case 3:
	m_TabPg4.ShowWindow(SW_HIDE);
	break;

case 4:
	m_TabPg5.ShowWindow(SW_HIDE);
	break;

case 5:
	m_TabPg6.ShowWindow(SW_HIDE);
	break;

case 6:
	m_TabPg7.ShowWindow(SW_HIDE);
	break;

	}


	*pResult = 0;
}

void CwinterraDlg::OnSelchangeTabCtrl(NMHDR *pNMHDR, LRESULT *pResult)
{
	int int_index = m_TabCtrl.GetCurSel(); //؂ւTabIndexԍ
	//IꂽTab̂ݕ\B
	switch(int_index){
case 0:
	m_TabPg1.ShowWindow(SW_SHOW);
	break;
case 1:
	InitServerConfig();
	m_TabPg2.ShowWindow(SW_SHOW);
	break;
case 2:
	showAgreement();
	m_TabPg3.ShowWindow(SW_SHOW);
	break;
case 3:
	showNews();
	m_TabPg4.ShowWindow(SW_SHOW);
	break;
case 4:
	loadBanList();
	m_TabPg5.ShowWindow(SW_SHOW);
	break;
case 5:
	LoadRateConf();
	m_TabPg6.ShowWindow(SW_SHOW);
	break;
case 6:
	InitServerConfig();
	m_TabPg7.ShowWindow(SW_SHOW);
	break;
	}



	*pResult = 0;
}

BOOL CwinterraDlg::PreTranslateMessage(MSG* pMsg)
{

	if(pMsg->message == WM_KEYDOWN)
	{
		if(pMsg->wParam == VK_RETURN ||
			pMsg->wParam == VK_ESCAPE)
		{
			return FALSE;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CwinterraDlg::OnHelpInfo(HELPINFO* pHelpInfo)
{
	//return CDialog::OnHelpInfo(pHelpInfo);
	return FALSE;
}

CwinterraDlg::~CwinterraDlg()
{
}

void CwinterraDlg::OnOpenFolderMenu()
{
	char path[MAX_PATH];
	FileUtils::getAbsolutePath(gServer->Config().rootPath.c_str() , path);
	ShellExecute(0,"open",
		path,
		NULL,NULL,
		SW_SHOWNORMAL);
}

void CwinterraDlg::OnTrayMenu()
{
	OnTaskTrayBtn_Clicked();
}




void CwinterraDlg::showAgreement()
{
	std::string agree;
	gServer->getDataBase()->GetAgreement( agree );
	string p("\r");
	string pl("\r\n");
	agree = NTF::replace_all_target( agree , p , pl );
	m_TabPg3.m_agreeEdit.SetWindowText( agree.c_str() );
}

void CwinterraDlg::showNews()
{
	std::string news;
	gServer->getDataBase()->GetNewsFile( news );
	string p("\r");
	string pl("\r\n");
	news = NTF::replace_all_target( news , p , pl );
	m_TabPg4.m_NewsEdit.SetWindowText( news.c_str() );
}


void CwinterraDlg::OnTrayRes()
{
	this->ShowWindow(1);
	this->SetForegroundWindow();
}

LRESULT CwinterraDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch (message) {
		case MY_NOTIFYICON:
			switch (lParam) {
		case WM_MOUSEMOVE:
			break;
		case WM_LBUTTONDBLCLK:
			break;
		case WM_LBUTTONDOWN:
			if( this->IsWindowVisible())
			{
				this->ShowWindow(0);
			}
			else
			{
				this->ShowWindow(1);
				this->SetForegroundWindow();
			}
			break;
		case WM_LBUTTONUP:
			break;
		case WM_RBUTTONDBLCLK:
			break;
		case WM_RBUTTONUP:
			break;
		case WM_RBUTTONDOWN:
			this->SetForegroundWindow();
			this->SetFocus();


			CMenu menu;
			VERIFY(menu.LoadMenu(IDR_NOTIFY_MENU));
			CMenu* pPopup = menu.GetSubMenu(0);
			ASSERT(pPopup != NULL);

			if( !this->IsWindowVisible() )
			{
				pPopup->RemoveMenu( ID_TRAY_MENU , MF_BYCOMMAND );
			}
			else
			{
				pPopup->RemoveMenu( ID_TRAY_RES , MF_BYCOMMAND );
			}

			POINT p;
			GetCursorPos( &p );
			pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
				p.x, p.y, this);


			PostMessage( WM_NULL );
			break;
			}
			break;
	}
	return CDialog::WindowProc(message, wParam, lParam);
}



char *CwinterraDlg::GetIniFilePath()
{
	char *lpResult;

	lpResult = new char[MAX_PATH];
	GetCurrentDirectory(MAX_PATH,lpResult);
	sprintf( lpResult , "%s\\data\\winterra.ini" ,lpResult );
	return lpResult;
}


void CwinterraDlg::SaveWindowPos(HWND hWnd)
{
	char *lpIniFilePath;
	lpIniFilePath = GetIniFilePath();

	WINDOWPLACEMENT wp;
	::GetWindowPlacement(hWnd, &wp);

	char lpSet[33];
	ltoa(wp.rcNormalPosition.left	, lpSet, 10);
	WritePrivateProfileString("WinPos", "left"	 , lpSet, lpIniFilePath);
	ltoa(wp.rcNormalPosition.right	, lpSet, 10);
	WritePrivateProfileString("WinPos", "right"	 , lpSet, lpIniFilePath);
	ltoa(wp.rcNormalPosition.top	, lpSet, 10);
	WritePrivateProfileString("WinPos", "top"	 , lpSet, lpIniFilePath);
	ltoa(wp.rcNormalPosition.bottom	, lpSet, 10);
	WritePrivateProfileString("WinPos", "bottom" , lpSet, lpIniFilePath);
	ltoa(wp.showCmd					, lpSet, 10);
	WritePrivateProfileString("WinPos", "showCmd", lpSet, lpIniFilePath);

	delete [] lpIniFilePath;
}

void CwinterraDlg::LoadWindowPos(HWND hWnd)
{
	::ShowWindow(hWnd, SW_MINIMIZE);

	char *lpIniFilePath;
	lpIniFilePath = GetIniFilePath();

	WINDOWPLACEMENT wp;
	::GetWindowPlacement(hWnd, &wp);

	char lpDef[33];
	char lpRes[33];

	ltoa(wp.rcNormalPosition.left	, lpDef, 10);
	GetPrivateProfileString("WinPos", "left"   , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.left	= atol(lpRes);

	ltoa(wp.rcNormalPosition.right	, lpDef, 10);
	GetPrivateProfileString("WinPos", "right"  , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.right	= atol(lpRes);

	ltoa(wp.rcNormalPosition.top	, lpDef, 10);
	GetPrivateProfileString("WinPos", "top"	   , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.top		= atol(lpRes);

	ltoa(wp.rcNormalPosition.bottom	, lpDef, 10);
	GetPrivateProfileString("WinPos", "bottom" , lpDef, lpRes, 33, lpIniFilePath);
	wp.rcNormalPosition.bottom	= atol(lpRes);

	ltoa(wp.showCmd					, lpDef, 10);
	GetPrivateProfileString("WinPos", "showCmd", lpDef, lpRes, 33, lpIniFilePath);
	wp.showCmd					= atol(lpRes);

	::SetWindowPlacement(hWnd, &wp);

	delete [] lpIniFilePath;
}


void CwinterraDlg::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	//if (bShow)
	//{
	//	LoadWindowPos(m_hWnd);
	//}
}

void CwinterraDlg::OnClose()
{
	int ret = -1;
	ret = AfxMessageBox("IĂ낵łH", MB_OKCANCEL|MB_ICONWARNING);
	if( IDCANCEL == ret )
	{
		return;
	}
	gServer->Stop();
#ifdef _DEBUG
	FreeConsole();
#endif
	SaveWindowPos(this->m_hWnd);
	CDialog::OnClose();
}

void CwinterraDlg::OnQuiteMenu()
{
	::SendMessage(this->m_hWnd ,  WM_CLOSE , 0 , 0 );
}

void CwinterraDlg::loadBanList()
{
	if( gServer == NULL )
	{
		return;
	}

	this->m_TabPg5.m_BanTable_Edit.SetWindowText( (gServer->getHLBan().getList()).c_str() );
}

void CwinterraDlg::setBanList()
{
	if( gServer == NULL )
	{
		return;
	}

	CString strText, strLine;
	string str;
	
	m_TabPg5.m_BanTable_Edit.GetWindowText( strText );
	gServer->getHLBan().save( NTF::CstringToString( strText ).c_str() );
}

void CwinterraDlg::SetRateConf()
{
	CString str;
	m_TabPg6.m_rate_edit.GetWindowText( str );
	gServer->Config().raw_rate_conf = NTF::CstringToString(str);

	gServer->Config().use_rate = m_TabPg6.m_rate_check.GetCheck() ? BST_CHECKED : BST_UNCHECKED;
	gServer->Config().WriteConf( gServer->Config().confFile.c_str() );

}
void CwinterraDlg::LoadRateConf()
{
	m_TabPg6.m_rate_edit.SetWindowText( gServer->Config().raw_rate_conf.c_str() );

	m_TabPg6.m_rate_check.SetCheck( gServer->Config().use_rate ? BST_CHECKED : BST_UNCHECKED );
}
void CwinterraDlg::OnBnClickedOk()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	::SendMessage(this->m_hWnd ,  WM_CLOSE , 0 , 0 );
	//OnOK();
}
#endif//WIN32