/* WinUMP.c */

/*      WinUMP  Midi plugin for Mozilla  with TiMidity++
                               Ver 0.0.1 (Pre Alpha 1)
     ------------------------------------------------------------
     Copyright (C) 2002N Keishi Suenaga
                              ----------

     {vO̓t[E\tgEFAłBȂ́AFree Software Foundation 
     \GNU ʌLgṕuo[WQv͂ȍ~̊eo[W
     ̒炢ꂩIÃo[W߂ɏ]Ė{vO
     ĔЕz܂͕ύX邱Ƃł܂B

     {vO͗LpƂ͎v܂AЕzɂẮAsꐫyѓړIK
     ɂĂ̈Öق̕ۏ؂܂߂āAȂۏ؂sȂ܂BڍׂɂĂ
     GNU ʌLgpǂ݂B

     Ȃ́A{vOƈꏏGNU ʌLgp̎ʂ󂯎Ă
     ͂łBłȂꍇ́AFree Software Foundation, Inc., 675 Mass Ave,
     Cambridge, MA 02139, USA ֎莆ĂB

     Keishi Suenaga̘A     E-mail:skeishi@users.sourceforge.jp
*/
#if !defined(__GNUC__)
#define  strcasecmp stricmp
#endif

#include <windows.h>
#include <stdio.h>                               /* sprintf(), fprintf(), etc. */
#include <fcntl.h>                               /* O_RDWR */
#include "npapi.h"

#include "resource.h"

#define ID_STOP_BUTTON 1500
#define ID_PAUSE_BUTTON 1501
#define ID_PLAY_BUTTON 1502
#define ID_PLUS_BUTTON 1503
#define ID_MINUS_BUTTON 1504

#define BUFSIZE 4048
#define PIPE_R 0
#define PIPE_W 1

//GUI֌W
static HBITMAP hBase;
static HBITMAP hMinus;
static HBITMAP hPause;
static HBITMAP hPlay;
static HBITMAP hPlus;
static HBITMAP hStop;
static HBITMAP hTitle;
static HBITMAP hPauseOn;
static HBITMAP hPlayOn;

int     X_Base,Y_Base;
int     X_Minus,Y_Minus;
int     X_Pause,Y_Pause;
int     X_Play,Y_Play;
int     X_Plus,Y_Plus;
int     X_Stop,Y_Stop;
int     X_Title,Y_Title;


HANDLE hThread=NULL;
static DWORD dwThreadId;
static STARTUPINFO StartupInfo;


//L֘A
#define MAPPING_MAX  1000                  //}bsOIuWFNg̍ōl(ύX\)
#define MAPPING_NAME "WinUMP shared memory" //}bsOIuWFNg(ύX\)

static HANDLE hFileMap1; //}bsOIuWFNg̃nh
static LPVOID MapAdress;

typedef struct _WinUMPSM
{
	char command;
	short int PlayId;
} WinUMPSM;

static int useLC =1;
			
//摜𒆉ɂׂXW(LEFT)YW(TOP)Zo}N
#define CenterX(Width) ((0)<((Rect.right - Rect.left - Width) / 2) ? ((Rect.right - Rect.left - Width) / 2) :(0))
#define CenterY(Height) ((0)<((Rect.bottom - Rect.top - Height) / 2) ? ((Rect.bottom - Rect.top - Height) / 2) :(0))


// TIMIDITỸftHgl
#ifndef DEFAULT_PATH
#define DEFAULT_PATH "c:\\timidity"
#endif /* DEFAULT_PATH */
static const char *timdir = DEFAULT_PATH;

// xvZbT̂߂ɒxTvO[gftHg
static int eightKFlag = 0;
static int timid_ump_rate = 0;
static char *timid_ump_interface = "pqq";

static void loadBitmaps()
{
			BITMAP  BMPINFO ;
			HINSTANCE hInst; 

			hInst = LoadLibrary( "NPWinUMP32.dll");
         	hBase =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(BASE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hMinus =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(MINUS_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPause =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PAUSE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPlay =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PLAY_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPlus =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PLUS_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hStop =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(STOP_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hTitle =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(TITLE_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
	        hPauseOn =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PAUSEON_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
         	hPlayOn =(HBITMAP)LoadImage(hInst, 
         		MAKEINTRESOURCE(PLAYON_BMP),IMAGE_BITMAP, 0, 0,LR_DEFAULTCOLOR ); 
			
			GetObject(hBase, sizeof(BITMAP), &BMPINFO);
			X_Base=BMPINFO.bmWidth;
			Y_Base=BMPINFO.bmHeight;
			GetObject(hTitle, sizeof(BITMAP), &BMPINFO);
			X_Title=BMPINFO.bmWidth;
			Y_Title=BMPINFO.bmHeight;
			GetObject(hStop, sizeof(BITMAP), &BMPINFO);
			X_Stop=BMPINFO.bmWidth;
			Y_Stop=BMPINFO.bmHeight;
			GetObject(hPause, sizeof(BITMAP), &BMPINFO);
			X_Pause=BMPINFO.bmWidth;
			Y_Pause=BMPINFO.bmHeight;
			GetObject(hPlay, sizeof(BITMAP), &BMPINFO);
			X_Play=BMPINFO.bmWidth;
			Y_Play=BMPINFO.bmHeight;
			GetObject(hPlus, sizeof(BITMAP), &BMPINFO);
			X_Plus=BMPINFO.bmWidth;
			Y_Plus=BMPINFO.bmHeight;
			GetObject(hMinus, sizeof(BITMAP), &BMPINFO);
			X_Minus=BMPINFO.bmWidth;
			Y_Minus=BMPINFO.bmHeight;
}





LRESULT CALLBACK PluginWindowProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
const char* gInstanceLookupString = "instance->pdata";


static const char *filestub = "c:\\tmp\\midi";

typedef enum { PLUGIN_PLAYING, PLUGIN_STOPPED, PLUGIN_PAUSED } pluginPlayState;


typedef struct _PluginInstance
{
	NPWindow*			fWindow;
	uint16				fMode;

	HWND				fhWnd;
	WNDPROC				fDefaultWindowProc;
	
	
  int fd; /* file descriptor for temp file */
  char filename[256]; /* name of same */
  pluginPlayState pluginState; /* stopped, paused, or playing */
  int loop; /* 0 means play only once, non-zero means loop forever */

	short int PlayId;
	

	HWND hMinusButton;
	HWND hPauseButton;
	HWND hPlayButton;
	HWND hPlusButton;
	HWND hStopButton;

} PluginInstance;	


void plusMidiPlayer(PluginInstance* This)
{
	if(This->PlayId==((WinUMPSM *)MapAdress)->PlayId){
   		((char *)MapAdress)[0]='V';
	}
}
void minusMidiPlayer(PluginInstance* This)
{
	if(This->PlayId==((WinUMPSM *)MapAdress)->PlayId){
 		((char *)MapAdress)[0]='v';
	}
}


void pauseMidiPlayer(PluginInstance* This)
{
		if(This->PlayId==((WinUMPSM *)MapAdress)->PlayId){
   			((char *)MapAdress)[0]=' ';
		}
}


void stopMidiPlayer(PluginInstance* This){
	DWORD ExitCode;


	((char *)MapAdress)[0]='q';
//    do{
//    	GetExitCodeThread(hThread,&ExitCode);
//    }while(ExitCode==STILL_ACTIVE);
GetExitCodeThread(hThread, &ExitCode);
TerminateThread(hThread, ExitCode); //͊댯Ȃ̂Ȃłł͂܂Ƃ܂Ȃ
	WaitForSingleObject(hThread, INFINITE);
	CloseHandle(hThread);
	hThread=NULL;
}

void kstopMidiPlayer(PluginInstance* This){
		if(This->PlayId==((WinUMPSM *)MapAdress)->PlayId){
			stopMidiPlayer(This);
		}
}
extern  int timiditymain(int argc, char** argv);

DWORD WINAPI ThreadProc(LPVOID filename)
{
    char *argv[16];
	char opt_interface[8];
	char opt_rate[32];
	int argc = 0;


	argv[argc++] = "timidity";
	argv[argc++] = "-Od";

	if(timid_ump_rate <= 0){
		if(eightKFlag==0){	/* check if the user specified 8K rate */
			argv[argc++] = "-s8000";
		}else{
			argv[argc++] = "-s22050"; 
		}
	}else
	{
	  sprintf(opt_rate, "-s%d", timid_ump_rate);
	  argv[argc++] = opt_rate;
	}

	opt_interface[0] = '-';
	opt_interface[1] = 'i';
	strncpy(opt_interface + 2, timid_ump_interface, sizeof(opt_interface) - 3);
	opt_interface[sizeof(opt_interface) - 1] = '\0';
	argv[argc++] = opt_interface;

	argv[argc++] = (char *)filename;
	argv[argc] = NULL;

    /* change to the configuration directory */
    chdir(timdir);


                       
	timiditymain(argc, argv);
    	
   

	
	return 0;
}
void startMidiPlayer(PluginInstance* This)
//(STARTUPINFO StartupInfo, HWND hWnd, const char *filename, int loop, int start)
{  	
	LPVOID filename;
	
	
	if(hThread!=NULL){
		stopMidiPlayer(This);
	}
	
	filename=(void *)(This->filename);


	 ((char *)MapAdress)[0]='1';
	
    chdir(timdir);
	hThread=CreateThread(NULL,0,ThreadProc,filename,0,&(dwThreadId));
	if(hThread==NULL){
			MessageBox(This->fhWnd, "Timidity vZX̍쐬Ɏs܂", 
				"WinUMPG[", MB_OK | MB_ICONERROR);
		return;
	}
	((WinUMPSM *)MapAdress)->PlayId=((WinUMPSM *)MapAdress)->PlayId+1;
	if(((WinUMPSM *)MapAdress)->PlayId>=128){
		((WinUMPSM *)MapAdress)->PlayId=((WinUMPSM *)MapAdress)->PlayId-128;
	}
	This->PlayId=((WinUMPSM *)MapAdress)->PlayId;
	((char *)MapAdress)[0]='r';
}


extern int setupLiveConnect(NPP instance, PluginInstance *This);


static void DrawButtons(PluginInstance* This)
{
			HDC hMem,hDC;
			
			hDC=GetDC(This->hStopButton);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hStop);
			BitBlt(hDC, 0,0, \
							X_Stop, \
                            Y_Stop, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(This->fhWnd,hDC);

			hDC=GetDC(This->hPauseButton);
			hMem = CreateCompatibleDC(hDC); 
			if(This->pluginState!=PLUGIN_PAUSED){
				SelectObject(hMem, hPause);
			}else{
				SelectObject(hMem, hPauseOn);
			}
			BitBlt(hDC, 0,0, \
							X_Pause, \
                            Y_Pause, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(This->fhWnd,hDC);

	hDC=GetDC(This->hPlayButton);
			hMem = CreateCompatibleDC(hDC);
			if(This->pluginState==PLUGIN_STOPPED){
				SelectObject(hMem, hPlay);
			}else{
				SelectObject(hMem, hPlayOn);
			}
			BitBlt(hDC, 0,0, \
							X_Play, \
                            Y_Play, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(This->fhWnd,hDC);	

			hDC=GetDC(This->hPlusButton);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hPlus);
			BitBlt(hDC, 0,0, \
							X_Plus, \
                            Y_Plus, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(This->fhWnd,hDC);

			hDC=GetDC(This->hMinusButton);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hMinus);
			BitBlt(hDC, 0,0, \
							X_Minus, \
                            Y_Minus, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(This->fhWnd,hDC);
}

void stopbutton(PluginInstance *This){
	if(This->pluginState!=PLUGIN_STOPPED){
		kstopMidiPlayer(This);
		This->pluginState=PLUGIN_STOPPED;
	}
}


void pausebutton(PluginInstance *This){
	if(This->pluginState==PLUGIN_PLAYING){
		pauseMidiPlayer(This);
		This->pluginState=PLUGIN_PAUSED;
	}else{
		if(This->pluginState==PLUGIN_PAUSED){
			pauseMidiPlayer(This);
			This->pluginState=PLUGIN_PLAYING;
		}
    }
}
void playbutton(PluginInstance *This){
	if(This->pluginState==PLUGIN_PAUSED){
		pauseMidiPlayer(This);
        This->pluginState=PLUGIN_PLAYING;;
	}else{
        if(This->pluginState==PLUGIN_STOPPED){
            startMidiPlayer(This);
            This->pluginState=PLUGIN_PLAYING;
        }
	}
}

void plusbutton(PluginInstance *This){
	plusMidiPlayer(This);
}

void minusbutton(PluginInstance *This){
	minusMidiPlayer(This);
}


NPError
NPP_Initialize(void)
{


  /* see if the user has specified an alternate directory for timidity */
  if(getenv("TIMID_DIR") != NULL) timdir = getenv("TIMID_DIR");
  
  /* see if the user has specified an alternate directory for timidity */
  if(getenv("TIMID_8K") != NULL) eightKFlag = 1;
  if(getenv("TIMID_INTERFACE") != NULL) timid_ump_interface = getenv("TIMID_INTERFACE");
  if(getenv("TIMID_RATE") != NULL) timid_ump_rate = atoi(getenv("TIMID_RATE"));


	
	return NPERR_NO_ERROR;
}





NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
	NPError result = NPERR_NO_ERROR;
	PluginInstance* This;
	
	if (instance == NULL) {
		return NPERR_INVALID_INSTANCE_ERROR;
	}
	instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
	This = (PluginInstance*) instance->pdata;
	if (This == NULL) {
	    return NPERR_OUT_OF_MEMORY_ERROR;
	}
	/* mode is NP_EMBED, NP_FULL, or NP_BACKGROUND (see npapi.h) */
	This->fWindow = NULL;
	This->fMode = mode;
	
	This->fhWnd = NULL;
	This->fDefaultWindowProc = NULL;

	{
	(This->filename)[0]='\0';
  	memset(&(StartupInfo),0,sizeof(STARTUPINFO));
	StartupInfo.cb = sizeof(STARTUPINFO);

    This->pluginState = PLUGIN_PLAYING;
    This->loop = 0;
  }
  
  {
    int i;
    for(i = 0; i < argc; i++) {
      if(strcasecmp(argn[i], "loop") == 0){
		if(strcasecmp(argv[i], "true") == 0 ||
		   strcasecmp(argv[i], "yes") == 0) {
		  This->loop = ~0;
		}
      }
      else if(strcasecmp(argn[i], "autostart") == 0){
	if(strcasecmp(argv[i], "false") == 0 ||
	   strcasecmp(argv[i], "no") == 0) {
	  This->pluginState = PLUGIN_STOPPED;
	}
	
      }
    }
  }

	
	///L̏
//}bsOIuWFNg쐬 
// ̖Ot}bsOIuWFNg̖Oƈvꍇ͂̃}bsOIuWFNgւ̃ANZXvB
  hFileMap1= CreateFileMapping((HANDLE)0xFFFFFFFF,NULL,PAGE_READWRITE,0,MAPPING_MAX,MAPPING_NAME);
  if (hFileMap1==NULL)
  {
     MessageBox(This->fhWnd,"}bsOIuWFNg̍쐬Ɏs(^^;","WinUMPG[",MB_ICONSTOP);
  };

	MapAdress=MapViewOfFile(hFileMap1,FILE_MAP_WRITE,0,0,0); 
    if (MapAdress==NULL){
         MessageBox(0,"}bsOIuWFNg[hł܂ł(^^;","WinUMPG[",MB_ICONSTOP);
    }	
    	
  (void) setupLiveConnect(instance, This);
    	
	return result;
}

NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;
	if( This->fWindow != NULL ) { /* If we have a window, clean
								 * it up. */
		SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
		This->fDefaultWindowProc = NULL;
		This->fhWnd = NULL;
	}




	if (This != NULL) {
		if(This->filename != NULL)
    	  (void) unlink(This->filename);

		stopMidiPlayer(This);

		NPN_MemFree(instance->pdata);
		instance->pdata = NULL;

		DeleteObject(hBase);
		DeleteObject(hMinus);
		DeleteObject(hPause);
		DeleteObject(hPlay);
		DeleteObject(hPlus);
		DeleteObject(hStop);
		DeleteObject(hTitle);
		DeleteObject(hPauseOn);
		DeleteObject(hPlayOn);

		UnmapViewOfFile((LPVOID)MapAdress);
    	if (hFileMap1!=NULL) CloseHandle(hFileMap1);
	}

	return NPERR_NO_ERROR;
}




NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
	NPError result = NPERR_NO_ERROR;
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;


	if( This->fWindow != NULL )

	{
		if( (window == NULL) || ( window->window == NULL ) ) {

			SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
			This->fDefaultWindowProc = NULL;
			This->fhWnd = NULL;
			This->fWindow=window;
			return NPERR_NO_ERROR;
		}

		else if ( This->fhWnd == (HWND) window->window ) {
			InvalidateRect( This->fhWnd, NULL, TRUE );
			UpdateWindow( This->fhWnd );
			This->fWindow=window;
			return NPERR_NO_ERROR;
		}
		else {
			SetWindowLong( This->fhWnd, GWL_WNDPROC, (LONG)This->fDefaultWindowProc);
			This->fDefaultWindowProc = NULL;
			This->fhWnd = NULL;
		}
	}
	else if( (window == NULL) || ( window->window == NULL ) ) {
		This->fWindow=window;
		return NPERR_NO_ERROR;
	}

	This->fDefaultWindowProc = (WNDPROC)SetWindowLong( (HWND)window->window, GWL_WNDPROC, (LONG)PluginWindowProc);
	This->fhWnd = (HWND) window->window;
	SetProp( This->fhWnd, gInstanceLookupString, (HANDLE)This);

	InvalidateRect( This->fhWnd, NULL, TRUE );
	UpdateWindow( This->fhWnd );
	
	This->fWindow = window;
	return result;
}

NPError 
NPP_NewStream(NPP instance,
	      NPMIMEType type,
	      NPStream *stream, 
	      NPBool seekable,
	      uint16 *stype)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;
	
	
	{
	const char *ext, *p;
	ext = stream->url;
  	if((p = strrchr(ext, '/')) != NULL)
	  ext = p + 1;
  	if((p = strchr(ext, '.')) != NULL)
	  ext = p + 1;
	_snprintf(This->filename, sizeof(This->filename), "%s%x.%s", filestub, This, ext);
  	/* open the file to store data in */
  	unlink(This->filename);	/* for security. */
  	This->fd = open(This->filename, O_RDWR|O_CREAT|O_BINARY, 0666);
  	if(This->fd == -1) {
  		This->filename[0]='\0';
    	return NPERR_GENERIC_ERROR;
  	}
	}

	return NPERR_NO_ERROR;
}



int32 STREAMBUFSIZE = 0X0FFFFFFF; 




int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;

	return STREAMBUFSIZE;
}




int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
	if (instance != NULL) {
		PluginInstance* This = (PluginInstance*) instance->pdata;
		len = write(This->fd, buffer, len);
      	if(len <0) close(This->fd);
	}
	return len;
}




NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
	This = (PluginInstance*) instance->pdata;


  close(This->fd);
  
  This->pluginState=PLUGIN_PLAYING;
  startMidiPlayer(This);
  
  NPN_Status(instance, "Playing MIDI file");


	return NPERR_NO_ERROR;
}




void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
	PluginInstance* This;
	if (instance != NULL){
		This = (PluginInstance*) instance->pdata;
	}

}

void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
	if(printInfo == NULL)
		return;

	if (instance != NULL) {
	
		if (printInfo->mode == NP_FULL) {
			printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
	}
}




void
NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
}





int16
NPP_HandleEvent(NPP instance, void* event)
{
	return 0;
}
LRESULT CALLBACK PluginWindowProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	PluginInstance* This = (PluginInstance*) GetProp(hWnd, gInstanceLookupString);

	switch( Msg ) {
		
/*		case WM_CREATE: { //eꂽ炷Ƀ{^;

			This->fDefaultWindowProc(hWnd, Msg, wParam, lParam); 
			break;
		}	
*/
		case WM_DRAWITEM:  {//̃bZ[W߂܂I[i[h[ 
//              hDC = ((LPDRAWITEMSTRUCT)lParam)->hDC;
			
			DrawButtons(This);
			
			This->fDefaultWindowProc(hWnd, Msg, wParam, lParam); 
            break;
		}


		case WM_COMMAND: {
/*			GetExitCodeThread(hThread,&ExitCode);
			if(ExitCode!=STILL_ACTIVE){
				stopMidiPlayer();
				This->pluginState=PLUGIN_STOPPED;
            }
*/
			if(This->PlayId!=((WinUMPSM *)MapAdress)->PlayId){
				This->pluginState=PLUGIN_STOPPED;
			}
            switch (LOWORD(wParam)) {
            	case ID_STOP_BUTTON: {
            		stopbutton(This);
                    break;
            	}
            	case ID_PAUSE_BUTTON:{
            		pausebutton(This);
                    break;
            	}
            	case ID_PLAY_BUTTON:{
            		playbutton(This);
            		break;
            	}
            	case ID_PLUS_BUTTON:{
            		plusbutton(This);
            		break;
            	}
				case ID_MINUS_BUTTON:{
					minusbutton(This);
					break;            			
            	}            		            			
            }
			DrawButtons(This);
			This->fDefaultWindowProc(hWnd, Msg, wParam, lParam);
            break;
		}
		case WM_PAINT: {
			PAINTSTRUCT paintStruct;
			HDC hMem,hDC;
			RECT Rect;
			HBRUSH  hOldBrush;
			int     X,Y;
			int     XO,YO;

			loadBitmaps();
			
			GetClientRect(hWnd, &Rect);
			XO=CenterX(X_Base);
			YO=CenterY(Y_Base);
//			XO=0;
//			YO=0;
			
			// {^̍쐬
			
			if(This->hMinusButton!=NULL) DestroyWindow(This->hMinusButton);
			if(This->hPauseButton!=NULL) DestroyWindow(This->hPauseButton);
			if(This->hPlayButton!=NULL) DestroyWindow(This->hPlayButton);
			if(This->hPlusButton!=NULL) DestroyWindow(This->hPlusButton);
			if(This->hStopButton!=NULL) DestroyWindow(This->hStopButton);

				X=XO;
				Y=YO+Y_Title;
            	This->hStopButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Stop,Y_Stop, //E
                hWnd, //eEBhE
                (HMENU)ID_STOP_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);
				
				X=XO+X_Stop;
				Y=YO+Y_Title;
            	This->hPauseButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Pause,Y_Pause, //E
                hWnd, //eEBhE
                (HMENU)ID_PAUSE_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);
			
				X=XO+X_Stop+X_Pause;
				Y=YO+Y_Title;
            	This->hPlayButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Play,Y_Play, //E
                hWnd, //eEBhE
                (HMENU)ID_PLAY_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);


				X=XO+X_Stop+X_Pause+X_Play;
				Y=YO+Y_Title;
            	This->hPlusButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Plus,Y_Plus, //E
                hWnd, //eEBhE
                (HMENU)ID_PLUS_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);

				X=XO+X_Stop+X_Pause+X_Play+X_Plus;
				Y=YO+Y_Title;
            	This->hMinusButton = CreateWindow("BUTTON",
            	NULL,  //\
                WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
                X, Y, //ʒu
                X_Minus,Y_Minus, //E
                hWnd, //eEBhE
                (HMENU)ID_MINUS_BUTTON, //{^ID
                (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), //CX^Xnh
                NULL);


			// ʂ̏
			
			hDC = BeginPaint( hWnd, &paintStruct );
			
			hOldBrush = ( HBRUSH )SelectObject( hDC, ( HBRUSH )GetStockObject( WHITE_BRUSH ));
			GetClientRect(hWnd, &Rect);
			Rectangle( hDC, Rect.left, Rect.top, Rect.right, Rect.bottom );
			SelectObject( hDC, hOldBrush );
			
			EndPaint( hWnd, &paintStruct );
			ReleaseDC(hWnd,hDC);

			hDC=GetDC(hWnd);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hBase);
			BitBlt(hDC, XO, YO, \
							X_Base, \
                            Y_Base, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    
			ReleaseDC(hWnd,hDC);
			DeleteObject(hBase);


			hDC=GetDC(hWnd);
			hMem = CreateCompatibleDC(hDC);
			SelectObject(hMem, hTitle);
			BitBlt(hDC, XO, YO, \
							X_Title, \
                            Y_Title, \
                            hMem, 0, 0, SRCCOPY);
			DeleteDC(hMem);    ;
			ReleaseDC(hWnd,hDC);
			DeleteObject(hTitle);

			DrawButtons(This);
			
			This->fDefaultWindowProc(hWnd, Msg, wParam, lParam); 
			break;
		} 
		default: { 
			This->fDefaultWindowProc( hWnd, Msg, wParam, lParam);
		}              	

	} 
	return 0;
}

#ifndef INCLUDE_LIVE_CONNECT

int setupLiveConnect(NPP instance, PluginInstance *This){return NPERR_NO_ERROR;}

jref
NPP_GetJavaClass()
{
  return NULL;
}

void
NPP_Shutdown(void)
{
}

#else 

/* IMHO, Live Connect adds lots of overhead and complexity compared to
   the extra functionality it provides (for UMP, anyway). Here we
   allow Java applets or JavaScript to operate the stop/pause/play
   buttons. For this, we must load the "UMP" java class file, which
   must be in the user's CLASSPATH. Then we cannot even operate
   directly on the Widgets, because X gets confused when run from an 
   applet thread, so we use a short (msec) timeout which actually
   does the work. 
   */

#define IMPLEMENT_UMP
#include "UMP.c" /* created by : javac UMP.java; javah -jri -stubs UMP */


int setupLiveConnect(NPP instance, PluginInstance *This){  
  /* store the pointer-to-object for later use (one Java peer per plugin instance) */
	if(useLC==1){
  		UMP_setThis(NPN_GetJavaEnv(), NPN_GetJavaPeer(instance), (jint) This);
	}
  	return NPERR_NO_ERROR;
}

jref
NPP_GetJavaClass(void)
{
	JRIEnv *env;
	env=NPN_GetJavaEnv();
	if(env==NULL){
		MessageBox(0, "Java̎擾s.̃vOC̓lbgXP[v4xpł", 
				"WinUMPG[", MB_OK | MB_ICONERROR);
	useLC=0;
	return NULL;
	}
	return  register_UMP(env);
}

void
NPP_Shutdown(void)
{
	if(useLC==1){
  		unregister_UMP(NPN_GetJavaEnv());
	}
}

extern  JRI_PUBLIC_API(void)
native_UMP_stopSelected(JRIEnv* env, UMP *self, jint This){
  PluginInstance *Ump = (PluginInstance *)This;
	stopbutton(Ump);
}

extern  JRI_PUBLIC_API(void)
native_UMP_playSelected(JRIEnv* env, UMP *self, jint This){
  PluginInstance *Ump = (PluginInstance *)This;
	playbutton(Ump);  
}

extern  JRI_PUBLIC_API(void)
native_UMP_pauseSelected(JRIEnv* env, UMP *self, jint This){
  PluginInstance *Ump = (PluginInstance *)This;
	pausebutton(Ump);  
}

extern  JRI_PUBLIC_API(void)
native_UMP_plusSelected(JRIEnv* env, UMP *self, jint This){
  PluginInstance *Ump = (PluginInstance *)This;
	plusbutton(Ump);
}

extern  JRI_PUBLIC_API(void)
native_UMP_minusSelected(JRIEnv* env, UMP *self, jint This){
  PluginInstance *Ump = (PluginInstance *)This;
	minusbutton(Ump);
}
#endif
 
