package tutorial;

import java.sql.*;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.Message;
import wisdom.core.MessageList;

import wisdom.core.application.IAuthenticate;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IUserSession;
import wisdom.core.runtime.AuthenticateException;
import wisdom.core.session.UserSessionFactory;


/**
 * [U[F؃WbÑTvENX<br>
 * ̃Tvł́Af[^x[XɃANZXAF؏sĂ܂Bo{@link AuthenticateException}
 * ܂߂{@link Message}{@link CoreMessageGenerator }gpĂ܂ɂ͔Cӂ{@link Message}܂߂܂B
 * 
 * @author Takao Kouda
 * @version 1
 */
public class AuthenticateImpl implements IAuthenticate {

	public static final String sql = 
		"select PASSWORD,USERNAME from MUSER where USERID = ?";
	/**
	  * [U[F؂s܂B
	  * @param user [U[ID
	  * @param password pX[h
	  * @exception sɑoOB
	 */	
	public void authenticate(IRequestHandler rh, String user, String password) throws Exception {

		// [UID11ȏ
		if (user != null && user.length() > 10) {
			throw new AuthenticateException(CoreMessageGenerator.getInstance().getMessage("WAE0010"));
		}

		String code = "";
		boolean isValidUser = false;

		PreparedStatement ps = rh.getConnection(this).prepareStatement(sql);

		ps.setString(1, user);
		ResultSet rs = ps.executeQuery();

		String password_ 	= null;		
		String userName 	= null;

		if (rs.next()) {
			password_ 		= rs.getString(1).trim();
			userName 		= rs.getString(2).trim();
			// pX[hv
			if (password.equals(password_)) {
				IUserSession us = UserSessionFactory.create(rh, user );

			// FOK
				isValidUser = true;

			// pX[hsv
			} else {
				code = "WAE0020";
			}

		// [UȂ
		} else {
			code = "WAE0010";
		}

		rs.close();
		ps.close();
		MessageList ml = new MessageList();
		ml.addMessage(CoreMessageGenerator.getInstance().getMessage(code));
		rh.setAttribute("#login", ml);

		if (!isValidUser) throw new AuthenticateException(CoreMessageGenerator.getInstance().getMessage(code));
	}
}
