package tutorial.bbs;

import java.sql.PreparedStatement;

import tutorial.common.Factory;

import wisdom.core.MessageList;
import wisdom.core.command.RequestCommand;
import wisdom.core.util.StringUtil;

import wisdomx.logic.formtemplate.ParameterInputForm;
import wisdomx.ui.builder.StatementBuilder;
import wisdomx.ui.builder.StatementPageListBuilder;
import wisdomx.ui.object.IPageList;

public class BBSCmd extends  RequestCommand { 
	
	public static final String[] PAGES = new String[]
	{"/tutorial/bbs/categorylist.jsp",
	 "/tutorial/bbs/topiclist.jsp","/tutorial/bbs/topicentry.jsp","/tutorial/bbs/topicentryconfirm.jsp",
	 "/tutorial/bbs/topicreslist.jsp","/tutorial/bbs/topicresentry.jsp","/tutorial/bbs/topicresentryconfirm.jsp",
	 };

	/**
	 * o^ĂJeS[ꗗ\邽߂SQLłB
	 */
	public static final String SQL_SEL_CATEGORY = 
		" select " 
		+   "CATEGORYCD," 
		+	"CATEGORYNAME," 
		+	"(select count(*) from TOPIC where CATEGORY.CATEGORYCD = TOPIC.CATEGORYCD)," 
		+	"(select max(CRTDTTM) from TOPIC where CATEGORY.CATEGORYCD = TOPIC.CATEGORYCD) " 
		+" from CATEGORY" 
		+   " order by CATEGORYNAME ";

	public static final String SQL_SEL_TOPIC = 
		"select " 
		+ "TOPICID,"
		+ "TITLE," 
		+ "NAME," 
		+ "(select count(*) from TOPICRES where TOPIC.TOPICID = TOPICRES.TOPICID)," 
		+ "(select max(CRTDTTM) from TOPICRES where TOPIC.TOPICID = TOPICRES.TOPICID)" 
		+	" from TOPIC " +
		"where CATEGORYCD = ? order by CRTDTTM desc";
	
	public static final String SQL_SEL_TOPICRES = 
		"select TITLE,NAME,BODY,CRTDTTM from TOPICRES where TOPICID = ? order by CRTDTTM ";
	
	private MessageList ml = null;
	
	public void _execute() throws Exception {
		String op = rp.getString("op","");
		debug(op);
		
		ml = new MessageList();
		
		if (StringUtil.isEmpty(op) || "categorylist".equals(op)) {
			categorylist();
		} else if ("topiclist".equals(op)) {
			topiclist();
			setCategoryFo();
		} else if ("topicentry".equals(op)) {
			topicentry();
			setCategoryFo();
		} else if ("dotopicentry".equals(op)) {
			dotopicentry();
			setCategoryFo();
		} else if ("backtopicentry".equals(op)) {
			backtopicentry();
			setCategoryFo();
		} else if ("exectopicentry".equals(op)) {
			exectopicentry();
			setCategoryFo();
		} else if ("topicreslist".equals(op)) {
			topicreslist();
			setCategoryFo();
		} else if ("topicresentry".equals(op)) {
			topicresentry();
			setCategoryFo();
		} else if ("dotopicresentry".equals(op)) {
			dotopicresentry();
			setCategoryFo();
		} else if ("backtopicresentry".equals(op)) {
			backtopicresentry();
			setCategoryFo();
		} else if ("exectopicresentry".equals(op)) {
			exectopicresentry();
			setCategoryFo();
		}
	}
	private void categorylist() throws Exception {
		// ꗗ\邽߂PreparedStatement쐬܂B
		PreparedStatement ps = new StatementBuilder(SQL_SEL_CATEGORY,rh.getConnection()).buildStatement();
		
		// ݕ\̃y[Wԍ擾܂B݃y[Whiddenp[^gpAp[^Ȃꍇ͈y[WڂƂ܂B
		int page = rp.getInt("page",1);
		
		// ꗗy[W̃IuWFNg쐬܂B\s20sw肵Ă܂B
		IPageList pageList 
				= new StatementPageListBuilder(ps,Factory.getPageDecorator()).buildPerPageRows(5, page);
		
		// JeS[ꍇ̓bZ[W\܂B
		if (pageList.size() == 0) {
			// TWE0010=o^\ȃJeS[܂B
			ml.addMessage(messageGenerator.getMessage("TWE0010"));
		}
		//Requestֈꗗy[W̃IuWFNgAbZ[WsetAttributeđJڐy[Ww肵܂B
		rh.setAttribute(getName()+"#pageList", pageList);
		rh.setAttribute(getName()+"#ml", ml);
		setPage(PAGES[0]);
	}
	private void topiclist() throws Exception {
		PreparedStatement ps = new StatementBuilder(SQL_SEL_TOPIC,rh.getConnection()).buildStatement();
		ps.setString(1, rp.getString("categorycd"));
		int page = rp.getInt("page_t",1);
		IPageList pageList 
				= new StatementPageListBuilder(ps,Factory.getPageDecorator()).buildPerPageRows(20, page);
		if (pageList.size() == 0) {
			// DCG0011W=gsbN͂܂B
			ml.addMessage(messageGenerator.getMessage("DCG0011W"));
			rh.setAttribute(getName()+"#ml", ml);
		}
		rh.setAttribute(getName()+"#pageList", pageList);
		rh.setAttribute(getName()+"#ml", ml);
		setPage(PAGES[1]);
	}
	private void topicentry() throws Exception {
		TopicFo topic = new TopicFo();
		rh.setAttribute(getName()+"#topic", topic);
		setPage(PAGES[2]);
	}
	private void dotopicentry() throws Exception {
		TopicFo topic = new TopicFo();
		topic.set(rh, rp);
		TopicFop fop = new TopicFop(topic,rh);
		fop.validate();
		rh.setAttribute(getName()+"#topic", topic);
		if (topic.isError()) {
			setPage(PAGES[2]);	
		} else {
			setPage(PAGES[3]);
		}
	}
	private void backtopicentry() throws Exception {
		TopicFo topic = new TopicFo();
		topic.set(rh, rp);
		rh.setAttribute(getName()+"#topic", topic);
		setPage(PAGES[2]);
	}
	private void exectopicentry() throws Exception {
		TopicFo topic = new TopicFo();
		topic.set(rh, rp);
		TopicFop fop = new TopicFop(topic,rh);
		fop.isIgnoreValidate();
		fop.execute();
		rh.setAttribute(getName()+"#topic", topic);
		topiclist();
	}
	private void topicreslist() throws Exception {
		PreparedStatement ps = new StatementBuilder(SQL_SEL_TOPICRES,rh.getConnection()).buildStatement();
		ps.setString(1, rp.getString("topicid"));
		int page = rp.getInt("page_r",1);
		IPageList pageList 
				= new StatementPageListBuilder(ps,Factory.getPageDecorator()).buildPerPageRows(20, page);
		if (pageList.size() == 0) {
			// DCG0011W=gsbN͂܂B
			ml.addMessage(messageGenerator.getMessage("DCG0011W"));
			rh.setAttribute(getName()+"#ml", ml);
		}

		rh.setAttribute(getName()+"#pageList", pageList);
		rh.setAttribute(getName()+"#ml", ml);

		ParameterInputForm pif = new ParameterInputForm();
		pif.saveString(rp, "topicid");
		TopicFog fog = new TopicFog(pif,rh);
		rh.setAttribute(getName()+"#topic", fog.generate());

		setPage(PAGES[4]);
	}	
	private void topicresentry() throws Exception {
		TopicresFo topicres = new TopicresFo();
		rh.setAttribute(getName()+"#topicres", topicres);

		ParameterInputForm pif = new ParameterInputForm();
		pif.saveString(rp, "topicid");
		TopicFog fog = new TopicFog(pif,rh);
		rh.setAttribute(getName()+"#topic", fog.generate());
		
		setPage(PAGES[5]);
	}	
	
	private void dotopicresentry() throws Exception {
		TopicresFo topicres = new TopicresFo();
		topicres.set(rh, rp);
		TopicresFop fop = new TopicresFop(topicres,rh);
		fop.validate();
		rh.setAttribute(getName()+"#topicres", topicres);

		ParameterInputForm pif = new ParameterInputForm();
		pif.saveString(rp, "topicid");
		TopicFog fog = new TopicFog(pif,rh);
		rh.setAttribute(getName()+"#topic", fog.generate());

		if (topicres.isError()) {
			setPage(PAGES[5]);	
		} else {
			setPage(PAGES[6]);
		}
	}	
	private void backtopicresentry() throws Exception {
		TopicresFo topicres = new TopicresFo();
		topicres.set(rh, rp);
		rh.setAttribute(getName()+"#topicres", topicres);

		ParameterInputForm pif = new ParameterInputForm();
		pif.saveString(rp, "topicid");
		TopicFog fog = new TopicFog(pif,rh);
		rh.setAttribute(getName()+"#topic", fog.generate());

		setPage(PAGES[5]);
	}
	private void exectopicresentry() throws Exception {
		TopicresFo topicres = new TopicresFo();
		topicres.set(rh, rp);
		TopicresFop fop = new TopicresFop(topicres,rh);
		fop.isIgnoreValidate();
		fop.execute();
		topicreslist();
	}
	private void setCategoryFo() throws Exception {
		ParameterInputForm pif = new ParameterInputForm();
		pif.saveString(rp, "categorycd");
		CategoryFog fog = new CategoryFog(pif,rh);
		rh.setAttribute(getName()+"#category", fog.generate());
	}

}
