package tutorial.bbs;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;


import wisdom.core.application.IRequestHandler;
import wisdomx.logic.formtemplate.AbstractFormObject;
import wisdomx.logic.formtemplate.AbstractFormObjectGenerator;
import wisdomx.logic.formtemplate.ParameterInputForm;
import wisdomx.ui.object.Option;
import wisdomx.ui.object.Select;

public class TopicFog extends AbstractFormObjectGenerator {
	public static final long serialVersionUID = 1L;
	
	public static final String SQL_SEL_TOPIC = 
		"select CATEGORYCD,NAME,MAIL,TITLE,BODY,CRTDTTM from TOPIC where TOPICID = ? ";
	/***
	 * RXgN^
	 * @param inputForm
	 * @param rh
	 * @throws Exception
	 */
	public TopicFog(ParameterInputForm inputForm, IRequestHandler rh) throws Exception {
		super(inputForm, rh);
	}

	@Override
	protected AbstractFormObject _generate() throws Exception {
		TopicFo fo = new TopicFo();
		fo.setTopicid(inputForm.getString("topicid"));
		
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_SEL_TOPIC);
		ps.setLong(1, Long.parseLong(fo.getTopicid()));
		ResultSet rs = ps.executeQuery();
		
		List<Option> l = new ArrayList<Option>();
		Option o = new Option(rp.getString("categorycd"),"");
		l.add(o);
		Select categorycd = new Select("categorycd", l);
		
		if (rs.next()) {
			categorycd.setSelected(rs.getString(1).trim());
			fo.setCategorycd(categorycd);
			fo.setName(rs.getString(2).trim());
			fo.setMail(rs.getString(3).trim());
			fo.setTitle(rs.getString(4).trim());
			fo.setBody(rs.getString(5).trim());
			fo.setCrtdttm(rs.getString(6).trim());
		}
		rs.close();
		ps.close();
		return fo;
	}
}
