package tutorial.bbs;

import java.sql.PreparedStatement;

import wisdom.core.application.IRequestHandler;
import wisdomx.logic.formtemplate.AbstractFormObject;
import wisdomx.logic.formtemplate.AbstractFormObjectPersistance;
import wisdomx.logic.formtemplate.StringChecker;
import static tutorial.bbs.DataDictionary.*;

public class TopicresFop extends AbstractFormObjectPersistance {
	public static final long serialVersionUID = 1L;
	
	public static final String SQL_INS_TOPICRES = 
		"insert into TOPICRES (select nextval('TOPICRESID'),?,?,?,?,?,current_timestamp)";
	private TopicresFo fo = null;
	
	public TopicresFop(AbstractFormObject formObject, IRequestHandler rh)
			throws Exception {
		super(formObject, rh);
		fo = (TopicresFo)formObject;
	}

	@Override
	protected void _cleanup() throws Exception {}

	@Override
	protected void _delete() throws Exception {}

	@Override
	protected void _insert() throws Exception {
		debug(fo);
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_INS_TOPICRES);
		int x = 1;
		ps.setLong(x++, Long.parseLong(fo.getTopicid()));
		ps.setString(x++, fo.getName());
		ps.setString(x++, fo.getMail());
		ps.setString(x++, fo.getTitle());
		ps.setString(x++, fo.getBody());
		ps.executeUpdate();
	}

	@Override
	protected void _prepare(AbstractFormObject form) throws Exception {}

	@Override
	protected void _update() throws Exception {}

	@Override
	protected void _validate() throws Exception {
		StringChecker sc = new StringChecker();
		int result = 0;
		result += sc.checkNotEmpty(NAME, fo.getName(),fo);
		result += sc.checkNotEmpty(MAIL, fo.getMail(),fo);
		result += sc.checkNotEmpty(TITLE, fo.getTitle(),fo);
		result += sc.checkNotEmpty(BODY, fo.getBody(),fo);
	}

}
