package tutorial.common;

import wisdom.core.application.IRequestHandler;
import wisdomx.ui.builder.IOptionsBuilder;
import wisdomx.ui.render.DefaultMessageLoader;
import wisdomx.ui.render.IMessageLoader;
import wisdomx.ui.render.IPageListDecorator;

/**
 *
 * @author  Takao Kouda
 * @version 1
 */
public class Factory implements OptionsConstants {
	
	private static IPageListDecorator pc = new ExamplePageDecorator("prev","move","next");
	
	static class SimpleMessageLoader extends DefaultMessageLoader {}
	
	private static IMessageLoader messageLoader = new SimpleMessageLoader();
	
	private Factory() { 
		super(); 
	}
	
	public static IPageListDecorator getPageDecorator() { 
		return pc;	
	}
	

	public static IOptionsBuilder getOptionsBuilder(IRequestHandler rh) throws Exception {
		return new OptionsBuilder(rh);
	}
	public static IMessageLoader getMessageLoader() {
		 return messageLoader;
	}
}	

	