package tutorial.user;

import tutorial.common.DataDictionary;
import tutorial.common.Factory;
import tutorial.common.OptionsConstants;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;
import wisdomx.logic.formtemplate.AbstractFormObject;
import wisdomx.ui.builder.IOptionsBuilder;
import wisdomx.ui.object.Checkbox;
import wisdomx.ui.object.Select;

public class UserFo extends AbstractFormObject {
	public static final long serialVersionUID = 1L;
	
	private String userid = "";
	private String username = "";
	private String password = "";
	private String mailaddress = "";

	private Select sexkbn = null;
	private Select citycd = null;
	private Checkbox hobbycd = null;
	 

	public UserFo(IRequestHandler rh) throws Exception {
		IOptionsBuilder ob = Factory.getOptionsBuilder(rh);
		sexkbn = ob.build(OptionsConstants.OC_SEXKBN, DataDictionary.SEXKBN.getId());
		citycd = ob.build(OptionsConstants.OC_CITYCD, DataDictionary.CITYCD.getId());
		hobbycd = new Checkbox(DataDictionary.HOBBYCD.getId(),
						ob.build(OptionsConstants.OC_HOBBYCD, DataDictionary.HOBBYCD.getId()).getOptions()
						);
	}

	@Override
	public void set(IRequestHandler rh, IRequestParser rp) throws Exception {
		clearMessageList();
		
		userid = rp.getString("userid");
		username = rp.getString("username");
		password = rp.getString("password");
		mailaddress = rp.getString("mailaddress");
		sexkbn.setSelected(rp.getString("sexkbn",""));
		citycd.setSelected(rp.getString("citycd"));
		hobbycd.clearChecked();
		hobbycd.setChecked(rp.getStringArray("hobbycd"));
	}

	public String getUserid() {
		return userid;
	}

	public void setUserid(String userid) {
		this.userid = userid;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getMailaddress() {
		return mailaddress;
	}

	public void setMailaddress(String mailaddress) {
		this.mailaddress = mailaddress;
	}

	public Select getSexkbn() {
		return sexkbn;
	}

	public void setSexkbn(Select sexkbn) {
		this.sexkbn = sexkbn;
	}

	public Select getCitycd() {
		return citycd;
	}

	public void setCitycd(Select citycd) {
		this.citycd = citycd;
	}

	public Checkbox getHobbycd() {
		return hobbycd;
	}

	public void setHobbycd(Checkbox hobbycd) {
		this.hobbycd = hobbycd;
	}



}
