package tutorial.user;

import java.sql.PreparedStatement;
import java.sql.ResultSet;


import wisdom.core.application.IRequestHandler;
import wisdomx.logic.formtemplate.AbstractFormObject;
import wisdomx.logic.formtemplate.AbstractFormObjectGenerator;
import wisdomx.logic.formtemplate.ParameterInputForm;

public class UserFog extends AbstractFormObjectGenerator {
	public static final long serialVersionUID = 1L;
	
	public static final String SQL_SEL_MUSER = 
		"select USERID,USERNAME,PASSWORD,MAILADDRESS,SEXKBN,CITYCD from MUSER where USERID = ? ";
	public static final String SQL_SEL_MUSERHOBBY = 
		"select HOBBYCD from MUSERHOBBY where USERID = ? ";
	/***
	 * RXgN^
	 * @param inputForm
	 * @param rh
	 * @throws Exception
	 */
	public UserFog(ParameterInputForm inputForm, IRequestHandler rh) throws Exception {
		super(inputForm, rh);
	}

	@Override
	protected AbstractFormObject _generate() throws Exception {
		UserFo fo = new UserFo(rh);
		fo.setUserid(inputForm.getString("userid"));
		fo.toUpdate();
		
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_SEL_MUSER);
		ps.setString(1, fo.getUserid());
		ResultSet rs = ps.executeQuery();
		
		if (rs.next()) {
			fo.setUserid(rs.getString(1).trim());
			fo.setUsername(rs.getString(2).trim());
			fo.setPassword(rs.getString(3).trim());
			fo.setMailaddress(rs.getString(4).trim());
			fo.getSexkbn().setSelected(rs.getString(5).trim());
			fo.getCitycd().setSelected(rs.getString(6).trim());
		}
		rs.close();
		ps.close();

		ps = rh.getConnection().prepareStatement(SQL_SEL_MUSERHOBBY);
		ps.setString(1, fo.getUserid());
		rs = ps.executeQuery();
		while (rs.next()) {
			fo.getHobbycd().setChecked(rs.getString(1).trim());
		}
		rs.close();
		ps.close();
		
		return fo;
	}
}
