package wisdom.core;

import java.util.*;
import java.io.*;
import javax.xml.parsers.*;

import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

import wisdom.core.connections.*;
import wisdom.core.util.StringUtil;

/**
 * wisdom_config.xml͂NXB<br>
 * ̃NXconfig_path.propertiesQƂAconfig.file.pathƂL[l
 * œo^ꂢl\t@CXML̃pXɎgpAXMLQƂ܂B<br>
 * XML̖O͌Œwisdom_config.xmlɂȂ܂Bit@C̎w͕svłj<br>
 * config.file.pathWEB-INFƎw肷邱ƂŎs.wart@CWEB-INFf
 * BNgɂwisdom_config.xmlQƂ܂B<br><br>
 * 
 * <i><u>̃NXConfigManagerĂяoAConfigMangerɃCX^Xێ܂B</u></i><br>
 * <i><u>AvP[Vł̃NX̃CX^Xʂɐ邱Ƃ͂܂B</u></i><br>
 * 
 * 2004/6/7 c IExceptionHandler̒ǉ
 * @author kouda
 * @version 1.1
 * @since 2003/12
 * @see ConfigManager
 */

public class ConfigHandler extends DefaultHandler {
	
	private static ConfigHandler ch = null;
	private static final String CONFIG_PATH = "config_path";
	private static final String CONFIG_FILE = "wisdom_config.xml";
	
	private ServletRuntimeConfig servletRuntimeConfig = null;
	
	private Map props = null;
	private Map datasources = null;
	private Map servletRuntimeConfigs = null;	

	private String defineName = null;	
	private String dsname = null;
	private String user = null;
	private String password = null;
	private String dbname = null;	
	private String connectionManagerName = null;
	private boolean statementClose = true;
	private boolean statementTrace = false;	
	private boolean isDefault = false;
	
	private boolean isDatasource = false;
	
	private boolean isServletRuntimeConfig = false;
	
	
	/**
	 * ̃NX̃CX^X擾܂B<br>
	 * 
	 * @return		ConfigHandler
	 */
	public static synchronized ConfigHandler getInstance() throws Exception {
		if (ch == null) ch = new ConfigHandler();
		return ch;
	}
	private ConfigHandler() throws Exception {
		super();
		props = new HashMap();
		datasources = new HashMap();
		servletRuntimeConfigs = new HashMap();	
			
		ResourceBundle rb = ResourceBundle.getBundle(CONFIG_PATH);
		SAXParserFactory factory = SAXParserFactory.newInstance();
		SAXParser parser = factory.newSAXParser();	
		InputSource is = null;
		if (rb.getString("config.file.path").equalsIgnoreCase("WEB-INF")) {
			/* WEB-INF̏ꍇWEB-INFɓǂݑւ*/
			//	ClassLoader cl = ConfigHandler.class.getClassLoader();
			String path = ClassLoader.getSystemResource("").toString();

			System.out.println(getClass().getName() + " wisdom_config = " + path);					
			path = path.substring(0, path.lastIndexOf("/"));
			path = path.substring(0, path.lastIndexOf("/")+1);
				
			path = path.substring(5, path.length());
			
			System.out.println(getClass().getName() + " wisdom_config = " + path + 	File.separator+CONFIG_FILE);		
	        is = new InputSource(new FileInputStream(
 	   	    	new File(path+CONFIG_FILE)
  	   		   	));			
		} else {
			System.out.println(getClass().getName() + " wisdom_config = " + rb.getString("config.file.path")+File.separator+CONFIG_FILE); 	   	    				
	        is = new InputSource(new FileInputStream(
 	   	    	new File(rb.getString("config.file.path")+File.separator+CONFIG_FILE)
 	   		   	));
		}
		// XML̃p[X
        parser.parse(is, this);
	}


	public void startDocument() {}

	public void startElement(String uri, String localName, String qName, Attributes att) {
		
		if (qName.trim().equals("datasource")) {
			
			isDatasource = true;
			defineName = StringUtil.cnvNull(att.getValue("id"));
			
			if( StringUtil.cnvNull(att.getValue("default")).equalsIgnoreCase("true")) {
				isDefault = true;
			}
			
			else isDefault = false;
		} else if (qName.trim().equals("servletRuntimeConfig")) {
			
			isServletRuntimeConfig = true;
			servletRuntimeConfig = new ServletRuntimeConfig(att.getValue("className"));
			servletRuntimeConfig.setEnablesSession(att.getValue("enablesSession") );
		}

		if (isDatasource) {
			String fldName = StringUtil.cnvNull(att.getValue("id"));
			
			if (fldName.equals("db.dsname")) {
				dsname = StringUtil.cnvNull(att.getValue("value"));
			} else if (fldName.equals("db.user")) {
				user = StringUtil.cnvNull(att.getValue("value"));			
			} else if (fldName.equals("db.password")) {
				password = StringUtil.cnvNull(att.getValue("value"));
			} else if (fldName.equals("db.name")) {
				dbname = StringUtil.cnvNull(att.getValue("value"));
			} else if (fldName.equals("db.ds.class")) {
				connectionManagerName = StringUtil.cnvNull(att.getValue("value"));
			} else if (fldName.equals("sql.stmt.auto.close")) {
				if( StringUtil.cnvNull(att.getValue("value")).equalsIgnoreCase("true")) {
					statementClose = true;
				} else {
					statementClose = false;
				}
			} else if (fldName.equals("sql.stmt.trace")) {
				if( StringUtil.cnvNull(att.getValue("value")).equalsIgnoreCase("true")) {
					statementTrace = true;
				} else {
					statementTrace = false;
				}
			}
						
		} else if (isServletRuntimeConfig) {
			
			if (qName.trim().equals("authenticate")) {
				
				servletRuntimeConfig.setAuthenticateRequired(StringUtil.cnvNull(att.getValue("required") ));
				servletRuntimeConfig.setAuthenticateType(StringUtil.cnvNull(att.getValue("authType") ));				
				servletRuntimeConfig.setAuthenticateClass(StringUtil.cnvNull(att.getValue("authClass") ));
				
			} else if (qName.trim().equals("allowedMethods")) {
				
				servletRuntimeConfig.setAllowGetMethod(StringUtil.cnvNull(att.getValue("get") ));
				servletRuntimeConfig.setAllowGetMethod(StringUtil.cnvNull(att.getValue("post") ));	
				
			} else if (qName.trim().equals("reqidName")) {
				
				servletRuntimeConfig.setReqidName(StringUtil.cnvNull(att.getValue("name") ));
							
			} else if (qName.trim().equals("commandFileName")) {
				
				servletRuntimeConfig.setCommandFileName(StringUtil.cnvNull(att.getValue("name") ));

			} else if (qName.trim().equals("onInitBatchCommand")) {

				servletRuntimeConfig.addOnInitBatchCommand(StringUtil.cnvNull(att.getValue("seq")),
													StringUtil.cnvNull(att.getValue("className") ));
																	
				
			} else if (qName.trim().equals("exception")) {

				servletRuntimeConfig.addErrorPage(StringUtil.cnvNull(att.getValue("className")),
													StringUtil.cnvNull(att.getValue("page") ));

			} else if (qName.trim().equals("exceptionHandler")) {

				servletRuntimeConfig.addExceptionHandler(StringUtil.cnvNull(att.getValue("className")));
		
													
			} else if (qName.trim().equals("response.header")) {

				servletRuntimeConfig.addHeader(StringUtil.cnvNull(att.getValue("name")),
													StringUtil.cnvNull(att.getValue("value") ));
																	
			} else if (qName.trim().equals("response.contentype")) {

				servletRuntimeConfig.setContentType(StringUtil.cnvNull(att.getValue("value") ));				

			} else if (qName.trim().equals("defaultReqid")) {

				servletRuntimeConfig.setDefaultReqid(StringUtil.cnvNull(att.getValue("value") ));				

			}
			
		} else if (qName.trim().equals("parameter")) {
			props.put(StringUtil.cnvNull(att.getValue("id")),StringUtil.cnvNull(att.getValue("value")));
		}
	}
	
	public void endElement(String uri, String localName, String qName) {
		
		if (qName.trim().equals("datasource")) {
			
			ConnectionDef cd = 
				new ConnectionDef(defineName,
									dsname,
									user,
									password,
									dbname,
									connectionManagerName,
									statementClose,
									statementTrace,
									isDefault);
			datasources.put(cd.getDefineName(),cd);
			isDatasource = false;

		} else if (qName.trim().equals("servletRuntimeConfig")) {
			
			servletRuntimeConfigs.put(servletRuntimeConfig.getServletName(), servletRuntimeConfig);
			
			isServletRuntimeConfig = false;
		}
	}
	public Map getProps() { return props; }
	public Map getDatasources() { return datasources; }	
	public Map getServletRuntimeConfigs () { return servletRuntimeConfigs ; }		
	public static void main(String[] args) throws Exception {
		ConfigHandler ch = new ConfigHandler();
		System.out.println(ch.datasources);		
		
	}				
}