package wisdom.core;

import java.io.*;
import java.util.*;

import wisdom.core.util.StringUtil;
import wisdom.core.util.DateUtil;

/**
 * ėpOo͂̃NX<br>
 * 
 * CX^X ConfigMagnager 擾o͐ java.io.OutputStream 擾܂B<br>
 * ConfigMagngerANZXďo͐̐ݒ肪Ȃꍇ System.out փOo͂܂B<br>
 * Õt@C͍\t@Clog.appendtrueɂȂĂꍇɂ̓Ot@C̊gq̊Ԃɓt}܂B<br>
 * t͋NɑOt}ꂽOt@C݂邩A݂ĂȂꍇ͋ÑOt@C<br>
 * Ot}t@CɕύX܂B<br>
 * O͓tĂȂ̂ŐVis̃OjƂčl܂B<br>
 *
 * @author  Takao Kouda
 * @version 1.1 2003/12
 */
public class LogImpl implements Log, Serializable {
	
	public static final long serialVersionUID = 1L;
	
	private static final String delim = "|";
	private Hashtable config = null;
	
	protected PrintWriter out = null;
	protected PrintWriter origin = null;	

//	private boolean isInitiated = false;
	
	private boolean debug   = false;
	private boolean trace   = false;
	private boolean inform  = false;
	private boolean error   = false;
	private boolean warning = false;
	
	protected LogImpl() {
		ConfigManager cm = ConfigManager.getInstance();
		config = new Hashtable();
		try {

			/* 
			 * '|'؂蕶ɃfobÕ^CvIʂ܂B
			 * 	DEBUG|TRACE|INFORM|ERROR|WARNING
			 */
			String s = cm.getString(ConfigManager.LOG_TYPE);
			StringTokenizer st = new StringTokenizer(s, delim);
			while (st.hasMoreTokens()) {
				String token = st.nextToken().toUpperCase();
				if (token.equals(Log.DEBUG))        debug   = true;
				else if (token.equals(Log.TRACE))   trace   = true;
				else if (token.equals(Log.INFORM))  inform  = true;
				else if (token.equals(Log.ERROR))   error   = true;
				else if (token.equals(Log.WARNING)) warning = true;
			}
			config.put(Log.DEBUG, 	new Boolean(debug));
			config.put(Log.TRACE, 	new Boolean(trace));
			config.put(Log.INFORM, 	new Boolean(inform));
			config.put(Log.ERROR, 	new Boolean(error));
			config.put(Log.WARNING, new Boolean(warning));
			/* 
			 * o͐t@Ĉ擾܂B
			 * t@Ĉ͎w肳ꂽt@C̊gq̊Ԃɓtǉ܂B
			 * ex)
			 *  /home/web/applog.txt
			 * 		Ǝw肳Ăꍇ
			 *  /home/web/applog_yyyy_mm_dd.txt
			 *		ƂȂ܂B
			 *
			 */
			String f_ = cm.getString(ConfigManager.LOG_FILE_NAME,"");
						
			if (StringUtil.isEmpty(f_) || (f_.toUpperCase().equals("SYSTEM.OUT"))) {
				out = new PrintWriter(System.out, true);
				origin = out;				
				config.put(ConfigManager.LOG_FILE_NAME, "System.out");
				return;
			}
			try {
				boolean append = new Boolean(cm.getString(ConfigManager.LOG_APPEND, "true")).booleanValue();
				config.put(ConfigManager.LOG_APPEND, new Boolean(append));
				
				String f = cm.getString(ConfigManager.LOG_FILE_NAME).replace(File.separator.charAt(0), '/');				
				String logName = cm.getString(ConfigManager.LOG_FILE_NAME).replace(File.separator.charAt(0), '/');
				
				if (append) {
					String ext = new String();
					int i = f.lastIndexOf(".");
					if (i != -1) {
						ext = f.substring(i);
						f = f.substring(0, i);
					}
					GregorianCalendar gc = new GregorianCalendar();
					gc.add(Calendar.DATE,-1);
					String yesterday = new StringBuffer()
						.append(DateUtil.fillDigits(4,gc.get(Calendar.YEAR),0))
						.append("_")
						.append(DateUtil.fillDigits(2,gc.get(Calendar.MONTH)+1,0))
						.append("_")
						.append(DateUtil.fillDigits(2,gc.get(Calendar.DATE),0))
						.toString();
						
					StringBuffer sb = new StringBuffer(f);
					StringBuffer sb_ = new StringBuffer(f);					
					
					sb.append("_").append(DateUtil.getStringDate("_"));
					sb_.append("_").append(yesterday);
					if (i != -1) {
						sb.append(ext);
						sb_.append(ext);						
					}
					f = logName;


					if (!new File(sb_.toString()).exists()) {
						if (new File(logName).exists()) {
							try {
								new File(logName).renameTo(new File(sb_.toString()));
							} catch (Exception e) {
								e.printStackTrace(System.out);
							}
						}
					}
				}

				int x = f.lastIndexOf("/");
				if (x != -1) {
					File file = new File(f.substring(0, x));
					if (!file.exists()) file.mkdirs();
					if (append) out = new PrintWriter(new FileOutputStream(f, true), true);
					else out = new PrintWriter(new FileOutputStream(f, false), true);

					int keepDate = cm.getInt("log.keep.date",-1);
					if (keepDate != -1 && keepDate > 0) {
						GregorianCalendar gc = new GregorianCalendar();
						gc.add(Calendar.DATE,(1 + keepDate) * -1);
						String deleteDay = new StringBuffer()
							.append(DateUtil.fillDigits(4,gc.get(Calendar.YEAR),0))
							.append("_")
							.append(DateUtil.fillDigits(2,gc.get(Calendar.MONTH)+1,0))
							.append("_")
							.append(DateUtil.fillDigits(2,gc.get(Calendar.DATE),0))
							.toString();
						
							System.out.println(getClass().getName() + " : " + deleteDay + " ÕO폜܂B");


						File parent = new File(file.getPath());
						String logFileName = f.substring(f.lastIndexOf("/")+1);
						int extPoint = logFileName.lastIndexOf('.');

						String fileNameNoExt = null;
						if (extPoint != -1) {
							fileNameNoExt = logFileName.substring(0, extPoint);
						} else {
							fileNameNoExt = logFileName;
						}
						File[] others = parent.listFiles();
						for ( int j = 0 ; j < others.length ; j++) {
							if (!others[j].isFile()) continue;
							if (others[j].getName().startsWith(fileNameNoExt) 
									&& !others[j].getName().equals(logFileName)) {
								String date = null;										
								if (others[j].getName().lastIndexOf('.') != -1) {
									date = others[j].getName().substring(fileNameNoExt.length(),others[j].getName().lastIndexOf('.'));									
								} else {
									date = others[j].getName().substring(fileNameNoExt.length());									
								}
								/* date_yyyy_mm_ddɂȂ */
								if (date.length() == 11) {
									String year = date.substring(1,5);
									String month = date.substring(6,8);
									String day = date.substring(9,11);
									try {
										GregorianCalendar gc_ = new GregorianCalendar();										
										gc_.set(Integer.parseInt(year),
													Integer.parseInt(month)-1,
														Integer.parseInt(day));
		
										if (gc_.before(gc)) {
											if (others[j].delete()) {
												System.out.println(getClass().getName() + " : " + others[j].getName() + " 폜܂" );
											} else {
												System.out.println(getClass().getName() + " : " + others[j].getName() + " ͍폜ł܂ł" );										
											}
										}
									} catch (Exception e) {}
								}
							}
						}
					}					
				}
				config.put(ConfigManager.LOG_FILE_NAME, f);				
			} catch (Exception e) {
				out = new PrintWriter(System.out, true);
				config.put(ConfigManager.LOG_FILE_NAME, "System.out");
			}
			origin = out;

		} catch (Exception e) {
			//	isInitiated = true;
		}
    }
    

	/**
	 * LogIuWFNg̍\擾܂<BR>
	 * @return 	Hashtable LogIuWFNg̍\
	 */
	public Hashtable getConfig(){ 
		return config;
	}	
	/**
	 * Oo͐擾܂<BR>
	 * @return PrintWriter Oo͐
	 */
	public PrintWriter getWriter() {
		if (out == null) return new PrintWriter(System.out, true);
			else return out;
	}
	/**
	 * Oo͐ύX܂<BR>
	 * ̕ύX͈ꎞIȏo͐łBresetWriter()sƂƂ̃IuWFNg
	 * Oo͐ɖ߂܂B
	 * @param out Oo͐
	 */
	public void setWriter(PrintWriter out) {
		this.out = out;
	}
	/**
	 * Oo͐IuWFNg̏o͐ɖ߂܂<BR>
	 */
	public void resetWriter() {
		this.out = origin;
	}
	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o			 	ĂяoObject
	 * @param b 			booleanl
	 */
	public void debug(Object o, boolean b) {
		if (debug) out.println(mkLogHeader(o, Log.DEBUG) + b);
	}

	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o			 	ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param b 			booleanl
	 */
	public void debug(Object o, String methodName, boolean b) {
		if (debug) out.println(mkLogHeader(o, Log.DEBUG, methodName) + b);
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			
	 */
	public void debug(Object o, char c) {
		if (debug) out.println(mkLogHeader(o, Log.DEBUG) + c);
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			
	 */
	public void debug(Object o, String methodName, char c) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName) + c);
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			̔z
	 */
	public void debug(Object o, char[] c) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG) + String.copyValueOf(c));
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			̔z
	 */
	public void debug(Object o, String methodName, char[] c) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName) + String.copyValueOf(c));
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param d 			{x_
	 */
	public void debug(Object o, double d) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG) + d);
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param d 			{x_
	 */
	public void debug(Object o, String methodName, double d) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName) + d);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param f 			_
	 */
	public void debug(Object o, float f) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG) + f);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param f 			_
	 */
	public void debug(Object o, String methodName, float f) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName) + f);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param i 			l
	 */	
	public void debug(Object o, int i) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG) + i);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param i 			l
	 */	
	public void debug(Object o, String methodName, int i) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName) + i);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param l 			long
	 */
	public void debug(Object o, long l) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG) + l);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param l 			long
	 */
	public void debug(Object o, String methodName, long l) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName) + l);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param o_ 			Object
	 */
	public void debug(Object o, Object o_) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG) + o_);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param o_ 			Object
	 */
	public void debug(Object o, String methodName, Object o_) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG ,methodName) + o_);
		}
	}	

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param s 			String
	 */
	public void debug(Object o, String s) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG) + s);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param s 			String
	 */
	public void debug(Object o, String methodName, String s) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName) + s);
		}
	}

	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param e 			O
	 */
	public void debug(Object o, Exception e) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG)); 
		}
	}

	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param e 			O
	 */
	public void debug(Object o, String methodName, Exception e) {
		if (debug) {
			out.println(mkLogHeader(o, Log.DEBUG, methodName)); 
		}
	}
	
	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param b 			booleanl
	 */
	public void trace(Object o, boolean b) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + b);
		}
	}

	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param b 			booleanl
	 */
	public void trace(Object o, String methodName, boolean b) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + b);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			
	 */
	public void trace(Object o, char c) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + c);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			
	 */
	public void trace(Object o, String methodName, char c) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + c);
		}
	}
		
	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			̔z
	 */
	public void trace(Object o, char[] c) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + String.copyValueOf(c));
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			̔z
	 */
	public void trace(Object o, String methodName, char[] c) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + String.copyValueOf(c));
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param d 			{x_
	 */
	public void trace(Object o, double d) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + d);
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param d 			{x_
	 */
	public void trace(Object o, String methodName, double d) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + d);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param f 			_
	 */
	public void trace(Object o, float f) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + f);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param f 			_
	 */
	public void trace(Object o, String methodName, float f) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + f);
		}
	}
		
	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param i 			l
	 */
	public void trace(Object o, int i) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + i);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param i 			l
	 */
	public void trace(Object o, String methodName, int i) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + i);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param l 			long
	 */
	public void trace(Object o, long l) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + l);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param l 			long
	 */
	public void trace(Object o, String methodName, long l) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + l);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param o_			Object
	 */
	public void trace(Object o, Object o_) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + o_);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param o_			Object
	 */
	public void trace(Object o, String methodName, Object o_) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + o_);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param s 			String
	 */
	public void trace(Object o, String s) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + s);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param s 			String
	 */
	public void trace(Object o, String methodName, String s) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + s);
		}
	}
		
	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param e 			O
	 */
	public void trace(Object o, Exception e) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE) + e.getClass().getName() + " " +e.getMessage() ); 
		}
	}

	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param e 			O
	 */
	public void trace(Object o, String methodName, Exception e) {
		if (trace) {
			out.println(mkLogHeader(o, Log.TRACE, methodName) + e.getClass().getName() + " " + e.getMessage() ); 
		}
	}
	
	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param b 			booleanl
	 */
	public void inform(Object o, boolean b) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + b);
		}
	}

	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param b 			booleanl
	 */
	public void inform(Object o, String methodName, boolean b) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + b);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			
	 */
	public void inform(Object o, char c) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + c);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			
	 */
	public void inform(Object o, String methodName, char c) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + c);
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			̔z
	 */
	public void inform(Object o, char[] c) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + String.copyValueOf(c));
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			̔z
	 */
	public void inform(Object o, String methodName, char[] c) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + String.copyValueOf(c));
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param d 			{x_
	 */
	public void inform(Object o, double d) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + d);
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param d 			{x_
	 */
	public void inform(Object o, String methodName, double d) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + d);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param f 			_
	 */
	public void inform(Object o, float f) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + f);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param f 			_
	 */
	public void inform(Object o, String methodName, float f) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + f);
		}
	}
		
	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param i 			l
	 */
	public void inform(Object o, int i) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + i);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param i 			l
	 */
	public void inform(Object o, String methodName, int i) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + i);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param l 			long
	 */
	public void inform(Object o, long l) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + l);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param l 			long
	 */
	public void inform(Object o, String methodName, long l) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + l);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param o_ 			Object
	 */
	public void inform(Object o, Object o_) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + o_);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param o_ 			Object
	 */
	public void inform(Object o, String methodName, Object o_) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + o_);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param s 			String
	 */
	public void inform(Object o, String s) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + s);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param s 			String
	 */
	public void inform(Object o, String methodName, String s) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + s);
		}
	}
		
	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param e 			O
	 */
	public void inform(Object o, Exception e) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM) + e.getClass().getName() + " " +e.getMessage()); 
		}
	}

	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param e 			O
	 */
	public void inform(Object o, String methodName, Exception e) {
		if (inform) {
			out.println(mkLogHeader(o, Log.INFORM, methodName) + e.getClass().getName() + " "+ e.getMessage()); 
		}
	}	
	
	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param b 			booleanl
	 */
	public void error(Object o, boolean b) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + b);
		}
	}

	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param b 			booleanl
	 */
	public void error(Object o, String methodName, boolean b) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + b);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			
	 */
	public void error(Object o, char c) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + c);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			
	 */
	public void error(Object o, String methodName, char c) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + c);
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			̔z
	 */
	public void error(Object o, char[] c) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + String.copyValueOf(c));
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			̔z
	 */
	public void error(Object o, String methodName, char[] c) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + String.copyValueOf(c));
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param d 			{x_
	 */
	public void error(Object o, double d) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + d);
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param d 			{x_
	 */
	public void error(Object o, String methodName, double d) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + d);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param f 			_
	 */
	public void error(Object o, float f) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + f);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param f 			_
	 */
	public void error(Object o, String methodName, float f) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + f);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param i 			l
	 */
	public void error(Object o, int i) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + i);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param i 			l
	 */
	public void error(Object o, String methodName, int i) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + i);
		}
	}
		
	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param l 			long
	 */
	public void error(Object o, long l) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + l);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param l 			long
	 */
	public void error(Object o, String methodName, long l) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + l);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param o_ 			Object
	 */
	public void error(Object o, Object o_) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + o_);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param o_ 			Object
	 */
	public void error(Object o, String methodName, Object o_) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + o_);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param s 			String
	 */
	public void error(Object o, String s) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR) + s);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param s 			String
	 */
	public void error(Object o, String methodName, String s) {
		if (error) {
			out.println(mkLogHeader(o, Log.ERROR, methodName) + s);
		}
	}

	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param e 			O
	 */
	public void error(Object o, Exception e) {
		if (error) {
			e.printStackTrace(out);			
			out.println(mkLogHeader(o, Log.ERROR)); 
		}
	}
	
	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param e 			O
	 */
	public void error(Object o, String methodName, Exception e) {
		if (error) {
			e.printStackTrace(out);
			out.println(mkLogHeader(o, Log.ERROR, methodName)); 
		}
	}
	
	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param b 			booleanl
	 */
	public void warning(Object o, boolean b) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + b);
		}
	}

	/**
	 * booleanlo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param b 			booleanl
	 */
	public void warning(Object o, String methodName, boolean b) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + b);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			
	 */
	public void warning(Object o, char c) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + c);
		}
	}

	/**
	 * o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			
	 */
	public void warning(Object o, String methodName, char c) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + c);
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param c 			̔z
	 */
	public void warning(Object o, char[] c) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + String.copyValueOf(c));
		}
	}

	/**
	 * ̔zo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param c 			̔z
	 */
	public void warning(Object o, String methodName, char[] c) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + String.copyValueOf(c));
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param d 			{x_
	 */
	public void warning(Object o, double d) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + d);
		}
	}

	/**
	 * {x_o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param d 			{x_
	 */
	public void warning(Object o, String methodName, double d) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + d);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param f 			_
	 */
	public void warning(Object o, float f) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + f);
		}
	}

	/**
	 * _o͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param f 			_
	 */
	public void warning(Object o, String methodName, float f) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + f);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param i 			l
	 */
	public void warning(Object o, int i) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + i);
		}
	}

	/**
	 * lo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param i 			l
	 */
	public void warning(Object o, String methodName, int i) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + i);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param l 			long
	 */
	public void warning(Object o, long l) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + l);
		}
	}

	/**
	 * longo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param l 			long
	 */
	public void warning(Object o, String methodName, long l) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + l);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param o_ 			Object
	 */
	public void warning(Object o, Object o_) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + o_);
		}
	}

	/**
	 * Objecto͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param o_ 			Object
	 */
	public void warning(Object o, String methodName, Object o_) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + o_);
		}
	}
	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param s 			String
	 */
	public void warning(Object o, String s) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + s);
		}
	}

	/**
	 * Stringo͂āAsI܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param s 			String
	 */
	public void warning(Object o, String methodName, String s) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + s);
		}
	}

	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param e 			O
	 */
	public void warning(Object o, Exception e) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING) + e.getClass().getName() + " "+ e.getMessage()); 
		}
	}

	/**
	 * Oo͂܂B<BR>
	 * @param o 			ĂяoObject
	 * @param methodName 	Ăяõ\bh	 
	 * @param e 			O
	 */
	public void warning(Object o, String methodName,  Exception e) {
		if (warning) {
			out.println(mkLogHeader(o, Log.WARNING, methodName) + e.getClass().getName() + " "+ e.getMessage()); 
		}
	}

	/**
	 * Ǒo쐬܂B<BR>
	 * @param o 			ĂяoObject
	 * @param t 			O^Cg
	 */
	public static String mkLogHeader(Object o, String t) {
		StringBuffer sb = new StringBuffer();
		Calendar cal = Calendar.getInstance();
		String mills =  "";
		if (cal.get(Calendar.MILLISECOND) > 100) {
			mills = Integer.toString(cal.get(Calendar.MILLISECOND)).substring(0,2);	
		} else {
			mills = Integer.toString(cal.get(Calendar.MILLISECOND));
		}
		sb.append(DateUtil.getStringDate("/")).append(" ").append(DateUtil.getStringTime(":"))
			.append(".").append(mills)
			.append(" [").append(t).append("] ").append(getClassName(o)).append(": ");
		return sb.toString();
	}
	/**
	 * Ǒo쐬܂B<BR>
	 * @param o 			ĂяoObject
	 * @param t 			O^Cg
	 * @param methodName 	Ăяõ\bh	 * 
	 */
	public static String mkLogHeader(Object o, String t, String methodName) {
		StringBuffer sb = new StringBuffer();
		Calendar cal = Calendar.getInstance();
		String mills =  "";
		if (cal.get(Calendar.MILLISECOND) > 100) {
			mills = Integer.toString(cal.get(Calendar.MILLISECOND)).substring(0,2);	
		} else {
			mills = Integer.toString(cal.get(Calendar.MILLISECOND));
		}
		sb.append(DateUtil.getStringDate("/")).append(" ").append(DateUtil.getStringTime(":"))
			.append(".").append(mills)
			.append(" [").append(t).append("] ").append(getClassName(o)).append(": ");
		sb.append(methodName).append(" > ");
		return sb.toString();
	}	
	/**
	 * NX擾܂B
	 * s̃NX̃pbP[WCNXP̖̂̂擾܂B
	 * @return String NX
	 */
	private static String getClassName(Object o) {
		String cn = o.getClass().getName();
		int x = cn.lastIndexOf('.');
		if (x == -1) return cn;
		return cn.substring(x+1, cn.length());
	}	
	
//	private String mkLogHeader(Object o) { return mkLogHeader(o, ""); }
}
