package wisdom.core;


import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import java.util.MissingResourceException;

/**
 * .propertiest@C烁bZ[W𐶐܂B<br>
 * ̃NX͓{ŋLq.propertiest@C̓ǂݎ\ɂ܂B
 * gp.propertiest@Cɂ͈ȉ̃GgKǉĂB<br><br>
 * PropertyEncoding=SJIS<br><br>
 * ܂A͕ɂAꕔ\Ȃꍇ܂ȀꍇA\Ȃ̑O<br>
 * GXP[vEV[PXi\j}ĂB<br>
 *
 * @author  Takao Kouda 
 * @version 1
 *
 */
public class RBMessageGenerator implements MessageGenerator {

	private ResourceBundle rb = null;
	private String enc = null;
	private String fatal = null;
	
	private static final String ENC = "PropertyEncoding";
	private boolean error = false;
	
	/** 
	 * RXgN^i͎gpsj
	 */ 
	private RBMessageGenerator() {}


	/**
	 * RXgN^
	 * @param  propName gp郁bZ[W܂.properties̖OB
	 */	
	public RBMessageGenerator(String propName) {
		this();
		
		if (propName == null) {
			error = true;
			fatal = "\[Xw肳Ă܂B";
		} else {
			try {
				rb = ResourceBundle.getBundle(propName);
			} catch (MissingResourceException mre) {
				error = true;
				fatal = "w肳ꂽ\[X܂ B(" + propName + ")";
			}
			if (!error) {
				try {
					enc = rb.getString(ENC);
				} catch (MissingResourceException mre) {
					error = true;
					fatal = "\[XɃGR[fBO̎w(PropertyEncoding='encoding')܂B";				
				} 		
			}		
		}
	}

	/**
	 * bZ[W̎擾
	 * @param  code 擾郁bZ[W̃R[hB
	 * @return ҏWꂽB
	 */	
	public Message getMessage(String code) {
		return mkMessage(code,new String[]{""});		
	}

	/**
	 * bZ[W̎擾
	 * @param  code 擾郁bZ[W̃R[hB
	 * @param  msg1 bZ[WɊ܂ޕB
	 * @return ҏWꂽB 
	 */	
	public Message getMessage(String code, String msg1) {
		return mkMessage(code, new String[]{msg1});		
	}

	/**
	 * bZ[W̎擾
	 * @param  code 擾郁bZ[W̃R[hB
	 * @param  msg1 bZ[WɊ܂ޕB
	 * @param  msg2 bZ[WɊ܂ޕB 
	 * @return ҏWꂽB 
	 */	
	public Message getMessage(String code, String msg1, String msg2) {
		return mkMessage(code, new String[]{msg1,msg2});
	}
		
	/**
	 * bZ[W̎擾
	 * @param  code 擾郁bZ[W̃R[hB
	 * @param  msgs bZ[WɊ܂ޕ̔zB
	 * @return ҏWꂽB 
	 */	
	public Message getMessage(String code, String[] msgs) {
		return mkMessage(code,msgs);
	}

	/**
	 * .propertiest@Cw肳ꂽR[h̃bZ[W擾܂B
	 * 
	 * @param	code	R[h
	 * @return			w肳ꂽR[h̃bZ[W
	 */
	protected Message mkMessage(String code, String[] msgs) {
		String source = null;
		Message msg = new Message(code);
		msg.setField("");
		if (error)  {
			msg.setText(fatal);
			return msg;
		}
		try {
			source = new String(rb.getString(code.trim()).getBytes("ISO-8859-1") , enc);
		} catch (UnsupportedEncodingException uee) {
			source =  "w肳ꂽGR[fBO̓T|[g܂B(PropertyEncoding="+enc+")";
		} catch (MissingResourceException mre) {
			source =  "o^ĂȂR[hgp܂ B(" + code + ")";
		}
		msg.setText(MessageHelper.embed(source,msgs));
		return msg;
	}
}