package wisdom.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import wisdom.core.runtime.RunTimeServlet;
import wisdom.core.application.IAuthenticate;
import wisdom.core.application.IUserSession;
import wisdom.core.application.IBatchCommand;
/**
 * {@link RunTimeServlet }̎s\ێ܂B<br>
 * ̃NX{@link ConfigManager }ɂAAvP[VNɃCX^XA{@link RunTimeServlet }
 * Ɏs\ƂĕێAgp܂B<br>
 * 
 * 2004/6/7 IExceptionHandler̒ǉ
 * 2008/5/16 defaultReqid̒ǉ
 * @author  Takao Kouda
 * @version 1
 * 
 *
 */
public class ServletRuntimeConfig  {
	public static final int AUTH_TYPE_BASIC = 1;
	public static final int AUTH_TYPE_FORM = 2;
	
	private String servletName	 = null;

	
	private boolean authenticateRequired = false;
	private int	 authenticateType = -1;
	private String	authenticateClass = null;
	
	private String	reqidName = null;	
	
	private boolean allowGetMethod = true;
	private boolean allowPostMethod = true;

	private String commandFileName = null;
	private boolean enablesSession = true;
	
	private Map exceptions = null;
	
	private Map headers = null;
	private String contentType = null;
	
	private Map onInitBatchCommands = null;
	private List exceptionHandlers = null;
	private String defaultReqid = "";
	/**
	 * RXgN^
	 * @param serlvetName ServletRuntimeConfigƊ֘AÂT[ubg̃NXB
	 */
	protected ServletRuntimeConfig(String serlvetName) {
		super();
		this.servletName = serlvetName;
		this.exceptions = new HashMap();
		this.headers = new HashMap();		
		this.onInitBatchCommands = new HashMap();
		this.exceptionHandlers = new Vector();		
	}
	/**
	 * F؂vۂݒ肵܂B<br>
	 * ȗfalsełBF؂KvȏꍇA"true"w肵܂B
	 * 
	 * @param authenticateRequired 
	 */
	protected void setAuthenticateRequired(String authenticateRequired)  {
		if (authenticateRequired.trim().equalsIgnoreCase("true")) 		
		this.authenticateRequired = true;
	}
	
	/**
	 * F؂sꍇ̃^Cvݒ肵܂B<br>
	 * ȗ {@link #AUTH_TYPE_FORM } łBHTTP BASICF؂sꍇA"basic"w肵܂B
	 * 
	 * @param authenticateType
	 * 
	 */
	protected void setAuthenticateType(String authenticateType) {
		if (authenticateType.trim().equalsIgnoreCase("basic")) 	this.authenticateType = AUTH_TYPE_BASIC;
		else if (authenticateType.trim().equalsIgnoreCase("form"))  this.authenticateType = AUTH_TYPE_FORM;		
	}
	
	/**
	 * F؂sꍇ̔F؃NXݒ肵܂B<br>
	 * F؂sNX{@link IAuthenticate }C^[tF[XNXłKv܂B
	 * pbP[W܂񂾃NXw肵ĂB
	 * 
	 * @param authClass 
	 */
	protected void setAuthenticateClass(String authClass) {
		this.authenticateClass = authClass;
	}
	
	/**
	 * p[^"reqid"̏㏑ݒ肵܂B<br>
	 * 
	 * @param reqidName
	 */
	protected void setReqidName(String reqidName) {
		this.reqidName = reqidName;
	}
	/**
	 * HTTP GET\bh̎gpۂݒ肵܂B<br>
	 * ȗ͉łBgpsɂꍇA"false"w肵܂B
	 * 
	 * @param value 
	 */
	protected void setAllowGetMethod(String value) {
		if (value.trim().equalsIgnoreCase("false")) allowGetMethod = false;
	}
	
	/**
	 * HTTP POST\bh̎gpۂݒ肵܂B<br>
	 * ȗ͉łBgpsɂꍇA"false"w肵܂B
	 * 
	 * @param value 
	 */	
	protected void setAllowPostMethod(String value) {
		if (value.trim().equalsIgnoreCase("false")) allowPostMethod = false;
	}	
	
	/**
	 * ZbV̎gpۂݒ肵܂B<br>
	 * ZbV񂪎gpŁAFؕsvɂȂĂꍇA쐬ZbV
	 * {@link IUserSession#isAuthenticated() }F؂Ƃč쐬܂<br>
	 * ȗ͉łBgpsɂꍇA"false"w肵܂B
	 * 
	 * @param value 
	 */
	protected void setEnablesSession(String value) {
		if (value.trim().equalsIgnoreCase("false")) enablesSession = false;
	}	

	/**
	 * gpR}ht@Cw肵܂B<br>
	 * R}h/WEB-INF/ȉ猟܂B/WEB-INF/܂ޕKv͂܂B
	 * 
	 * @param commandFileName gpR}ht@C
	 */
	protected void setCommandFileName(String commandFileName) {
		this.commandFileName = commandFileName;
	}

	/**
	 * OƂfowardJSPݒ肵܂B<br>
	 * ΉONXJSPݒ肵܂B
	 * @param exceptionClassName pbP[W܂ޗONX
	 * @param forwardPage forwardJSP
	 */
	protected void addErrorPage(String exceptionClassName, String forwardPage) {
		exceptions.put(exceptionClassName,forwardPage);
	}
	
	/**
	 * foward钼Oɏ㏑HTMLwb_[ݒ肵܂B<br>
	 * wb_[̖OAlw肵܂B<br>
	 * 
	 * @param keyName wb_[̖O
	 * @param value wb_[̒l
	 */	
	protected void addHeader(String keyName, String value) {
		headers.put(keyName,value);
	}

	/**
	 * fowardJSP̃Reg^Cvw肵܂B<br>
	 * 
	 * @param contentType Reg^Cv
	 */
	protected void setContentType(String contentType) {
		this.contentType = contentType;
	}
	
	/**
	 * [hɎs{@link IBatchCommand}o^܂B<br>
	 * sANXw肵܂B
	 * @param  seq s
	 * @param className {@link IBatchCommand}NX̃pbP[W܂񂾃NX
	 */
	protected void addOnInitBatchCommand(String seq, String className) {
		onInitBatchCommands.put(seq,className);
	}

	/**
	 * OɎs{@link wisdom.core.application.IExceptionHandler}o^܂B<br>
	 * NXw肵܂B
	 * @since 2004/6/7
	 * @param className {@link wisdom.core.application.IExceptionHandler}NX̃pbP[W܂񂾃NX
	 */
	protected void addExceptionHandler(String className) {
		if (! exceptionHandlers.contains(className)) {
			exceptionHandlers.add(className);
		}
	}	
	/**
	 * ReqidȗɎsReqidݒ肵܂B
	 * @param defaultCmdName
	 */
	protected void setDefaultReqid(String defaultReqid) {	
		this.defaultReqid = defaultReqid;
	}
	/**
	 * ΉRuntimeServlet擾܂B<br>
	 * @return ΉRuntimeServlet̖O
	 */
	public String getServletName() { return servletName; }
	
	/**
	 * gpR}ht@C擾܂B<br>
	 * @return gpR}ht@C
	 */
	public String getCommandFileName() {return commandFileName;}
	
	/**
	 * HTTP GET\bhĂ邩܂B<br>
	 * @return Ăꍇtrue
	 */
	public boolean isAllowGetMethod() { return allowGetMethod; }

	/**
	 * HTTP POST\bhĂ邩܂B<br>
	 * @return Ăꍇtrue
	 */
	public boolean isAllowPostMethod() { return allowPostMethod; }	
	
	/**
	 * ZbV񂪎gpɂȂĂ邩܂B<br>
	 * @return gpɂȂĂꍇtrue
	 */	
	public boolean isEnablesSession() { return enablesSession; }
	
	/**
	 * [hɎs{@link IBatchCommand}擾܂<br>
	 * @return [hɎs{@link IBatchCommand}
	 */
	public Map getOnInitBatchCommands() {
		return onInitBatchCommands;
	}	
	/**
	 * forwardJSPONX擾܂B<br>
	 * @return ONX
	 */
	public String getErrorPage(String exceptionClassName) {
		return (String)exceptions.get(exceptionClassName);
	}
	/**
	 * OsNX̔z擾܂B<br>
	 * 
	 * @since 2004/6/7
	 * @return ONX
	 */
	public List getExceptionHandler() {
		return exceptionHandlers;
	}	
	/**
	 * ㏑HTMLwb_[܂Map擾܂B<br>
	 * @return ㏑HTMLwb_[܂Map
	 */
	public Map getHeaders() {
		return headers;
	}

	/**
	 * gpF؃^Cv擾܂B<br>
	 * @return gpF؃^Cv
	 */
	public int getAuthenticateType() {
		if (authenticateType == AUTH_TYPE_BASIC) return AUTH_TYPE_BASIC;
		return AUTH_TYPE_FORM;
	}
	
	/**
	 * F؂Kvۂ܂B<br>
	 * @return F؂Kvȏꍇtrue
	 */
	public boolean isAuthenticateRequired() {  return authenticateRequired; }
	
	/**
	 * F؂ɎgpNX擾܂B<br>
	 * @return F؂ɎgpNX
	 */
	public String getAuthenticateClass() { return authenticateClass; }

	/**
	 * p[^reqid̏㏑擾܂B<br>
	 * @return p[^reqid̏㏑
	 */
	public String getReqidName() { return reqidName; }	
	/**
	 * forwardJSP̃Reg^Cv擾܂B<br>
	 * @return forwardJSP̃Reg^Cv
	 */
	public String getContentType() { return contentType;}	
	
	/**
	 * ReqidȗɎsReqid擾܂B
	 * @return defaultCmdName
	 */
	public String getDefaultReqid() {	return defaultReqid;}
	
	public String asString() {
		StringBuffer sb = new StringBuffer();
		sb.append(getClass().getName())
		.append("\n")
		.append("\tenablesSession=").append(enablesSession).append("\n")		
		.append("\tauthenticateRequired=").append(authenticateRequired).append(" ")
		.append("authenticateType=").append(authenticateType).append(" ")
		.append("authenticateClass=").append(authenticateClass).append("\n")
		.append("\treqidName=").append(reqidName).append("\n")		
		.append("\tallowGetMethod=").append(allowGetMethod).append(" ")
		.append("allowPostMethod=").append(allowPostMethod).append("\n")
		.append("\tcommandFileName=").append(commandFileName).append(" ");	
			
		for (Iterator keys = onInitBatchCommands.keySet().iterator(); keys != null && keys.hasNext() ; ) {
			String className = (String)keys.next();
			String page = (String)onInitBatchCommands.get(className);
			sb
			.append("\n\tonInitBatchCommand").append(" ")			
			.append("seq=").append(className).append(" ")
			.append("className=").append(page).append(" ");
		}		

		for (Iterator keys = exceptionHandlers.iterator(); keys != null && keys.hasNext() ; ) {
			String className = (String)keys.next();
			sb
			.append("\n\texceptionHandler").append(" ")			
			.append("className=").append(className).append(" ");
		}
		
		for (Iterator keys = exceptions.keySet().iterator(); keys != null && keys.hasNext() ; ) {
			String className = (String)keys.next();
			String page = (String)exceptions.get(className);
			sb
			.append("\n\texception").append(" ")			
			.append("className=").append(className).append(" ")
			.append("page=").append(page).append(" ");
		}
		for (Iterator keys = headers.keySet().iterator(); keys != null && keys.hasNext() ; ) {
			String className = (String)keys.next();
			String page = (String)headers.get(className);
			sb
			.append("\n\theader").append(" ")			
			.append("key=").append(className).append(" ")
			.append("value=").append(page).append(" ");
		}		
		sb.append("\n\tcontentype=").append(contentType).append(" ");				
		sb.append("\n\tdefaultReqid=").append(defaultReqid).append(" ");
		return sb.toString();
	}

}
