package wisdom.core.application;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import wisdom.core.session.MissingSessionObjectException;
import wisdom.core.runtime.RunTimeServlet;
import wisdom.core.ServletRuntimeConfig;
/**
 * RequestCommandŎgpłAvP[V̎擾`C^[tF[X<br>
 * f[^\[Xւ̐ڑAgUNVǗAZbVւ̃ANZX邽߂̃C^[tF[XłB
 * ̃C^[tF[X̃CX^X͎s {@link RunTimeServlet }ɂĐ܂B<br>
 * ZbV {@link ServletRuntimeConfig#isEnablesSession() }truêƂɎgp\ɂȂ܂BfalsêƂ
 * ZbVփANZXꍇAOo܂B
 * 
 * 2004/6/9 ̃C^[tF[X\bh{@link wisdom.core.application.IHandler}ɂȂ邽߂ɁAꕔ̃\bh̒`
 * 폜܂B
 *   
 * @author Takao Kouda
 * @version 1
 * @see ServletRuntimeConfig
 *
 */
public interface IRequestHandler extends IHandler  {

	/** 
	 * gpĂHttpServletRequest̃CX^X擾܂B
	 * @return HttpServletRequest̃CX^X
	 */
	public HttpServletRequest getRequest() ;

	/** 
	 * gpĂHttpServletResonsẽCX^X擾܂B
	 * @return HttpServletResponsẽCX^X
	 */
	public HttpServletResponse getResponse() ;
	
	/** 
	 * gpĂIRequestParserC^[tF[X̎IuWFNg擾܂B
	 * @return IRequestParser
	 */
	public IRequestParser getRequestParser() ;

	/** 
	 * gpĂServletConfig ̃CX^X擾܂B
	 * @return ServletConfig̃CX^X
	 */
	public ServletConfig getServletConfig() ;

	/** 
	 * ̃IuWFNgɊ܂܂ ServletContext ̃CX^XԂ܂B
	 * @return ServletContext ServletContext̃CX^X
	 */
	public ServletContext getServletContext() ;
	
	/**
	 * s{@link IRequestCommand }reqid擾܂B<br>
	 * 
	 * @return rqid
	 */
	public String getReqId() ;	

	/**
	 * IUserSessionIuWFNg擾܂B<br>
	 * @return IUserSessioñCX^X
	 */
	public IUserSession getUserSession() ;
	/**
	 * UserSession#setAttribute(key,object)s܂<br>
	 * @param key	ݒ肷L[
	 * @param object ݒ肷IuWFNg
	 */
	public void setSessionAttribute(String key, Object object) ;
	
	/**
	 * UserSession#removeAttribute(key,object)s܂<br>
	 * @param key	OL[
	 */
	public void removeSessionAttribute(String key) ;
		
	/**
	 * UserSession#getAttribute(key)s܂<br>
	 * @param key	ݒ肷L[
	 * @exception MissingSessionObjectException w肳ꂽL[̃IuWFNgZbVɂȂꍇɑo܂B
	 */
	public Object getSessionAttribute(String key) throws MissingSessionObjectException ;
	
	/**
	 * UserSession#getAttribute(key,boolean)s܂<br>
	 * @param key	ݒ肷L[
	 * @param allowNull truȅꍇAZbVɂȂƂOoł͂Ȃnull߂܂
	 * 
	 * @exception MissingSessionObjectException w肳ꂽL[̃IuWFNgZbVɂȂꍇɑo܂B
	 */
	public Object getSessionAttribute(String key, boolean allowNull) throws MissingSessionObjectException;

	/**
	 * OsƂĐݒ肳ĂȂZbV̒lׂăNA܂<br>
	 */
	public void cleanupRemovableSessionAttributes();
	
	/**
	 * ZbVOsƂĐݒ肵܂<br>
	 * œo^ꂽL[lcleanupRemovableSessionAttributes()sĂ
	 * ZbV񂩂珜܂<br>
	 * @param key OsƂĐݒ肷ZbṼL[l
	 */
	public void addUnremovableSessionAttributeName(String key) ;
	
	/**
	 * ZbVOsƂĐݒ肵܂<br>
	 * œo^ꂽL[lcleanupRemovableSessionAttributes()sĂ
	 * ZbV񂩂珜܂<br>
	 *
	 * @param keys OsƂĐݒ肷ZbṼL[l̔z
	 */
	public void addUnremovableSessionAttributeNames(String[] keys) ;
	
	/**
	 * OsΏۂƂĐݒ肳ꂽZbṼL[lO܂<br>
	 * @param key OΏۂ菜ZbṼL[l
	 */
	public void removeUnremovableSessionAttributeName(String key); 
	
	
	/**
	 * OsƂĐݒ肳ꂽZbṼL[lStringz擾܂<br>
	 * @return OsƂĐݒ肳ꂽZbṼL[lStringz
 	 */
	public List getUnremovableSessionAttributeNames() ;

	/**
	 * ̃IuWFNggpĂRequestCommand̃CX^X擾܂<br>
	 * @return RequestCommand̃CX^X
	 */
	public IRequestCommand getInvoker() ;
	
	

}