package wisdom.core.application;

import java.util.List;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import wisdom.core.command.*;
import wisdom.core.request.AttributeNotFoundException;
import wisdom.core.request.ParameterNotFoundException;
import wisdom.core.request.Part;

/**
 * javax.servlet.http.ServletRequest p[XėpNXEC^[tF[XB<br>
 * 
 * 2005/5/24 WA0037̒ǉ
 * @author  Takao Kouda
 * @version 0.90, 1/1/2001
 */
public interface IRequestParser {

	/**
	 *  String^̃p[^擾܂<br>
	 *  ߂lString#trim()s܂B
	 * 
	 *  @param name 擾p[^
	 *  @return  String^Ŏ擾ꂽl
	 *  @exception ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public String getString(String name) throws ParameterNotFoundException;

	/**
	 *  String^̃p[^擾܂<br>
	 *  lȂꍇAdef̒l߂AlꍇA߂lString#trim()s܂B
	 *
	 *  @param name 擾p[^
	 *  @param def 擾łȂꍇ̏ȗl
	 *  @return String^Ŏ擾ꂽl
	 */
	public String getString(String name, String def);

	/**
	 *  String^̃p[^擾܂<br>
	 * 
	 *  @param name 擾p[^
	 *  @return String^Ŏ擾ꂽl
	 *  @exception@ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public String getStringNoTrim(String name)
		throws ParameterNotFoundException;

	/**
	 *  String^̃p[^擾<BR>
	 *  l󂯎Ȃꍇ͏ȗl̐ݒ肪\B<br>
	 *  擾łp[^l͍E̋󔒂͍폜܂B<br>
	 * 
	 *  @param 		name 擾p[^
	 *  @param 		def  擾łȂꍇ̏ȗl
	 *  @return 		 String^Ŏ擾ꂽl
	 */
	public String getStringNoTrim(String name, String def);

	/**
	 *  int^̃p[^擾<BR>
	 *
	 *  @param 		name 擾p[^
	 *  @return 		 int^Ŏ擾ꂽl
	 *  @exception 		 ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public int getInt(String name)
		throws ParameterNotFoundException, NumberFormatException;

	/**
	 *  int^̃p[^擾<BR>
	 *  l󂯎Ȃꍇ͏ȗl̐ݒ肪\B
	 *
	 *  @param 		name 擾p[^
	 *  @param 		def  擾łȂꍇ̏ȗl
	 *  @return 		 int^Ŏ擾ꂽl
	 */
	public int getInt(String name, int def);

	/**
	 *  double^̃p[^擾<BR>
	 *
	 *  @param 		name 擾p[^
	 *  @return 		 doubleg^Ŏ擾ꂽl
	 *  @exception 		 ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public double getDouble(String name)
		throws ParameterNotFoundException, NumberFormatException;

	/**
	 *  double^̃p[^擾<BR>
	 *  l󂯎Ȃꍇ͏ȗl̐ݒ肪\B
	 *
	 *  @param 		name 擾p[^
	 *  @param 		def	 double 擾łȂꍇ̏ȗl
	 *  @return 		 double^Ŏ擾ꂽl
	 */
	public double getDouble(String name, double def);

	/**
	 *  String^z̃p[^擾<BR>
	 *  ̃\bh͖߂lnull̏ꍇA0StringIuWFNg܂񂾔z߂܂B
	 *  @param 		name 擾p[^
	 *  @return 		 String̔z^Ŏ擾ꂽl
	 *  @exception 		 ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public String[] getStringArray(String name) throws ParameterNotFoundException;

	/**
	 *  String^z̃p[^擾<BR>
	 *  ̃\bh͖߂lnull̏ꍇAnullIuWFNg߂܂B<br>
	 *  @since 2005/5/24 WA0037̒ǉ
	 *  @param 		name 擾p[^
	 *  @return 		 String̔z^Ŏ擾ꂽl
	 *  @exception 		 ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public String[] getStringArrayWithNull(String name) ;
	
	/**
	 *  Part̃p[^擾<BR>
	 *
	 *  @param 		name 擾p[^
	 *  @return 		 Part^Ŏ擾ꂽl
	 *  @exception 		 ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public Part getPart(String name) throws ParameterNotFoundException;

	/**
	 *  Part̃p[^擾<BR>
	 *
	 *  @param 		name 擾p[^
	 *  @return 		 Part^̔ziLiistjŎ擾ꂽl
	 *  @exception 		ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	public List getPartArray(String name) throws ParameterNotFoundException;

	/**
	 * HttpServletRequest̃CX^X擾܂B
	 * @return HttpServletRequest HttpServletRequest
	 */
	public HttpServletRequest getRequest();

	/**
	 * ContextPath擾܂B
	 * @return		String		ContextPath
	 */
	public String getContextPath();

	/**
	 * ĂHttpServletRequestɐݒ肳ꂽ擾܂B
	 * @param		key			擾L[
	 * @return 		Object HttpServletRequest
	 * @exception	AttributeNotFoundException w肳ꂽnull̏ꍇ
	 */
	public Object getAttribute(String key) throws AttributeNotFoundException;

	/**
	 * ĂHttpServletRequestɐݒ肳ꂽwb_[擾܂B
	 * @param		key			wb_[擾L[
	 * @return 		String HttpServletRequest
	 * @exception	AttributeNotFoundException w肳ꂽnull̏ꍇ
	 */
	public String getHeader(String key) throws AttributeNotFoundException;

	/**
	 * ĂHttpServletRequestɐݒ肳ꂽ擾܂B
	 * @param		key			擾L[
	 * @param		allowNull	truȅꍇ͖߂lnull܂B 
	 * @return 		Object HttpServletRequest
	 * @exception	AttributeNotFoundException w肳ꂽnull̏ꍇ
	 */
	public Object getAttribute(String key, boolean allowNull)
		throws AttributeNotFoundException;

	/**
	 * ĂHttpServletRequestɐݒ肳ꂽwb_[擾܂B
	 * @param		key			wb_[擾L[
	 * @param		allowNull	truȅꍇ͖߂lnull܂B 
	 * @return 	String HttpServletRequest
	 * @exception	AttributeNotFoundException w肳ꂽnull̏ꍇ
	 */
	public String getHeader(String key, boolean allowNull)
		throws AttributeNotFoundException;
	/**
	 *  HttpServletRequest̓e𕶎ŕԂ܂B
	 *  @return String HttpServletRequest̓e
	 */
	public String parse();

	/**
	 *  HttpServletRequest̓e𕶎ŕԂ܂B
	 *  @param type ParameterParser.PARAMETER HttpServletRequestɊ܂܂p[^B<br>
	 *			   ParameterParser.ATTRIBUTE HttpServletRequestɊ܂܂鑮B<br>
	 * 									iHttpServletRequest.setAttibute(String key, Object value)Őݒ肳ꂽlj<br>
	 *			   ParameterParser.HEADER HttpServletRequestɊ܂܂wb_[B
	 *  @return String HttpServletRequest̓e
	 */
	public String parse(int type);

	/**
	 *  HttpServletRequest̃p[^̈ꗗԂ܂B
	 *  @return Iterator p[^̈ꗗ
	 */
	public Iterator getParameterNames();

	/**
	 * RequestParsersR}hNX擾܂B
	 */
	public RequestCommand getCommand();

	/**
	 * RequestParsersR}hNX擾܂B
	 */
	public String getCommandName();

	/**
	 * reqid擾܂
	 */
	public String getReqId();

	/** sR}hNXHttpServletRequest̑ɐݒ肷L[l */
	public static final String COMMAND = "COMMAND";

	/** ResquestParser  HttpServletResponse ̑ɐݒ肷邷L[l */
	public static final String ATTRIBUTE_NAME = IRequestParser.class.getName();

	/**  p[Xo͂ɎgpL[B*/
	public static final int PARAMETER = 100;

	/**  p[Xo͂ɎgpL[B*/
	public static final int ATTRIBUTE = 200;

	/**  p[Xo͂ɎgpL[B*/
	public static final int HEADER = 300;

	/**  F؃^Cv */
	public static final int BASIC = 0;

}
