package wisdom.core.command;

import java.util.Map;
import java.io.InputStream;
import java.io.File;
import java.net.URL;

import javax.servlet.ServletContext;

import org.xml.sax.InputSource;

import wisdom.core.ConfigManager;
import wisdom.core.CoreMessageGenerator;
import wisdom.core.Log;
import wisdom.core.LogFactory;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

/**
 *
 * @author  Takao Kouda
 * @version 1
 */

public class CommandSet extends CommandHandler {
	private ServletContext context = null;
	private String commandFileName = null;
	private Map command = null;
	
	/**
	 * RXgN^ ̃ftHg͎gps
	 */
	public CommandSet(ServletContext context, String commandFileName) throws Exception { 
		super(); 
		this.context = context;
		this.commandFileName = commandFileName;
		init();
	}

	/**
	 * ̕񂩂ΉR}hENX̂擾B<BR>
	 *
	 * @param reqid reqid
	 * @return String R}h́iNXj
	 * @exception MissConfiguredException w肳ꂽŃR}hݒ肳ĂȂꍇɑoB
	 */	
	public String getCommandName(String reqid) throws MissConfiguredException {
		String cmd = (String)command.get(reqid);
		if (cmd == null) CoreMessageGenerator.getInstance().getMessage("WCE0020", reqid);			
		return cmd;
	}
	
	/**
	 * B\bhłB
	 * XMLp[T[̎擾AR}h\[X̃p[Xs܂B
	 */
	private void init() throws Exception {
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser parser = factory.newSAXParser();			
			CommandHandler handler =  new CommandHandler();

			InputStream input = null;
        			
			l.inform(this, "init", "Used command resource is: " 
				+ context.getRealPath("/WEB-INF") + File.separator + commandFileName);
			
            URL url = context.getResource("/WEB-INF" + File.separator + commandFileName);
            InputSource is = new InputSource(url.toExternalForm());
            input = context.getResourceAsStream("/WEB-INF" + File.separator + commandFileName);

            is.setByteStream(input);

            parser.parse(is, handler);
			
			command = handler.getParsedData();
			l.inform(this, "init", "Used command resource is ready");
		} catch (Exception e) {
			l.error(this,"init",e);
			throw(e);
		}
	}

	// VXeEvpeB "javax.xml.parsers.SAXParserFactory"̒lŎ擾܂B
	private static final String parserClass = "org.apache.xerces.jaxp.SAXPaserFactoryImpl";
	private Log l = LogFactory.create();
	private ConfigManager cm = ConfigManager.getInstance();

}
