package wisdom.core.command;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import wisdom.core.CoreObject;
import wisdom.core.MessageGenerator;
import wisdom.core.application.AppMessageGenerator;
import wisdom.core.application.IHandler;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;
import wisdom.core.application.IResponseDownLoader;
import wisdom.core.request.*;
import wisdom.core.runtime.*;

import wisdom.core.application.IRequestCommand;
import wisdom.core.runtime.RunTimeServlet;
/**
 * {@link IRequestCommand}̎NX<br>
 * ̃NX̃CX^X{@link RunTimeServlet }̎sɐ܂B
 * 
 * 2004/6/9 {@link wisdom.core.application.IHandler}̃CX^Xϐւ̒ǉ
 * @author  Takao Kouda
 * @version 1
 */
public abstract class RequestCommand extends CoreObject implements IRequestCommand {

	/** 
	 * R}hIۂ̃tOłB
	 * 2dTu~bgpɎgp܂B
	 */
	private ProcessController procesController = null;	
	/**
	 * TuNXŎgpł{@link MessageGenerator }̃CX^XłB
	 * {@link AppMessageGenerator }ɂȂ܂B
	 */
	protected MessageGenerator messageGenerator = null;

	/** 
	 * R}hIۂ̃tOłB
	 * 2dTu~bgpɎgp܂B
	 */
	private boolean finished = false;
	
	private String page = null;
	/**
	 * y[WHttpServletResponse.sendRedirect(String)gp邩ۂ
	 * lfalsełBgpꍇ̓TuNXtrueɕύXĂB
	 */
	private boolean useRedirect = false;
	
	/**
	 * t@C̃_E[hꍇforwordAsendRedirectgpȂꍇɎgp܂B
	 * lfalsełBgpꍇ̓TuNXtrueɕύXĂB
	 */
	private IResponseDownLoader downLoader = null;

	/**
	 * TuNXŎgpł{@link IHandler}NX̃CX^XB
	 */
	protected IHandler h = null;
	
	/**
	 * TuNXŎgpł{@link IRequestHandler}NX̃CX^XB
	 */
	protected IRequestHandler rh = null;
	/**
	 * TuNXŎgpłHttpServletRequestNX̃CX^XB
	 */
	protected HttpServletRequest req = null;
	/**
	 * TuNXŎgpł {@link IRequestParser }NX̃CX^XB
	 */
	protected IRequestParser rp = null;
	
	/**
	 * RXgN^<br>
	 * ɃCX^XϐłMessageGenerator̃CX^XA{@link #setMessageGenerator(MessageGenerator) setMessageGenetator}AppMessageGenerator<br>
	 * ̃CX^XŐݒ肵܂B
	 *
	 */
	public RequestCommand() { 
		super(); 
		setMessageGenerator(AppMessageGenerator.getInstance());
	}
	
	/**
	 * {@link RunTimeServlet }ɂs܂B
	 * 
	 * @param rh RequestHandler̃CX^X
	 * @return sʂ̖߂y[W
	 * @exception Exception 
	 */
	public final String execute(RequestHandler rh) throws Exception {
		req = rh.getRequest();
		rp = rh.getRequestParser();
		this.rh = rh;
		this.h = rh;
		
		String tid = rp.getString("tid",null);
		if (tid == null) trace("execute","executing.....");
		else trace("execute","executing.....(" + tid+")");
		
		try {
			
			_execute();
			
		} catch (Exception e) {
			
			throw e;
			
		} finally {
			if (procesController != null) {
				procesController.notifyCommandFinished(rh);
			}
			finished = true;
		}
		if (tid == null) trace("execute","executed");
		else trace("execute","executed(" + tid+")");
		return page;		
	}
	public void setPage(String page) {
		this.page = page;
	}
	/**
	 * R}hs钊ۃ\bhł<br>
	 * AvP[VTuNX͂̃\bhĂB<br>
	 *
	 * @exception Exception 
	 */
	protected abstract void _execute() throws Exception;

	public void setUseRedirect(boolean useRedirect) {
		this.useRedirect = useRedirect;
	}
	public IResponseDownLoader getDownLoader() throws Exception {
		this.downLoader = new ResponseDownLoader(rh.getResponse());
		return downLoader;
	}
	public String getName() {
		return getClass().getName();
	}	
	/**
	 * R}hŎgpCX^XϐmessageGeneratorݒ肵܂B<br>
	 * 
	 * @param	messageGenerator	MessageGenerator̃CX^X
	 */
	public void setMessageGenerator(MessageGenerator messageGenerator) {
		this.messageGenerator = messageGenerator;
	}

	/**
	 * <i>̃\bh{@link RunTimeServlet }ɂgp܂BAvP[VŎgp邱Ƃ͂܂B</i>
	 * @return	R}hs̑y[WB
	 */
	public String sendPage() { return page; }
	/**
	 * <i>̃\bh{@link RunTimeServlet }ɂgp܂BAvP[VŎgp邱Ƃ͂܂B</i>
	 */
	public boolean isUseRedirect() {
		return useRedirect;
	}
	/**
	 * <i>̃\bh{@link RunTimeServlet }ɂgp܂BAvP[VŎgp邱Ƃ͂܂B</i>
	 */
	public boolean isUseDownLoad() {
		return downLoader != null;
	}
	/**
	 * <i>̃\bh{@link RunTimeServlet }ɂgp܂BAvP[VŎgp邱Ƃ͂܂B</i>
	 */
	public void toFinished() { this.finished = true;}
	/**
	 * <i>̃\bh{@link RunTimeServlet }ɂgp܂BAvP[VŎgp邱Ƃ͂܂B</i>
	 */
	public ProcessController getProcesController() {
		return procesController;
	}
	/**
	 * <i>̃\bh{@link RunTimeServlet }ɂgp܂BAvP[VŎgp邱Ƃ͂܂B</i>
	 */
	public void setProcesController(ProcessController procesController) {
		this.procesController = procesController;
	}

}