package wisdom.core.connections;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.sql.DataSource;

import wisdom.core.CoreObject;
import wisdom.core.ConfigManager;
/**
 *
 * RlNVEv[p̊NX<br>
 * ̃NX͒ۃNXłBNXɃf[^x[XփANZX邽߂Data SourceA[U[Ȃǂ
 * \t@C擾܂BeWebApplicationAo[WɂقȂ̓IȃRlNVEv[ENX
 * ̃NXpč쐬܂B
 *
 * @author  Takao Kouda
 * @version 0.90, 1/1/2001
 */
public abstract class ConnectionManager extends CoreObject {
	/** DataSrouceIuWFNg ̃IuWFNg setDataSourceŐݒ肵ĂB*/
	protected DataSource ds = null;

	/** f[^\[X ̕ϐConfigManageroRŃNXE[hɎ擾܂B*/
	protected String datasource = null;

	/** f[^x[X ̕ϐConfigManageroRŃNXE[hɎ擾܂B*/
	protected String dbname = null;

	/** [U[ ̕ϐConfigManageroRŃNXE[hɎ擾܂B */
	protected String user = null;

	/** [U[pX[h ̕ϐConfigManageroRŃNXE[hɎ擾܂B*/
	protected String password = null;
	
	/** JDBChCo[ */
	protected String driverName = null;

	/** JDBChCo[ŎgpURL */
	protected String url = null;
	
	/** gpConfigManager	*/
	protected ConfigManager cm = null;
	
	/** Xe[gg̎N[YgpB̕ϐConfigManageroRŃNXE[hɎ擾܂B*/
	protected boolean isAutoClose = true;

	/** Xe[gg̃g[XgpB̕ϐConfigManageroRŃNXE[hɎ擾܂B*/
	protected boolean isStmtTrace = false;
	

	/**
	 * RXgN^
	 * @throws Exception 
	 */	
	public ConnectionManager() throws Exception {
		super();
	}
	/**
	 * IuWFNg̏ݒs܂B<br>
	 * @param	def	ݒɎgpConnectionDef̃CX^X
	 */
	protected void initial(ConnectionDef def) throws Exception {
		datasource 	= def.getDsname();
		dbname 		= def.getDbname();
		user 		= def.getUser();
		password 	= def.getPassword();
		isAutoClose = def.getStatementClose();
		isStmtTrace = def.getStatementTrace();
		ds 			= setDataSource();
		setDriverInfo();
		init();		
	}
	/**
	 * BCX^Xϐ擾\bhłB
	 */	
	private void init() throws Exception {
		inform("init", "Using DataSource     : " + datasource);
		inform("init", "Using DataBase Name  : " + dbname);		
		inform("init", "Statement auto close : " + isAutoClose);				
		inform("init", "Statement trace      : " + isStmtTrace);
		if (ds == null) {
			inform("init", "DataSource is not used. registered JDBC Driver is : " + driverName); 			
			inform("init", "                                   URL         is : " + url); 						
			Class.forName(driverName);
		}
	}	

	/**
	 * ConnectionIuWFNg擾܂B
	 * @return 		Connection 	ConnectionIuWFNg
	 * @exception 	Exception
	 * @deprecated				̃\bh͊ǗpAg[XpConnectiongp getConnection(Object invoker)
	 *							ɒu܂B
	 */	
	public Connection getConnection() throws Exception {
		Connection c = null;
		c = new ConnectionStateHolder(c);
		
		if (ds == null) {
			c = DriverManager.getConnection(url + dbname , user, password);
		} else {
			c = ds.getConnection(user, password);
		}

		c = new ConnectionStateHolder(c);		
		c.setAutoCommit(false);
		return c;

	}
	/**
	 * ConnectionIuWFNg擾܂B
	 * @param 	invoker		ĂяõR}hNX
	 * @return 	Connection 	ConnectionIuWFNg
	 * @exception Exception
	 */	
	public Connection getConnection(Object invoker) throws Exception {
		Connection c = null;

		if (ds == null) {
			c = DriverManager.getConnection(url + dbname , user, password);
		} else {
// 2003/8/19 WAS5Ή
//			c = ds.getConnection(user, password);
			c = ds.getConnection();
		}
		
		c = new ConnectionStateHolder(c);
		
		if (isStmtTrace) {
			c = new TraceConnection(invoker, c);
		}
		if (isAutoClose) {
			c = new ManagedConnection(invoker, c);		
		}
		c.setAutoCommit(false);
		return c;

	}

	/**
	 * ConnectionIuWFNg擾܂B
	 * @param 		user 		[U[ID
	 * @param 		password 	pX[h
	 * @return 		Connection 	ConnectionIuWFNg
	 * @exception Exception
	 * @deprecated				̃\bh͊ǗpAg[XpConnectiongp 
	 *							getConnection(Object invoker, String user, String password)
	 *							ɒu܂B
	 */	
	public Connection getConnection(String user, String password) throws Exception {
		Connection c = null;
				
		if (ds == null) {
			c = DriverManager.getConnection(url + dbname , user, password);
		} else {
			c = ds.getConnection(user, password);
		}
		c = new ConnectionStateHolder(c);
					
		c.setAutoCommit(false);
		return c;
	}
	
	/**
	 * ConnectionIuWFNg擾܂B
	 * @param 		invoker		ĂяõR}hNX	 
	 * @param 		user 		[U[ID
	 * @param 		password 	pX[h
	 * @return Connection ConnectionIuWFNg
	 * @exception Exception
	 */	
	public Connection getConnection(Object invoker, String user, String password) throws Exception {
		Connection c = null;
				
		if (ds == null) {
			c = DriverManager.getConnection(url + dbname , user, password);
		} else {
			c = ds.getConnection(user, password);
		}
		c = new ConnectionStateHolder(c);
		
		if (isStmtTrace) {
			c = new TraceConnection(invoker, c);
		}
		if (isAutoClose) {
			c = new ManagedConnection(invoker, c);		
		}
		
		c.setAutoCommit(false);
		return c;
	}
	/**
	 * DataSourceIuWFNgݒ肵܂B̃\bh̓NXE[hɎs܂B
	 * @return DataSource
	 * @exception Exception	 
	 */
	protected DataSource setDataSource() throws Exception {
		return null;
	}

	/**
	 * JDBCDriver̖O擾܂B̃\bh̓NXE[hɎs܂B
	 * @return 			String
	 * @exception Exception	 
	 */
	protected void setDriverInfo() throws Exception{}	
	
}

		