package wisdom.core.connections;

import java.util.Map;
import java.util.Properties;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Struct;

import wisdom.core.CoreObject;
/**
 *
 * java.sql.Connection bvAConnectionIuWFNg̏ԂێNXłB
 * ̃NXł́AConnection擾ɂConnection̏ԂێAclose()ꂽƂɁA擾ꂽԂɖ߂܂B
 * 
 *
 * @author  Takao Kouda
 * @version 1
 */
public class ConnectionStateHolder extends CoreObject implements Connection {
	private Connection c = null;
	private boolean autoCommit = false;
	private String catalog = null;
	private boolean readOnly = false;
	private int transactionIsoration = -1;
	private Map typeMap = null;
	
	/**
	 * RXgN^
	 * @param		c			bvConnectionIuWFNg
	 */	
	public ConnectionStateHolder(Connection c)  throws Exception {
		super();
		this.c = c;
		this.autoCommit = c.getAutoCommit();
		this.catalog 	= c.getCatalog();
		this.readOnly	= c.isReadOnly();
		this.transactionIsoration = c.getTransactionIsolation();
//		this.typeMap 	= c.getTypeMap();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				Statement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public Statement createStatement() throws SQLException{
		return c.createStatement();
	}

    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param		sql		1 ȏ '?' IN p[^v[Xz_[܂߂邱Ƃł SQL 
     * @return 				vRpCꂽ܂ސV PreparedStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public PreparedStatement prepareStatement(String sql) throws SQLException{
		return c.prepareStatement(sql);
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param		sql		1 ȏ '?' p[^v[Xz_[܂߂邱Ƃł SQL Bʏ킱́̕AJBDC ֐ĂяõGXP[vł
     * @return 				vRpCꂽ SQL ܂ސV CallableStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public CallableStatement prepareCall(String sql) throws SQLException{
		return c.prepareCall(sql);
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param		sql		1 ȏ '?' p[^v[Xz_[܂߂邱Ƃł SQL 
     * @return 				̌̃̕tH[
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public String nativeSQL(String sql) throws SQLException{
		return c.nativeSQL(sql);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	 autoCommit	 true ̏ꍇ͎R~bgLAfalse ̏ꍇ͎R~bg
     * @exception f[^x[XANZXG[ꍇ
     */
	public void setAutoCommit(boolean autoCommit) throws SQLException{
		c.setAutoCommit(autoCommit);
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 	݂̎R~bg[h̏
     * @exception 	f[^x[XANZXG[ꍇ
     */
	public boolean getAutoCommit() throws SQLException {
		return c.getAutoCommit();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void commit() throws SQLException {
		c.commit();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void rollback() throws SQLException {
		c.rollback(); 
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void close() throws SQLException {
		c.setAutoCommit(autoCommit);
		c.setCatalog(catalog);
		c.setReadOnly(readOnly);
		c.setTransactionIsolation(transactionIsoration);
//		c.setTypeMap(typeMap);
		c.close();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return Connection N[YĂꍇ trueA܂I[v̏Ԃ̏ꍇ false
     * @exception f[^x[XANZXG[ꍇ
     */
	public boolean isClosed() throws SQLException {
		return c.isClosed();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return Connection ɑ΂ DatabaseMetaData IuWFNg
     * @exception f[^x[XANZXG[ꍇ
     */
	public DatabaseMetaData getMetaData() throws SQLException {
		return c.getMetaData(); 
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	readOnly	true ̏ꍇ͓ǂݍݐp[hLAfalse ̏ꍇ͓ǂݍݐp[h
     * @exception f[^x[XANZXG[ꍇ
     */
	public void setReadOnly(boolean readOnly) throws SQLException {
		c.setReadOnly(readOnly);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return Connection ǂݍݐp[h̏ꍇ trueAłȂꍇ false
     * @exception f[^x[XANZXG[ꍇ
     */
	public boolean isReadOnly() throws SQLException {
		return c.isReadOnly();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception f[^x[XANZXG[ꍇ
     */
	public void setCatalog(String catalog) throws SQLException {
		c.setCatalog(catalog);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return		݂̃J^O܂ null
     * @exception f[^x[XANZXG[ꍇ
     */
	public String getCatalog() throws SQLException {
		return c.getCatalog();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param 	level TRANSACTION_NONE  TRANSACTION_* Ւfl 1 Bf[^x[XɂẮAق̒lT|[gȂ̂
     * @exception f[^x[XANZXG[ꍇ
     */
	public void setTransactionIsolation(int level) throws SQLException {
		c.setTransactionIsolation(level);
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return ݂TRANSACTION [hl
     * @exception f[^x[XANZXG[ꍇ
     */
	public int getTransactionIsolation() throws SQLException {
		return c.getTransactionIsolation();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return ŏ SQLWarning ܂ null
     * @exception f[^x[XANZXG[ꍇ
     */
	public SQLWarning getWarnings() throws SQLException {
		return c.getWarnings(); 
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception f[^x[XANZXG[ꍇ
     */
	public void clearWarnings() throws SQLException {
		c.clearWarnings();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	resultSetType	 		ʃZbg̃^CvBResultSet.TYPE_XXX Q
     * @param 	resultSetConcurrency 	s̎ށBResultSet.CONCUR_XXX Q
     * @return 				V Statement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
		return c.createStatement(resultSetType,resultSetConcurrency);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	resultSetType	 		ʃZbg̃^CvBResultSet.TYPE_XXX Q
     * @param 	resultSetConcurrency 	s̎ށBResultSet.CONCUR_XXX Q
     * @return 				vRpCꂽ SQL ܂ސV PreparedStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
		return c.prepareStatement(sql,resultSetType,resultSetConcurrency);
	}

    /**
     * ConnectionĂ铯\bhs܂B
	 *	
     * @param	resultSetType	 		ʃZbg̃^CvBResultSet.TYPE_XXX Q
     * @param 	resultSetConcurrency 	s̎ށBResultSet.CONCUR_XXX Q
     * @return 				vRpCꂽ SQL ܂ސV CallableStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
		return c.prepareCall(sql,resultSetType,resultSetConcurrency);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				 Connection IuWFNgɊ֘A java.util.Map IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public java.util.Map getTypeMap() throws SQLException {
		return c.getTypeMap();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	map	 Connection IuWFNg̃ftHǧ^}bv̑ƂăCXg[ java.util.Map IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void setTypeMap(java.util.Map map) throws SQLException {
		c.setTypeMap(map);
	}
	
	// Java 6 Api
	public void setClientInfo(String name, String value) throws SQLClientInfoException {
		c.setClientInfo(name,value);
	}
	public void setClientInfo(Properties properties) throws SQLClientInfoException {
		c.setClientInfo(properties);
	}
	public String getClientInfo(String name)  throws SQLException {
		return c.getClientInfo(name);
	}
	public Properties getClientInfo() throws SQLException {
		return c.getClientInfo();
	}
	public Array createArrayOf(String typeName,Object[] elements) throws SQLException {
		return c.createArrayOf(typeName, elements);
	}
	public Clob createClob()  throws SQLException {
		return c.createClob();
	}
	public Blob createBlob()  throws SQLException {
		return c.createBlob();
	}
	public NClob createNClob()  throws SQLException {
		return c.createNClob();
	}
	public SQLXML createSQLXML()  throws SQLException {
		return c.createSQLXML();
	}	
	public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)
									            throws SQLException {
		return c.createStatement(resultSetType,resultSetConcurrency,resultSetHoldability);
	}
	public Struct createStruct(String typeName, Object[] attributes)throws SQLException {
		return c.createStruct(typeName,attributes);
	}
	public void setHoldability(int holdability) throws SQLException {
		c.setHoldability(holdability);
	}
	public int getHoldability() throws SQLException {
		return c.getHoldability();
	}
	public boolean isValid(int timeout) throws SQLException {
		return c.isValid(timeout);
	}
	public CallableStatement prepareCall(String sql,
								            int resultSetType,
								            int resultSetConcurrency,
								            int resultSetHoldability) throws SQLException{
		return c.prepareCall(sql,resultSetType,resultSetConcurrency,resultSetHoldability);
	}
	public PreparedStatement prepareStatement(String sql,
								            int resultSetType,
								            int resultSetConcurrency,
								            int resultSetHoldability) throws SQLException {
		return c.prepareStatement(sql,resultSetType,resultSetConcurrency,resultSetHoldability);
	}
	public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)throws SQLException {
		return c.prepareStatement(sql,autoGeneratedKeys);
	}
	public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
		return c.prepareStatement(sql,columnIndexes);
	}
	public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
		return c.prepareStatement(sql,columnNames);
	}
	public void releaseSavepoint(Savepoint savepoint) throws SQLException {
		c.releaseSavepoint(savepoint);
	}
	public void rollback(Savepoint savepoint) throws SQLException {
		c.rollback(savepoint);
	}
	public Savepoint setSavepoint() throws SQLException {
		return c.setSavepoint();
	}
	public Savepoint setSavepoint(String name) throws SQLException {
		return c.setSavepoint(name);
	}
	// java.sql.Wrapper
	public boolean isWrapperFor(Class iface) throws SQLException {
		return c.isWrapperFor(iface);
	}
	public Object  unwrap(Class iface) throws SQLException {
		return c.unwrap(iface);
	}

}

		