package wisdom.core.connections;

import java.util.*;
import java.sql.*;

import wisdom.core.CoreObject;


/**
 * java.sql.Statement bvAN[Y̊ǗManaginConnectionŎNXB
 * 
 * @author  TK
 * @version 0.90, 1/1/2001
 */
public class ManagedStatement extends CoreObject implements Statement {
	private Object invoker = null;	
	protected String sql = null;	
	private Statement stmt = null;
	private Vector vecrs = null;
	private boolean closed = false;

	/**
	 * RXgN^
	 */	
	public ManagedStatement(Object invoker,Statement stmt)  {
		super();
		this.invoker = invoker;				
		this.stmt = stmt;
	}
	
    /**
     * StatementĂ铯\bhs܂B
     *
     * @param 		sql		ʏÓI SQL SELECT 
     * @return 				w肳ꂽNG[ɂč쐬ꂽf[^܂ ResultSet IuWFNgBnull ɂ͂ȂȂ
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public ResultSet executeQuery(String sql) throws SQLException {
		this.sql = sql;
		ManagedResultSet mrs = new ManagedResultSet(invoker, stmt.executeQuery(sql));
		if (vecrs == null) vecrs = new Vector();
		vecrs.add(mrs);
		return mrs;
	}

    /**
     * StatementĂ铯\bhs܂B
     *
     * @param 		sql		SQL INSERT AUPDATE A܂ DELETE A邢͉ԂȂ SQL 
     * @return 				INSERT AUPDATE ADELETE ̏ꍇ͍sBԂȂ SQL ̏ꍇ 0
     * @exception 			f[^x[XANZXG[ꍇ
     */      
	public int executeUpdate(String sql) throws SQLException {
		this.sql = sql;
		return stmt.executeUpdate(sql);
	}
 
    /**
     * StatementĂ铯\bhs܂B
     * 
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public void close() throws SQLException {
		closeCheck();
		stmt.close();
		closed = true;
	}
 
    /**
     * StatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public int getMaxFieldSize() throws SQLException {
		return stmt.getMaxFieldSize();
	}
 
 
    /**
     * StatementĂ铯\bhs܂B
     *
     * @param 		max		VőTCY̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxFieldSize(int max) throws SQLException {
		stmt.setMaxFieldSize(max);
	}

    /**
     * StatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */ 
	public int getMaxRows() throws SQLException {
		return stmt.getMaxRows();
	}
 
    /**
     * StatementĂ铯\bhs܂B
     * @param 		max		Vős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxRows(int max) throws SQLException {
		stmt.setMaxRows(max);
	}

    /**
     * StatementĂ铯\bhs܂B
     * @param 		enable	Lɂꍇ trueAɂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setEscapeProcessing(boolean enable) throws SQLException {
		stmt.setEscapeProcessing(enable);
	}

    /**
     * StatementĂ铯\bhs܂B
     *
     * @return 				݂̃NG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public int getQueryTimeout() throws SQLException {
		return stmt.getQueryTimeout();
	}
    
    /**
     * StatementĂ铯\bhs܂B
     * 
     * @param 		seconds	VNG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setQueryTimeout(int seconds) throws SQLException {
		stmt.setQueryTimeout(seconds);
	}
    
    /**
     * StatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void cancel() throws SQLException {
		stmt.cancel();
	}
    
    /**
     * StatementĂ铯\bhs܂B
     *
     * @return 				IuWFNg܂ null
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public SQLWarning getWarnings() throws SQLException {
		return stmt.getWarnings();
	}
 
    /**
     * StatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void clearWarnings() throws SQLException {
		stmt.clearWarnings();
	}
 
    /**
     * StatementĂ铯\bhs܂B
     * 
     * @param 		name	VJ[\BڑňӂɂKv
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setCursorName(String name) throws SQLException {
		stmt.setCursorName(name);
	}
  
    /**
     * StatementĂ铯\bhs܂B
     * @param 		sql		Cӂ SQL 
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */  
	public boolean execute(String sql) throws SQLException {
		return stmt.execute(sql);
	}
 
 
    /**
     * StatementĂ铯\bhs܂B
     *
     * @return 				ResultSet IuWFNgƂĂ݂̌̌ʁBXVJEgł邩A܂͌ʂȂꍇ null
     * @exception 			f[^x[XANZXG[ꍇ
     */       
	public ResultSet getResultSet() throws SQLException {
		return stmt.getResultSet();
	}
 
    /**
     * StatementĂ铯\bhs܂B
     *
     * @return 				XVJEgĂ݂̌̌ʁB݂̌ʂ ResultSet IuWFNgł邩A܂͌ʂȂꍇ -1
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getUpdateCount() throws SQLException {
		return stmt.getUpdateCount();
	}
    
    /**
     * StatementĂ铯\bhs܂B
     *
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public boolean getMoreResults() throws SQLException {
		return stmt.getMoreResults();
	}
    
    /**
     * StatementĂ铯\bhs܂B
     *
     * @param direction	s鏉
     * @exception 			f[^x[XANZXG[ꍇA܂͎w肳ꂽ ResultSet.FETCH_FORWARDAResultSet.FETCH_REVERSEA܂ ResultSet.FETCH_UNKNOWN ̂ǂłȂꍇ
     */     
	public void setFetchDirection(int direction) throws SQLException {
		stmt.setFetchDirection(direction);
	}
    
 
    /**
     * StatementĂ铯\bhs܂B
     *
     * @return 				 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getFetchDirection() throws SQLException {
		return stmt.getFetchDirection();
	}
    
    /**
     * StatementĂ铯\bhs܂B
     *
     * @param 		rows	tFb`s 
     * @exception 			f[^x[XANZXG[ꍇA܂͏ 0 <= rows <= this.getMaxRows() Ȃꍇ
     */   
	public void setFetchSize(int rows) throws SQLException {
		stmt.setFetchSize(rows);
	}

    /**
     * StatementĂ铯\bhs܂B
     *
     * @return 			 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`TCY
     * @exception 		f[^x[XANZXG[ꍇ
     */
	public int getFetchSize() throws SQLException {
		return stmt.getFetchSize();
	}

    /**
     * StatementĂ铯\bhs܂B
     *
     * @return			ResultSet.CONCUR_READ_ONLY ܂ ResultSet.CONCUR_UPDATABLE
     */    
	public int getResultSetConcurrency() throws SQLException {
		return stmt.getResultSetConcurrency();
	}
    
    /**
     * StatementĂ铯\bhs܂B
     *
     * @return		 		ResultSet.TYPE_FORWARD_ONLYAResultSet.TYPE_SCROLL_INSENSITIVEA܂ ResultSet.TYPE_SCROLL_SENSITIVE ̂ 1 
     */    
	public int getResultSetType()  throws SQLException {
		return stmt.getResultSetType();
	}
    
    /**
     * StatementĂ铯\bhs܂B
     *
     * @param 		sql 	ʏÓI SQL INSERT A܂ UPDATE 
     * @exception 			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
	public void addBatch(String sql) throws SQLException {
		stmt.addBatch(sql);
	}
	/**
     * StatementĂ铯\bhs܂B
	 * 
	 * @exception  	f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
	 */
	public void clearBatch() throws SQLException {
		stmt.clearBatch();
	}

	/**
     * StatementĂ铯\bhs܂B
     *
     * @return 				ob`̃R}hƂ 1 ̗vfi[ĂXVJEg̔zB
     *						z̗vf̓R}hob`ɒǉꂽŕׂB
     * @exception			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
    public int[] executeBatch() throws SQLException {
		return stmt.executeBatch();
	}

	/**
     * StatementĂ铯\bhs܂B
     *
     * @return 				̕𐶐ڑ
     * @exception			f[^x[XANZXG[ꍇ
     */
	public Connection getConnection()  throws SQLException {
		return stmt.getConnection(); 
	}
	
	/**
	 * StatementcloseĂ邩ׂ܂B
	 * @return 				StatementcloseĂꍇtrueB
	 */
	public boolean isClosed() {
		return closed;
	} 
	/**
     * ResultSetcloseĂ邩ׂ܂B
     * AN[YĂȂResultSetꍇɂ́Ã\bhɂN[YsAxo͂܂B
     */	
	private void closeCheck()  {
		StringBuffer sb = new StringBuffer();
		/* ResultSetIuWFNg̃`FbN */
		if (vecrs != null) {
			for (Iterator i = vecrs.iterator(); i.hasNext() ;) {
				ManagedResultSet rs = (ManagedResultSet)i.next();
				if (!rs.isClosed()) {
					sb.append("\n\t\t\t -> ")
					.append(rs.getClass().getName())
					.append("(").append(rs.hashCode()).append(")")
					.append(" (Statement) ")
					.append(sql)
					.append("\n\t\t\t\t -> ");
					try {
						rs.close();
						sb.append("closed.");
					} catch (SQLException sqe) {
						sb.append("failured to close\t").append(sqe.getMessage());
					}
				}
				rs.toNull();
				rs = null;
			}
		}

		if (sb.length() == 0) { return; }

		warning(new StringBuffer("\n[warning] Some SQL statement resources ware not closed, attempted to close below \n")
							.append("\n           invoker class : ").append(invoker.getClass().getName())
							.append(sb.toString())
				);
	}
	protected void toNull() {
		stmt = null;		
	}
	// java 1.6 
	public boolean getMoreResults(int current) throws SQLException {
		return stmt.getMoreResults(current);
	}
	public ResultSet getGeneratedKeys() throws SQLException {
		ManagedResultSet mrs = new ManagedResultSet(invoker, stmt.getGeneratedKeys());
		if (vecrs == null) vecrs = new Vector();
		vecrs.add(mrs);
		return mrs;
	}
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		return stmt.executeUpdate(sql, autoGeneratedKeys);
	}
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		return stmt.executeUpdate(sql, columnIndexes);
	}
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		return stmt.executeUpdate(sql, columnNames);
	}
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		return stmt.execute(sql, autoGeneratedKeys);
	}
	public boolean execute(String sql,  int[] columnIndexes) throws SQLException {
		return stmt.execute(sql, columnIndexes);
	}
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		return stmt.execute(sql, columnNames);
	}
	public int getResultSetHoldability() throws SQLException {
		return stmt.getResultSetHoldability();
	}
	public void setPoolable(boolean poolable) throws SQLException {
		stmt.setPoolable(poolable);
	}
	public boolean isPoolable() throws SQLException {
		return stmt.isPoolable();
	}
	// java.sql.Wrapper
	public boolean isWrapperFor(Class iface) throws SQLException {
		return stmt.isWrapperFor(iface);
	}
	public Object  unwrap(Class iface) throws SQLException {
		return stmt.unwrap(iface);
	}	
	
}
