package wisdom.core.connections;

import java.util.*;
import java.sql.*;
import java.io.*;

import wisdom.core.CoreObject;
import wisdom.core.Log;
import wisdom.core.LogFactory;


/**
 * java.sql.Connection bvAConnectionNXŎsďg[XNXB
 * 
 * @author  Takao Kouda 
 * @version 0.90, 1/1/2001
 */
public class TraceConnection extends CoreObject implements Connection {
	private Object invoker = null;
	private Connection c = null;
			
	private Log l = LogFactory.create();
	private TraceHelper th = TraceHelper.getInstance();
	private PrintWriter out = null;

	/**
	 * RXgN^
	 * @throws Exception 
	 */	
	public TraceConnection(Object invoker, Connection c) throws Exception {
		super();
		this.invoker = invoker;		
		this.c = c;
		out = l.getWriter();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				Statement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public Statement createStatement() throws SQLException{
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createStatement()"));
		out.flush();
		return new TraceStatement(invoker, c.createStatement());
	}

    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param		sql		1 ȏ '?' IN p[^v[Xz_[܂߂邱Ƃł SQL 
     * @return 				vRpCꂽ܂ސV PreparedStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public PreparedStatement prepareStatement(String sql) throws SQLException{
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareStatement(sql)", sql));
		out.flush();		
		return new TracePreparedStatement(invoker, c.prepareStatement(sql));
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param		sql		1 ȏ '?' p[^v[Xz_[܂߂邱Ƃł SQL Bʏ킱́̕AJBDC ֐ĂяõGXP[vł
     * @return 				vRpCꂽ SQL ܂ސV CallableStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public CallableStatement prepareCall(String sql) throws SQLException{
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareCall(sql)", sql));		
		out.flush();		
		return c.prepareCall(sql);
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param		sql		1 ȏ '?' p[^v[Xz_[܂߂邱Ƃł SQL 
     * @return 				̌̃̕tH[
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public String nativeSQL(String sql) throws SQLException{
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "nativeSQL(sql)", sql));				
		out.flush();		
		return c.nativeSQL(sql);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	autoCommit true ̏ꍇ͎R~bgLAfalse ̏ꍇ͎R~bg
     * @exception f[^x[XANZXG[ꍇ
     */
	public void setAutoCommit(boolean autoCommit) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setAutoCommit(autoCommit)", new Boolean(autoCommit).toString()));
		out.flush();		
		c.setAutoCommit(autoCommit);
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				݂̎R~bg[h̏
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public boolean getAutoCommit() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getAutoCommit()"));		
		out.flush();		
		return c.getAutoCommit();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void commit() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "commit()"));				
		out.flush();		
		c.commit();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void rollback() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "rollback()"));
		out.flush();		
		c.rollback(); 
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void close() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "close()"));
		out.flush();		
		c.close();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				Connection N[YĂꍇ trueA܂I[v̏Ԃ̏ꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public boolean isClosed() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "isClosed()"));
		out.flush();		
		return c.isClosed();
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				 Connection ɑ΂ DatabaseMetaData IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public DatabaseMetaData getMetaData() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getMetaData()"));		
		out.flush();		
		return c.getMetaData(); 
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	readOnly	true ̏ꍇ͓ǂݍݐp[hLAfalse ̏ꍇ͓ǂݍݐp[h
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void setReadOnly(boolean readOnly) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setReadOnly(readOnly)", new Boolean(readOnly).toString()));				
		out.flush();		
		c.setReadOnly(readOnly);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				Connection ǂݍݐp[h̏ꍇ trueAłȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public boolean isReadOnly() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "isReadOnly()" ));
		out.flush();		
		return c.isReadOnly();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void setCatalog(String catalog) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setCatalog(catalog)",catalog));		
		out.flush();		
		c.setCatalog(catalog);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return				݂̃J^O܂ null
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public String getCatalog() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getCatalog()"));
		out.flush();		
		return c.getCatalog();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param 		level	TRANSACTION_NONE  TRANSACTION_* Ւfl 1 Bf[^x[XɂẮAق̒lT|[gȂ̂
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void setTransactionIsolation(int level) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setTransactionIsolation(level)", Integer.toString(level)));		
		out.flush();		
		c.setTransactionIsolation(level);
	}
	
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				݂ TRANSACTION_* [hl
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public int getTransactionIsolation() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getTransactionIsolation()"));				
		out.flush();		
		return c.getTransactionIsolation();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				ŏ SQLWarning ܂ null
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public SQLWarning getWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getWarnings()"));		
		out.flush();
		return c.getWarnings(); 
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void clearWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "clearWarnings()"));				
		out.flush();
		c.clearWarnings();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	resultSetType	 		ʃZbg̃^CvBResultSet.TYPE_XXX Q
     * @param 	resultSetConcurrency 	s̎ށBResultSet.CONCUR_XXX Q
     * @return 				V Statement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createStatement(resultSetType,resultSetConcurrency)"
						+ resultSetType+" "+ resultSetConcurrency));
		out.flush();
		return new TraceStatement(invoker, c.createStatement(resultSetType,resultSetConcurrency));
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	resultSetType	 		ʃZbg̃^CvBResultSet.TYPE_XXX Q
     * @param 	resultSetConcurrency 	s̎ށBResultSet.CONCUR_XXX Q
     * @return 				vRpCꂽ SQL ܂ސV PreparedStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareStatement(sql,resultSetType,resultSetConcurrency)"
						+ sql + " " + resultSetType+" "+ resultSetConcurrency));
		out.flush();
		return new TracePreparedStatement(invoker, c.prepareStatement(sql,resultSetType,resultSetConcurrency));
	}

    /**
     * ConnectionĂ铯\bhs܂B
	 *	
     * @param	resultSetType	 		ʃZbg̃^CvBResultSet.TYPE_XXX Q
     * @param 	resultSetConcurrency 	s̎ށBResultSet.CONCUR_XXX Q
     * @return 				vRpCꂽ SQL ܂ސV CallableStatement IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareCall(sql, resultSetType,resultSetConcurrency)"
						+ sql + " " + resultSetType+" "+ resultSetConcurrency));
		out.flush();
		return c.prepareCall(sql,resultSetType,resultSetConcurrency);
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @return 				 Connection IuWFNgɊ֘A java.util.Map IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public java.util.Map getTypeMap() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getTypeMap()"));						
		out.flush();
		return c.getTypeMap();
	}
    /**
     * ConnectionĂ铯\bhs܂B
     *
     * @param	map			 Connection IuWFNg̃ftHǧ^}bv̑ƂăCXg[ java.util.Map IuWFNg
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public void setTypeMap(java.util.Map map) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setTypeMap(map)", map.toString()));								
		out.flush();
		c.setTypeMap(map);
	}
	
	// Java 6 Api
	public void setClientInfo(String name, String value) throws SQLClientInfoException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setClientInfo(name,value)"+name+" "+value));
		out.flush();
		c.setClientInfo(name,value);
	}
	public void setClientInfo(Properties properties) throws SQLClientInfoException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setClientInfo(properties)"+properties));
		out.flush();
		c.setClientInfo(properties);
	}
	public String getClientInfo(String name)  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getClientInfo(name)"+name));
		out.flush();
		return c.getClientInfo(name);
	}
	public Properties getClientInfo() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getClientInfo()"));
		out.flush();
		return c.getClientInfo();
	}
	public Array createArrayOf(String typeName,Object[] elements) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createArrayOf(typeName,elements)"+typeName+" "+elements));
		out.flush();
		return c.createArrayOf(typeName, elements);
	}
	public Clob createClob()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createClob()"));
		out.flush();
		return c.createClob();
	}
	public Blob createBlob()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createBlob()"));
		out.flush();
		return c.createBlob();
	}
	public NClob createNClob()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createNClob()"));
		out.flush();
		return c.createNClob();
	}
	public SQLXML createSQLXML()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createSQLXML()"));
		out.flush();
		return c.createSQLXML();
	}	
	public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)
									            throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createStatement(resultSetType,resultSetConcurrency,resultSetHoldability)"
						+resultSetType+" "+resultSetConcurrency+" "+resultSetHoldability));
		out.flush();
		return new TraceStatement(invoker, c.createStatement(resultSetType,resultSetConcurrency,resultSetHoldability));
	}
	public Struct createStruct(String typeName, Object[] attributes)throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "createStruct(typeName,attributes)"+typeName+" "+attributes));
		out.flush();
		return c.createStruct(typeName,attributes);
	}
	public void setHoldability(int holdability) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setHoldability(holdability)"+holdability));
		out.flush();
		c.setHoldability(holdability);
	}
	public int getHoldability() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "getHoldability()"));
		out.flush();
		return c.getHoldability();
	}
	public boolean isValid(int timeout) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "isValid(timeout)"+timeout));
		out.flush();
		return c.isValid(timeout);
	}
	public CallableStatement prepareCall(String sql,
								            int resultSetType,
								            int resultSetConcurrency,
								            int resultSetHoldability) throws SQLException{
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareCall(sql,resultSetType,resultSetConcurrency,resultSetHoldability)"
						+sql+" "+resultSetType+" "+resultSetConcurrency+" "+resultSetHoldability));

		out.flush();
		return c.prepareCall(sql,resultSetType,resultSetConcurrency,resultSetHoldability);
	}
	public PreparedStatement prepareStatement(String sql,
								            int resultSetType,
								            int resultSetConcurrency,
								            int resultSetHoldability) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareStatement(sql,resultSetType,resultSetConcurrency,resultSetHoldability)"
						+sql+" "+resultSetType+" "+resultSetConcurrency+" "+resultSetHoldability));
		out.flush();
		// TODO
		return c.prepareStatement(sql,resultSetType,resultSetConcurrency,resultSetHoldability);
	}
	public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareStatement(sql,autoGeneratedKeys)"+sql+" "+autoGeneratedKeys));
		out.flush();
		return c.prepareStatement(sql,autoGeneratedKeys);
	}
	public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareStatement(sql,columnIndexes)"+sql+" "+columnIndexes));
		out.flush();
		return new TracePreparedStatement(invoker, c.prepareStatement(sql,columnIndexes));
	}
	public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "prepareStatement(sql,columnNames)"+sql+" "+columnNames));
		out.flush();
		return new TracePreparedStatement(invoker, c.prepareStatement(sql,columnNames));
	}
	public void releaseSavepoint(Savepoint savepoint) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "releaseSavepoint(savepoint)"+savepoint));
		out.flush();
		c.releaseSavepoint(savepoint);
	}
	public void rollback(Savepoint savepoint) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "rollback(savepoint)"+savepoint));
		out.flush();
		c.rollback(savepoint);
	}
	public Savepoint setSavepoint() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setSavepoint()"));
		out.flush();
		return c.setSavepoint();
	}
	public Savepoint setSavepoint(String name) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "setSavepoint(name)"+name));
		out.flush();
		return c.setSavepoint(name);
	}
	// java.sql.Wrapper
	public boolean isWrapperFor(Class iface) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "isWrapperFor(iface)"+iface));
		out.flush();
		return c.isWrapperFor(iface);
	}
	public Object  unwrap(Class iface) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.CONNECTION, "unwrap( iface)"+iface));
		out.flush();
		return c.unwrap(iface);
	}	
}

		