package wisdom.core.connections;

import java.util.*;

import wisdom.core.CoreObject;
import wisdom.core.Log;
import wisdom.core.LogFactory;
import wisdom.core.LogImpl;


/**
 * Statement̃g[X𐶐wpENXB
 * 
 *
 * @author  Takao Kouda 
 * @version 0.90, 1/1/2001
 */
public class TraceHelper extends CoreObject  {
	private static final String SQL_TRACE = "SQL_TRACE";
	
	protected static final int CONNECTION = 0;
	protected static final int STATEMENT = 1;
	protected static final int PREPARED_STATEMENT = 2;
	protected static final int RESULTSET = 3;

	private static final String[] NAME = {"CONN","STMT","PRE_STMT","RESULTSET"};

	private static final Log l = LogFactory.create();

	private static final TraceHelper th = new TraceHelper();

	private TraceHelper() { super();}

	protected static TraceHelper getInstance() {
		return th;
	}
	
	protected String header(Object stmt, Object invoker, int type, String methodName) {
		return 
		new StringBuffer(LogImpl.mkLogHeader(invoker, SQL_TRACE))
			.append(NAME[type])
			.append("(").append(stmt.hashCode()).append(").")
			.append(methodName).toString();
	}
	protected String header(Object stmt, Object invoker, int type, String methodName, String traceString) {
		return 
		new StringBuffer(LogImpl.mkLogHeader(invoker, SQL_TRACE))
			.append(NAME[type])
			.append("(").append(stmt.hashCode()).append(").")			
			.append(methodName).append(" > ").append(traceString).toString();
	}
	protected String header(Object stmt, Object invoker, int type, String methodName, String traceString, Object returnValue) {
		if (returnValue == null) returnValue = "null";
		return 
		new StringBuffer(LogImpl.mkLogHeader(invoker, SQL_TRACE))
			.append(NAME[type])
			.append("(").append(stmt.hashCode()).append(").")			
			.append(methodName).append(" > ").append(traceString)
			.append(" , value=[").append(returnValue.toString()).append("]")
			.toString();
	}
}
